/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.serializer;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.pattern.PTRegexTool;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.maf.rpp.kernel.Element;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacCallLine;
import com.ibm.pdp.mdl.pacbase.PacClass;
import com.ibm.pdp.mdl.pacbase.PacFeature;
import com.ibm.pdp.mdl.pacbase.PacField;
import com.ibm.pdp.mdl.pacbase.PacFilter;
import com.ibm.pdp.mdl.pacbase.PacLimitToValues;
import com.ibm.pdp.mdl.pacbase.PacRequestLine;
import com.ibm.pdp.mdl.pacbase.PacSearchRequest;
import com.ibm.pdp.mdl.pacbase.PacTitleLine;
import com.ibm.pdp.mdl.pacbase.PacVisionValues;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacPublishSerializerLabel;
import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import com.ibm.pdp.pac.volume.pattern.PacVolumePattern;
import com.ibm.pdp.pac.volume.serializer.IPacVolumeTags;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PacXMLVolumeSerializer
implements IPacPublishingTags,
IPacVolumeTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacVolumePattern _pattern;

    private static String getId(RadicalElement radicalElement) {
        StringBuilder buffer = new StringBuilder(radicalElement.getProject());
        if (radicalElement.getPackage() != null && radicalElement.getPackage().length() > 0) {
            buffer.append("/").append(radicalElement.getPackage().replace('.', '/'));
        }
        buffer.append("/").append(radicalElement.getName());
        String metaType = null;
        if (metaType != null && metaType.length() > 0) {
            buffer.append(".").append(metaType);
        }
        buffer.append(".").append(radicalElement.getClass().getSimpleName());
        return buffer.toString();
    }

    private static boolean isClassRetained(Object object, Set<String> classes) {
        if (classes == null) {
            return true;
        }
        if (object instanceof Element) {
            ArrayList superclasses = new ArrayList();
            Class<?> clazz = object.getClass();
            superclasses.add(clazz);
            while (clazz != RadicalElement.class && clazz != Element.class) {
                if (clazz.getInterfaces().length <= 0) continue;
                clazz = clazz.getInterfaces()[0];
                superclasses.add(clazz);
            }
            for (Class clazz2 : superclasses) {
                if (!classes.contains(clazz2.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFeatureRetained(Method method, Map<String, Set<String>> allRetainedFeatures) {
        if (allRetainedFeatures == null || allRetainedFeatures.size() == 0) {
            return true;
        }
        if (method.getName().startsWith("get")) {
            String featureName = method.getName().substring(3).toLowerCase();
            ArrayList superclasses = new ArrayList();
            Class<?> clazz = method.getDeclaringClass();
            superclasses.add(clazz);
            while (clazz != RadicalElement.class && clazz != Element.class) {
                if (clazz.getInterfaces().length <= 0) continue;
                clazz = clazz.getInterfaces()[0];
                superclasses.add(clazz);
            }
            for (Class clazz2 : superclasses) {
                Set<String> retainedFeatures;
                if (!allRetainedFeatures.containsKey(clazz2.getName()) || (retainedFeatures = allRetainedFeatures.get(clazz2.getName())).size() != 0 && !retainedFeatures.contains(featureName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMethodSelected(Method method, SelectCriteria selectCriteria) {
        if (selectCriteria == null || selectCriteria.getDescription() == null || selectCriteria.getDescription().length() == 0) {
            return true;
        }
        String relationName = method.getName().replace("get", "").toLowerCase();
        return relationName.equals(selectCriteria.getDescription());
    }

    private static boolean isValueSelected(Object value, Map<String, Method> methods, SelectCriteria selectCriteria) {
        if (selectCriteria == null || selectCriteria.getDescription() == null || selectCriteria.getWhereFields().size() == 0) {
            return true;
        }
        for (PacField pacField : selectCriteria.getWhereFields()) {
            StringBuilder buffer = new StringBuilder("get");
            buffer.append(pacField.getName());
            Method method = methods.get(buffer.toString());
            if (method != null) {
                Object attValue = null;
                try {
                    attValue = method.invoke(value, null);
                }
                catch (Exception exception) {
                    return false;
                }
                if (attValue != null && PacXMLVolumeSerializer.isValueMatch(pacField, attValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isValueMatch(PacField pacField, Object value) {
        boolean match = false;
        String regexExpression = PTRegexTool.getRegexExpression((String)pacField.getValue());
        Pattern pattern = Pattern.compile(regexExpression);
        if (value instanceof String) {
            match = pattern.matcher((String)value).matches();
        } else if (value.getClass().isEnum()) {
            String sValue = value.toString();
            if (sValue.startsWith("_")) {
                sValue = sValue.substring(1);
            }
            match = pattern.matcher(sValue).matches();
        } else {
            match = true;
        }
        return match;
    }

    private static Set<String> getRetainedProjects(PTLocation location, String context, PacVisionValues vision) {
        PTNature nature;
        HashSet<String> retainedProjects = new HashSet<String>();
        retainedProjects.add(context);
        if ((vision.getValue() == 1 || vision.getValue() == 3) && (nature = PTNature.getNature((String)context)) != null && nature.getLocation().equals(location.getName())) {
            retainedProjects.addAll(nature.getRequiredPaths());
        }
        if (vision.getValue() == 2 || vision.getValue() == 3) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                PTNature nature2 = PTNature.getNature((String)project.getName());
                if (nature2 != null && nature2.getLocation().equals(location.getName())) {
                    for (String path : nature2.getRequiredPaths()) {
                        if (!path.equals(context)) continue;
                        retainedProjects.add(project.getName());
                        break;
                    }
                }
                ++n2;
            }
        }
        return retainedProjects;
    }

    private static boolean isDocumentMatch(Pattern pattern, Document metaDocument, PacLimitToValues limitTo) {
        boolean match = false;
        if (limitTo.getValue() == 0) {
            match = pattern.matcher(metaDocument.getName()).matches();
        } else if (limitTo.getValue() != 2 && limitTo.getValue() != 1) {
            if (limitTo.getValue() == 4) {
                match = pattern.matcher(metaDocument.getLabel()).matches();
            } else if (limitTo.getValue() == 3 && metaDocument.hasKeywords()) {
                for (String metaKeyword : metaDocument.getKeywords()) {
                    if (!pattern.matcher(metaKeyword).matches()) continue;
                    match = true;
                    break;
                }
            }
        }
        return match;
    }

    public PacXMLVolumeSerializer(PacVolumePattern pattern) {
        this._pattern = pattern;
    }

    public void serializeTableContents(PacVolume volume, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:volume");
        xmlWriter.writeAttribute("name", volume.getName());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("rpp:tablecontents");
        for (Object object : volume.getDLines()) {
            if (!(object instanceof PacTitleLine)) continue;
            PacTitleLine titleLine = (PacTitleLine)object;
            xmlWriter.writeStartElement("rpp:link");
            xmlWriter.writeAttribute("text", titleLine.getText());
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    public IStatus serializeTitleLine(PacTitleLine titleLine, int titlePosition, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:line");
        xmlWriter.writeAttribute("type", "titleLine");
        xmlWriter.writeAttribute("position", Integer.toString(titlePosition));
        xmlWriter.writeAttribute("level", Integer.toString(titleLine.getLevel()));
        xmlWriter.writeAttribute("text", titleLine.getText());
        xmlWriter.writeEndElement();
        return null;
    }

    public IStatus serializeCallLine(PacCallLine callLine, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:line");
        xmlWriter.writeAttribute("type", "callLine");
        RadicalEntity calledObject = callLine.getCalledInstance();
        String designId = calledObject.getDesignId(calledObject.getProject());
        String[] tokens = MetadataService.getTokens((String)designId);
        IMAFModelService mafService = MAFModelManager.getServiceInstance();
        RadicalElement radicalElement = mafService.getRadicalElement(tokens[0], tokens[1], tokens[3], tokens[2], tokens[4]);
        if (radicalElement == null) {
            Object[] array = new String[]{designId};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._LOAD_ARTIFACT, array);
            return new Status(4, "org.eclipse.ui", 0, msg, null);
        }
        SelectCriteria selectCriteria = new SelectCriteria(callLine.getDescription(), (List<?>)callLine.getWhereFields());
        Set<String> classes = this.getClasses(callLine.getFilter());
        Map<String, Set<String>> retainedFeatures = this.getRetainedFeatures(callLine.getFilter());
        this.serialize(radicalElement, selectCriteria, classes, retainedFeatures, xmlWriter);
        xmlWriter.writeEndElement();
        return null;
    }

    public IStatus serializeRequestLine(PacRequestLine requestLine, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (!(requestLine.getRequest() instanceof PacSearchRequest)) {
            return null;
        }
        xmlWriter.writeStartElement("rpp:line");
        xmlWriter.writeAttribute("type", "requestLine");
        PacSearchRequest searchRequest = (PacSearchRequest)requestLine.getRequest();
        String regexExpression = PTRegexTool.getRegexExpression((String)searchRequest.getExpression());
        int regexFlags = PTRegexTool.getRegexFlags((boolean)searchRequest.isCaseSensitive());
        Pattern pattern = Pattern.compile(regexExpression, regexFlags);
        PTLocation location = PTModelManager.getLocation((String)requestLine.getLocation());
        Set<String> retainedProjects = null;
        if (searchRequest.getContext().length() > 0) {
            retainedProjects = PacXMLVolumeSerializer.getRetainedProjects(location, searchRequest.getContext(), searchRequest.getVision());
        }
        ArrayList<Document> metaDocuments = new ArrayList<Document>();
        for (String checkedType : searchRequest.getSearchFor()) {
            List elements = location.getByFolder(checkedType);
            for (PTElement element : elements) {
                Document metaDocument = element.getDocument();
                if (retainedProjects != null && !retainedProjects.contains(metaDocument.getProject()) || !PacXMLVolumeSerializer.isDocumentMatch(pattern, metaDocument, searchRequest.getLimitTo())) continue;
                metaDocuments.add(metaDocument);
            }
        }
        for (Document metaDocument : metaDocuments) {
            String type;
            String name;
            String metaType;
            String packageName;
            String projectName;
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = metaDocument.getProject(), packageName = metaDocument.getPackage(), metaType = metaDocument.getMetaType(), name = metaDocument.getName(), type = metaDocument.getType());
            if (radicalElement == null) {
                Object[] array = new String[]{metaDocument.getId()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._LOAD_ARTIFACT, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
            Set<String> classes = this.getClasses(requestLine.getFilter());
            Map<String, Set<String>> retainedFeatures = this.getRetainedFeatures(requestLine.getFilter());
            this.serialize(radicalElement, null, classes, retainedFeatures, xmlWriter);
        }
        xmlWriter.writeEndElement();
        return null;
    }

    private Set<String> getClasses(PacFilter pacFilter) {
        HashSet<String> classes = null;
        if (pacFilter != null) {
            classes = new HashSet<String>();
            for (String className : pacFilter.getClasses()) {
                classes.add(className);
            }
        }
        return classes;
    }

    private Map<String, Set<String>> getRetainedFeatures(PacFilter pacFilter) {
        HashMap retainedFeatures = null;
        if (pacFilter != null) {
            retainedFeatures = new HashMap();
            for (PacClass pacClass : pacFilter.getRetainedClasses()) {
                HashSet<String> features = new HashSet<String>();
                for (PacFeature pacFeature : pacClass.getRetainedFeatures()) {
                    features.add(pacFeature.getName());
                }
                retainedFeatures.put(pacClass.getName(), features);
            }
        }
        return retainedFeatures;
    }

    private void serialize(RadicalElement radicalElement, SelectCriteria selectCriteria, Set<String> classes, Map<String, Set<String>> retainedFeatures, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:" + radicalElement.getClass().getSimpleName().toLowerCase());
        xmlWriter.writeAttribute("id", PacXMLVolumeSerializer.getId(radicalElement));
        this.serializeComposition((Element)radicalElement, selectCriteria, classes, retainedFeatures, xmlWriter);
        xmlWriter.writeEndElement();
    }

    private void serializeComposition(Element element, SelectCriteria selectCriteria, Set<String> classes, Map<String, Set<String>> retainedFeatures, XMLStreamWriter xmlWriter) throws XMLStreamException {
        Method method;
        Method[] methods = element.getClass().getInterfaces()[0].getMethods();
        int i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && PacSchemaItem.getKind(method) == PacSchemaItem.SchemaItemKind._ATTRIBUTE && PacXMLVolumeSerializer.isFeatureRetained(method, retainedFeatures)) {
                this.serializeAttribute(element, method, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
        i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && !PacSchemaItem.isMultiple(method) && PacSchemaItem.isChildOf(method.getReturnType(), Element.class) && PacXMLVolumeSerializer.isFeatureRetained(method, retainedFeatures)) {
                this.serializeUnaryRelation(element, method, null, retainedFeatures, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
        i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && PacSchemaItem.isMultiple(method) && PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), Element.class) && (!(element instanceof RadicalElement) || PacXMLVolumeSerializer.isMethodSelected(method, selectCriteria)) && PacXMLVolumeSerializer.isFeatureRetained(method, retainedFeatures)) {
                this.serializeMultipleRelation(element, selectCriteria, method, classes, retainedFeatures, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
    }

    private void serializeAttribute(Element element, Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attName = method.getName().replace("get", "").toLowerCase();
        Object attValue = null;
        try {
            attValue = method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        if (attValue != null && attValue.toString().trim().length() > 0) {
            xmlWriter.writeAttribute(attName, attValue.toString());
        }
    }

    private void serializeUnaryRelation(Element element, Method method, Set<String> classes, Map<String, Set<String>> retainedFeatures, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "").toLowerCase();
        Element value = null;
        try {
            value = (Element)method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        if (value instanceof Element) {
            StringBuilder buffer = new StringBuilder("rpp:");
            String declaringClassName = method.getDeclaringClass().getSimpleName().toLowerCase();
            buffer.append(declaringClassName).append("_").append(relationName);
            xmlWriter.writeStartElement(buffer.toString());
            this.serializeObject(value, null, classes, retainedFeatures, xmlWriter);
            xmlWriter.writeEndElement();
        }
    }

    private void serializeMultipleRelation(Element element, SelectCriteria selectCriteria, Method method, Set<String> classes, Map<String, Set<String>> retainedFeatures, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "").toLowerCase();
        List values = null;
        try {
            values = (List)method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        Class<?> clazz = PacSchemaItem.getGenericClass(method);
        HashMap<String, Method> methods = new HashMap<String, Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method met = methodArray[n2];
            methods.put(met.getName(), met);
            ++n2;
        }
        if (values != null && values.size() > 0) {
            for (Object value : values) {
                if (element instanceof RadicalElement && !PacXMLVolumeSerializer.isValueSelected(value, methods, selectCriteria) || !PacXMLVolumeSerializer.isClassRetained(value, classes)) continue;
                StringBuilder buffer = new StringBuilder("rpp:");
                String declaringClassName = method.getDeclaringClass().getSimpleName().toLowerCase();
                buffer.append(declaringClassName).append("_").append(relationName);
                xmlWriter.writeStartElement(buffer.toString());
                this.serializeObject(value, selectCriteria, classes, retainedFeatures, xmlWriter);
                xmlWriter.writeEndElement();
            }
        }
    }

    private void serializeObject(Object object, SelectCriteria selectCriteria, Set<String> classes, Map<String, Set<String>> retainedFeatures, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (object instanceof RadicalElement) {
            RadicalElement radicalElement = (RadicalElement)object;
            xmlWriter.writeAttribute("idref", PacXMLVolumeSerializer.getId(radicalElement));
        } else if (object instanceof Element) {
            Element element = (Element)object;
            xmlWriter.writeAttribute("xsi:type", element.getClass().getInterfaces()[0].getName());
            this.serializeComposition(element, selectCriteria, classes, retainedFeatures, xmlWriter);
        }
    }

    private class SelectCriteria {
        private String _description;
        private List<?> _whereFields;

        public SelectCriteria(String description, List<?> whereFields) {
            this._description = description;
            this._whereFields = whereFields;
        }

        public String getDescription() {
            return this._description;
        }

        public List<?> getWhereFields() {
            return this._whereFields;
        }
    }
}

