/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.serializer;

import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import com.ibm.pdp.pac.publishing.plugin.PacPublishingPlugin;
import com.ibm.pdp.pac.publishing.tool.PacMappingTool;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PacVolumeTransformer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _XSL = "xsl";
    private static final String _XML = "xml";
    private static final String _HTML = "html";
    private static final String _OUTPUT_TITLE = "output.title";
    private static final String _OUTPUT_CSS = "output.css";
    private static PacVolumeTransformer _instance = null;
    private Map<String, Transformer> _transformers = null;

    public static PacVolumeTransformer getInstance() {
        if (_instance == null) {
            _instance = new PacVolumeTransformer();
        }
        return _instance;
    }

    private static String getFileExtension(PacPublishingPattern.OutputFormat format) {
        if (format == PacPublishingPattern.OutputFormat._XML) {
            return _XML;
        }
        if (format == PacPublishingPattern.OutputFormat._HTML_FORM) {
            return _HTML;
        }
        return "";
    }

    private static String getFileName(Document metaDocument, PacPublishingPattern.OutputFormat format) {
        StringBuilder buffer = new StringBuilder(metaDocument.getName());
        if (metaDocument.getMetaType() != null && metaDocument.getMetaType().length() > 0) {
            buffer.append(".").append(metaDocument.getMetaType());
        }
        buffer.append(".").append(PacMappingTool.getMAFType(metaDocument.getType()));
        buffer.append(".").append(PacVolumeTransformer.getFileExtension(format));
        return buffer.toString();
    }

    private PacVolumeTransformer() {
    }

    public ByteArrayOutputStream transform(String styleSheet, InputStream xmlInputStream) throws TransformerException {
        Transformer transformer = this.getTransformer(styleSheet);
        ByteArrayOutputStream htmlOutputStream = new ByteArrayOutputStream();
        StreamSource xmlSource = new StreamSource(xmlInputStream);
        StreamResult htmlResult = new StreamResult(htmlOutputStream);
        transformer.transform(xmlSource, htmlResult);
        return htmlOutputStream;
    }

    public Transformer getTransformer(String styleSheet) throws TransformerConfigurationException {
        if (this._transformers == null) {
            this._transformers = new HashMap<String, Transformer>();
        }
        StringBuilder buffer = new StringBuilder(styleSheet);
        buffer.append(".").append(_XSL);
        String styleSheetId = buffer.toString();
        Transformer transformer = this._transformers.get(styleSheetId);
        if (transformer == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLVolumeInputStream(href);
                    return new StreamSource(xslInputStream);
                }
            });
            InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLVolumeInputStream(styleSheetId);
            if (xslInputStream != null) {
                StreamSource xslSource = new StreamSource(xslInputStream);
                transformer = factory.newTransformer(xslSource);
                transformer.setOutputProperty("indent", "yes");
                this._transformers.put(styleSheetId, transformer);
            }
        }
        return transformer;
    }
}

