/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.serializer;

import com.ibm.pdp.mdl.pacbase.PacCallLine;
import com.ibm.pdp.mdl.pacbase.PacRequestLine;
import com.ibm.pdp.mdl.pacbase.PacTitleLine;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.pac.publishing.plugin.PacPublishingPlugin;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacPublishSerializerLabel;
import com.ibm.pdp.pac.volume.pattern.PacVolumePattern;
import com.ibm.pdp.pac.volume.serializer.PacVolumeSerializerLabel;
import com.ibm.pdp.pac.volume.serializer.PacVolumeTransformer;
import com.ibm.pdp.pac.volume.serializer.PacXMLVolumeSerializer;
import com.ibm.pdp.pac.volume.wizard.PacVolumeWizardLabel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class PacVolumeSerializer
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _BUFFER_SIZE = 10000;
    private static final String _VOLUME_CSS = "volume.css";
    private static final String _VOLUME = "Volume";
    private PacVolumePattern _pattern;

    private static String getIdentifier(Object dLine) {
        String identifier = null;
        if (identifier == null) {
            identifier = dLine.getClass().getSimpleName();
        }
        return identifier;
    }

    public PacVolumeSerializer(PacVolumePattern pattern) {
        this._pattern = pattern;
    }

    private PacVolumePattern getPattern() {
        return this._pattern;
    }

    public List<IStatus> serialize(PacVolume volume, IProgressMonitor monitor) {
        List<IStatus> statusList = Collections.emptyList();
        if (this.getPattern()._outputFormat == PacVolumePattern.OutputFormat._XML) {
            statusList = this.serializeXMLInFile(volume, monitor);
        } else if (this.getPattern()._outputFormat == PacVolumePattern.OutputFormat._HTML) {
            statusList = this.serializeHTMLInFile(volume, monitor);
        }
        return statusList;
    }

    private List<IStatus> serializeXMLInFile(PacVolume volume, IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            ByteArrayOutputStream xmlStream = this.retrieveXMLStream(volume, statusList, monitor);
            IStatus status = this.writeFile(xmlStream);
            if (status != null) {
                statusList.add(status);
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private List<IStatus> serializeHTMLInFile(PacVolume volume, IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            IStatus status = this.serializeStyleSheet();
            if (status != null) {
                statusList.add(status);
                return statusList;
            }
            ByteArrayOutputStream xmlStream = this.retrieveXMLStream(volume, statusList, monitor);
            ByteArrayOutputStream htmlStream = null;
            try {
                monitor.beginTask(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._GENERATE_VOLUME), -1);
                monitor.subTask(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._XSL_TRANSFORMATION));
                PacVolumeTransformer transformer = PacVolumeTransformer.getInstance();
                htmlStream = transformer.transform(_VOLUME, new ByteArrayInputStream(xmlStream.toByteArray()));
            }
            catch (TransformerException e) {
                Object[] array = new String[]{_VOLUME, e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_FILE, array);
                statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
                return statusList;
            }
            status = this.writeFile(htmlStream);
            if (status != null) {
                statusList.add(status);
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private ByteArrayOutputStream retrieveXMLStream(PacVolume volume, List<IStatus> statusList, IProgressMonitor monitor) throws XMLStreamException {
        PacXMLVolumeSerializer serializer = new PacXMLVolumeSerializer(this.getPattern());
        IStatus status = null;
        monitor.beginTask(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._GENERATE_VOLUME), -1);
        ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
        serializer.serializeTableContents(volume, xmlWriter);
        monitor.beginTask(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._GENERATE_VOLUME), volume.getDLines().size());
        int nbLines = 0;
        int titlePosition = 0;
        for (Object dLine : volume.getDLines()) {
            try {
                if (dLine instanceof PacTitleLine) {
                    status = serializer.serializeTitleLine((PacTitleLine)dLine, ++titlePosition, xmlWriter);
                } else if (dLine instanceof PacCallLine) {
                    status = serializer.serializeCallLine((PacCallLine)dLine, xmlWriter);
                } else if (dLine instanceof PacRequestLine) {
                    status = serializer.serializeRequestLine((PacRequestLine)dLine, xmlWriter);
                }
            }
            catch (XMLStreamException e) {
                Object[] array = new String[]{PacVolumeSerializer.getIdentifier(dLine), e.getMessage()};
                String msg = PacVolumeSerializerLabel.getString(PacVolumeSerializerLabel._SERIALIZE_DLINE, array);
                status = new Status(4, "org.eclipse.ui", 0, msg, null);
            }
            if (status != null) {
                statusList.add(status);
            }
            if (monitor.isCanceled()) break;
            Object[] array = new String[]{Integer.toString(++nbLines)};
            monitor.subTask(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._NB_GENERATED_LINES, array));
            monitor.worked(1);
        }
        this.closeXMLWriter(xmlWriter);
        return xmlStream;
    }

    private XMLStreamWriter openXMLWriter(OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriter xmlWriter = null;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        xmlWriter = outputFactory.createXMLStreamWriter(outputStream);
        xmlWriter.writeStartDocument("1.0");
        xmlWriter.writeStartElement("rpp:publishing");
        xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.writeNamespace("rpp", "https://com.ibm.pdp.pac.publishing");
        return xmlWriter;
    }

    private void closeXMLWriter(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeEndElement();
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
    }

    private IStatus serializeStyleSheet() {
        InputStream cssInputStream = null;
        if (this.getPattern()._outputTarget == PacVolumePattern.OutputTarget._EXTERNAL) {
            StringBuilder buffer = new StringBuilder();
            Path path = new Path(this.getPattern()._fileExternalName);
            if (path.getDevice() != null) {
                buffer.append(path.getDevice());
            }
            int i = 0;
            while (i < path.segmentCount() - 1) {
                buffer.append("/").append(path.segment(i));
                ++i;
            }
            buffer.append("/").append(_VOLUME_CSS);
            try {
                try {
                    cssInputStream = PacPublishingPlugin.getDefault().getCSSInputStream();
                    File file = new File(buffer.toString());
                    if (!file.exists()) {
                        StringBuilder cssBuffer = new StringBuilder();
                        int c = 0;
                        while ((c = cssInputStream.read()) != -1) {
                            cssBuffer.append((char)c);
                        }
                        FileOutputStream fos = this.createExternalFile(buffer.toString());
                        BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
                        outputStreamBuffer.write(cssBuffer.toString().getBytes());
                        outputStreamBuffer.close();
                        fos.close();
                    }
                }
                catch (IOException e) {
                    Object[] array = new String[]{buffer.toString(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                    Status status = new Status(4, "org.eclipse.ui", 0, msg, null);
                    try {
                        cssInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    cssInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                cssInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private IStatus writeFile(ByteArrayOutputStream outputStream) {
        if (this.getPattern()._outputTarget == PacVolumePattern.OutputTarget._LOCAL) {
            StringBuilder buffer = new StringBuilder(this.getPattern()._fileLocalFolder);
            buffer.append("/").append(this.getPattern()._fileLocalName);
            try {
                this.createLocalFile(buffer.toString(), outputStream);
            }
            catch (CoreException e) {
                Object[] array = new String[]{buffer.toString(), e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        if (this.getPattern()._outputTarget == PacVolumePattern.OutputTarget._EXTERNAL) {
            try {
                FileOutputStream fos = this.createExternalFile(this.getPattern()._fileExternalName);
                BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
                outputStreamBuffer.write(outputStream.toByteArray());
                outputStreamBuffer.close();
                fos.close();
            }
            catch (IOException e) {
                Object[] array = new String[]{this.getPattern()._fileExternalName, e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        return null;
    }

    private void createLocalFile(String fileName, ByteArrayOutputStream fileContent) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(fileName));
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(fileContent.toByteArray()), 0, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.create((InputStream)new ByteArrayInputStream(fileContent.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private FileOutputStream createExternalFile(String fileName) throws FileNotFoundException {
        return new FileOutputStream(fileName);
    }
}

