/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.action;

import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.pac.publishing.PacPublishingLabel;
import com.ibm.pdp.pac.publishing.plugin.IPacVolumeContributor;
import com.ibm.pdp.pac.volume.wizard.PacVolumeGenerationWizard;
import com.ibm.pdp.util.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class PacVolumeGenerationAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _VOLUME_CONTRIBUTOR_EXTENSION_POINT = "volumeContributor";
    private IPacVolumeContributor _volumeContributor = null;
    private Document _metaDocument = null;

    public PacVolumeGenerationAction(Document metaDocument) {
        this._metaDocument = metaDocument;
        this.setText(PacPublishingLabel.getString(PacPublishingLabel._GENERATE_VOLUME));
        this.setToolTipText(this.getText());
        this.loadExtensionPoints(_VOLUME_CONTRIBUTOR_EXTENSION_POINT);
    }

    public void run() {
        if (this._metaDocument == null) {
            return;
        }
        PacVolumeGenerationWizard wizard = null;
        if (this._volumeContributor == null) {
            RadicalEntity radicalObject = PTResourceManager.loadResource((Document)this._metaDocument);
            if (radicalObject instanceof PacVolume) {
                PacVolume volume = (PacVolume)radicalObject;
                wizard = new PacVolumeGenerationWizard(volume);
            }
        } else {
            wizard = this._volumeContributor.getWizard(this._metaDocument.getProject(), this._metaDocument.getPackage(), this._metaDocument.getName(), this._metaDocument.getType());
        }
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private void loadExtensionPoints(String extensionPoint) {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint("com.ibm.pdp.pac.publishing", extensionPoint);
        if (extPoint != null) {
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(extensionPoint)) {
                        this.processConfigElement(configElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void processConfigElement(IConfigurationElement element) {
        try {
            if (element.getName().equals(_VOLUME_CONTRIBUTOR_EXTENSION_POINT)) {
                this._volumeContributor = (IPacVolumeContributor)element.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
    }
}

