/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard.page;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFolder;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTPackage;
import com.ibm.pdp.explorer.model.PTProject;
import com.ibm.pdp.explorer.model.tool.PTComparator;
import com.ibm.pdp.explorer.view.IPTStructuredViewer;
import com.ibm.pdp.explorer.view.actiongroup.PTDisplayActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSortActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTTopLevelActionGroup;
import com.ibm.pdp.explorer.view.provider.IPTContentProvider;
import com.ibm.pdp.explorer.view.provider.IPTLabelProvider;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.view.tool.PTViewerComparator;
import com.ibm.pdp.explorer.wizard.page.PTWizardPage;
import com.ibm.pdp.pac.publishing.dialog.PacDialogLabel;
import com.ibm.pdp.pac.publishing.dialog.PacEditSessionDialog;
import com.ibm.pdp.pac.publishing.model.PacPublishingManager;
import com.ibm.pdp.pac.publishing.model.PacPublishingSession;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.provider.PacPublishingContentProvider;
import com.ibm.pdp.pac.publishing.provider.PacPublishingLabelProvider;
import com.ibm.pdp.pac.publishing.provider.PacSessionLabelProvider;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;

public class PacPublishSessionWizardPage
extends PTWizardPage
implements IPTStructuredViewer,
IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _SESSION = 0;
    private static final int _HISTORY = 1;
    private Button _rdbSession;
    private Button _rdbHistory;
    private PageBook _pagebook;
    private Composite[] _panes;
    private Text _txtSessionTitle;
    private TreeViewer _trvSession;
    private Button _pbRemove;
    private TableViewer _tblHistory;
    private Button _pbHistoryDetails;
    private Button _pbRemoveHistory;
    private PacPublishingSession _editedSession;
    private PTLocation _editedLocation;
    private Set<PTElement> _removedElements;
    private Map<Date, PacPublishingSession> _editableHistorySessions = new HashMap<Date, PacPublishingSession>();
    private int _topLevelMode = 3;
    private int _sortMode = 1;
    private int _displayMode = 5;
    private PTTopLevelActionGroup _topLevelActionGroup;
    private PTSortActionGroup _sortActionGroup;
    private PTDisplayActionGroup _displayActionGroup;

    public PacPublishSessionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_SESSION_PAGE_TITLE));
        this.setDescription(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_SESSION_PAGE_DESC));
        this._prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");
        int[] topLevelModes = new int[]{1, 2, 3};
        this._topLevelActionGroup = new PTTopLevelActionGroup((IPTStructuredViewer)this, topLevelModes);
        int[] sortModes = new int[]{1, 2, 3};
        this._sortActionGroup = new PTSortActionGroup((IPTStructuredViewer)this, sortModes);
        int[] displayModes = new int[]{4, 8, 16};
        this._displayActionGroup = new PTDisplayActionGroup((IPTStructuredViewer)this, displayModes);
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.publish_session_def";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        composite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.setHelp(composite);
        this._rdbSession = PTWidgetTool.createRadioButton((Composite)composite, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._SESSION), (boolean)false);
        this._rdbSession.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbSession);
        this._rdbHistory = PTWidgetTool.createRadioButton((Composite)composite, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._HISTORY), (boolean)false);
        this._rdbHistory.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbHistory);
        this._pagebook = new PageBook(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        gridData.heightHint = 400;
        this._pagebook.setLayoutData((Object)gridData);
        this._panes = new Composite[2];
        this._panes[0] = this.createSessionPane((Composite)this._pagebook);
        this._panes[1] = this.createHistoryPane((Composite)this._pagebook);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.setControl((Control)composite);
    }

    private Composite createSessionPane(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        this._topLevelMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_TOP_LEVEL", this._topLevelMode);
        this._sortMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_SORT", this._sortMode);
        this._displayMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_DISPLAY", this._displayMode);
        PTWidgetTool.createLabel((Composite)composite, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._SESSION_TITLE));
        this._txtSessionTitle = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtSessionTitle);
        this._trvSession = PTWidgetTool.createTreeViewer((Composite)composite, (boolean)true, (int)2);
        this._trvSession.setUseHashlookup(true);
        this._trvSession.setContentProvider((IContentProvider)new PacPublishingContentProvider(this.getTopLevelMode()));
        this._trvSession.setLabelProvider((IBaseLabelProvider)new PacPublishingLabelProvider(this.getDisplayMode()));
        this._trvSession.setComparator((ViewerComparator)new PTViewerComparator(this.getSortMode()));
        this._trvSession.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PacPublishSessionWizardPage.this._pbRemove.setEnabled(selection.size() > 0);
            }
        });
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._REMOVE);
        this._pbRemove = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)false);
        this._pbRemove.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.addSelectionListener(this._pbRemove);
        this.createContextMenu(this._trvSession.getControl());
        return composite;
    }

    private Composite createHistoryPane(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        this._tblHistory = new TableViewer(composite, 2052);
        this._tblHistory.setUseHashlookup(true);
        this._tblHistory.setLabelProvider((IBaseLabelProvider)new PacSessionLabelProvider());
        this._tblHistory.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this._tblHistory.getControl().setLayoutData((Object)gridData);
        this._tblHistory.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PacPublishSessionWizardPage.this._pbHistoryDetails.setEnabled(selection.size() > 0);
                PacPublishSessionWizardPage.this._pbRemoveHistory.setEnabled(selection.size() > 0);
                PacPublishSessionWizardPage.this.setPageComplete(PacPublishSessionWizardPage.this.isPageComplete());
            }
        });
        this._tblHistory.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PacPublishSessionWizardPage.this.openHistory();
            }
        });
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._HISTORY_DETAILS);
        this._pbHistoryDetails = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)false);
        this._pbHistoryDetails.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.addSelectionListener(this._pbHistoryDetails);
        pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._REMOVE);
        this._pbRemoveHistory = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)false);
        this._pbRemoveHistory.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.addSelectionListener(this._pbRemoveHistory);
        return composite;
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacPublishSessionWizardPage.this._topLevelActionGroup.fillMenu(menu);
                PacPublishSessionWizardPage.this._topLevelActionGroup.check(PacPublishSessionWizardPage.this.getTopLevelMode());
                menu.add((IContributionItem)new Separator(PTSortActionGroup._SEPARATOR));
                PacPublishSessionWizardPage.this._sortActionGroup.fillMenu(menu);
                PacPublishSessionWizardPage.this._sortActionGroup.check(PacPublishSessionWizardPage.this.getSortMode());
                PacPublishSessionWizardPage.this._displayActionGroup.fillMenu(menu);
                PacPublishSessionWizardPage.this._displayActionGroup.check(PacPublishSessionWizardPage.this.getDisplayMode());
                menu.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu contextMenu = menuMgr.createContextMenu(control);
        control.setMenu(contextMenu);
    }

    protected void handleModifyText(ModifyEvent e) {
        if (e.widget == this._txtSessionTitle) {
            this._editedSession.setTitle(this._txtSessionTitle.getText());
        }
    }

    protected void handleButtonSelected(SelectionEvent e) {
        IStructuredSelection selection;
        if (e.widget == this._rdbSession) {
            if (this._rdbSession.getSelection()) {
                this._pagebook.showPage((Control)this._panes[0]);
                this.setPageComplete(this.isPageComplete());
            }
        } else if (e.widget == this._rdbHistory) {
            if (this._rdbHistory.getSelection()) {
                this._pagebook.showPage((Control)this._panes[1]);
                this.setPageComplete(this.isPageComplete());
            }
        } else if (e.widget == this._pbRemove) {
            Shell shell = this.getShell();
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            IStructuredSelection selection2 = (IStructuredSelection)this._trvSession.getSelection();
            HashSet<PTElement> removedElements = new HashSet<PTElement>(selection2.size());
            for (Object object : selection2) {
                if (object instanceof PTFolder) {
                    removedElements.addAll(((PTFolder)object).getElements());
                    continue;
                }
                if (object instanceof PTPackage) {
                    removedElements.addAll(((PTPackage)object).getElements());
                    continue;
                }
                if (object instanceof PTProject) {
                    removedElements.addAll(((PTProject)object).getElements());
                    continue;
                }
                if (!(object instanceof PTElement)) continue;
                removedElements.add((PTElement)object);
            }
            this.getRemovedElements().addAll(removedElements);
            for (PTElement element : removedElements) {
                this.getEditedLocation().removeElement(element);
            }
            this.refresh();
            this.setPageComplete(this.isPageComplete());
            shell.setCursor(null);
        } else if (e.widget == this._pbHistoryDetails) {
            this.openHistory();
        } else if (e.widget == this._pbRemoveHistory && (selection = (IStructuredSelection)this._tblHistory.getSelection()).size() > 0) {
            Object selectedObject = selection.getFirstElement();
            PacPublishingManager.getSessions().remove(selectedObject);
            this.setPageComplete(this.isPageComplete());
            this._tblHistory.refresh();
        }
    }

    private void openHistory() {
        PacPublishingSession editedSession = this.getEditableSessionFromHistory();
        if (editedSession != null) {
            String dateLabel = "?";
            if (editedSession.getDate() != null) {
                dateLabel = editedSession.getDate().toString();
            }
            Object[] array = new String[]{editedSession.getTitle(), dateLabel};
            String sessionLabel = PacDialogLabel.getString(PacDialogLabel._HISTORY_SESSION_LABEL, array);
            PacEditSessionDialog sessionDialog = new PacEditSessionDialog(this.getShell(), sessionLabel, editedSession.getEditableLocation());
            if (sessionDialog.open() == 0) {
                this.getShell().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
                for (PTElement removedElement : sessionDialog.getRemovedElements()) {
                    editedSession.removeDocument(removedElement.getDocument());
                }
                this.getShell().setCursor(null);
            }
        }
    }

    public boolean isPageComplete() {
        if (this._rdbSession.getSelection() && this.getEditedLocation().getElements().size() == 0) {
            this.setErrorMessage(PacPublishWizardLabel.getString(PacPublishWizardLabel._EMPTY_SESSION));
            return false;
        }
        if (this._rdbHistory.getSelection() && ((IStructuredSelection)this._tblHistory.getSelection()).size() == 0) {
            if (PacPublishingManager.getSessions().size() > 0) {
                this.setErrorMessage(PacPublishWizardLabel.getString(PacPublishWizardLabel._SELECT_HISTORY));
            } else {
                this.setErrorMessage(PacPublishWizardLabel.getString(PacPublishWizardLabel._EMPTY_HISTORY));
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void setupData() {
        this._editedSession = PacPublishingManager.getSession();
        this._editedLocation = this._editedSession.getEditableLocation();
        this._trvSession.setInput((Object)this.getEditedLocation());
        this._tblHistory.setInput(PacPublishingManager.getSessions());
    }

    public PacPublishingSession getEditedSession() {
        PacPublishingSession session = this._editedSession;
        if (this._rdbHistory.getSelection()) {
            session = this.getEditableSessionFromHistory();
        }
        return session;
    }

    private PacPublishingSession getEditableSessionFromHistory() {
        PacPublishingSession historySession;
        PacPublishingSession editableSession = null;
        IStructuredSelection selection = (IStructuredSelection)this._tblHistory.getSelection();
        if (selection.size() > 0 && (editableSession = this._editableHistorySessions.get((historySession = (PacPublishingSession)selection.getFirstElement()).getDate())) == null) {
            editableSession = historySession.duplicate();
            this._editableHistorySessions.put(historySession.getDate(), editableSession);
        }
        return editableSession;
    }

    public PTLocation getEditedLocation() {
        return this._editedLocation;
    }

    public Set<PTElement> getRemovedElements() {
        if (this._removedElements == null) {
            this._removedElements = new HashSet<PTElement>();
        }
        return this._removedElements;
    }

    public void refresh() {
        if (this._trvSession != null) {
            this._trvSession.refresh();
        }
    }

    public int getTopLevelMode() {
        return this._topLevelMode;
    }

    public void setTopLevelMode(int topLevelMode) {
        this._topLevelMode = topLevelMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_TOP_LEVEL", this.getTopLevelMode());
        IContentProvider contentProvider = this._trvSession.getContentProvider();
        if (contentProvider instanceof IPTContentProvider) {
            ((IPTContentProvider)contentProvider).setTopLevelMode(this.getTopLevelMode());
        }
    }

    public int getSortMode() {
        return this._sortMode;
    }

    public void setSortMode(int sortMode) {
        this._sortMode = sortMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_SORT", this.getSortMode());
        PTViewerComparator sorter = (PTViewerComparator)this._trvSession.getComparator();
        ((PTComparator)sorter.getComparator()).setSortMode(this.getSortMode());
    }

    public int getDisplayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_DISPLAY", this.getDisplayMode());
        IBaseLabelProvider labelProvider = this._trvSession.getLabelProvider();
        if (labelProvider instanceof IPTLabelProvider) {
            ((IPTLabelProvider)labelProvider).setDisplayMode(this.getDisplayMode());
        }
    }

    public void updatePreferences() {
    }
}

