/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard.page;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFolder;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTPackage;
import com.ibm.pdp.explorer.model.PTProject;
import com.ibm.pdp.explorer.model.tool.PTComparator;
import com.ibm.pdp.explorer.view.IPTStructuredViewer;
import com.ibm.pdp.explorer.view.actiongroup.PTDisplayActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSortActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTTopLevelActionGroup;
import com.ibm.pdp.explorer.view.provider.IPTContentProvider;
import com.ibm.pdp.explorer.view.provider.IPTLabelProvider;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.view.tool.PTViewerComparator;
import com.ibm.pdp.explorer.wizard.page.PTWizardPage;
import com.ibm.pdp.pac.publishing.model.PacPublishingSession;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.provider.PacPublishingContentProvider;
import com.ibm.pdp.pac.publishing.provider.PacPublishingLabelProvider;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PacPublishSelectionWizardPage
extends PTWizardPage
implements IPTStructuredViewer,
IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text _txtSessionTitle;
    private TreeViewer _trvViewer = null;
    private Button _pbRemove;
    private PacPublishingSession _session;
    private PTLocation _editedLocation;
    private Set<PTElement> _removedElements;
    private int _topLevelMode = 3;
    private int _sortMode = 1;
    private int _displayMode = 5;
    private PTTopLevelActionGroup _topLevelActionGroup;
    private PTSortActionGroup _sortActionGroup;
    private PTDisplayActionGroup _displayActionGroup;

    public PacPublishSelectionWizardPage(String pageName, PacPublishingSession publishedSession) {
        super(pageName);
        this.setTitle(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_SELECTION_PAGE_TITLE));
        this.setDescription(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_SELECTION_PAGE_DESC));
        this._prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");
        int[] topLevelModes = new int[]{1, 2, 3};
        this._topLevelActionGroup = new PTTopLevelActionGroup((IPTStructuredViewer)this, topLevelModes);
        int[] sortModes = new int[]{1, 2, 3};
        this._sortActionGroup = new PTSortActionGroup((IPTStructuredViewer)this, sortModes);
        int[] displayModes = new int[]{4, 8, 16};
        this._displayActionGroup = new PTDisplayActionGroup((IPTStructuredViewer)this, displayModes);
        this._session = publishedSession;
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.publish_def";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        this.setHelp(composite);
        this._topLevelMode = this._prefs.getInt("_PREF_PUBLISH_SELECTION_PAGE_TOP_LEVEL", this._topLevelMode);
        this._sortMode = this._prefs.getInt("_PREF_PUBLISH_SELECTION_PAGE_SORT", this._sortMode);
        this._displayMode = this._prefs.getInt("_PREF_PUBLISH_SELECTION_PAGE_DISPLAY", this._displayMode);
        PTWidgetTool.createLabel((Composite)composite, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._SESSION_TITLE));
        this._txtSessionTitle = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtSessionTitle);
        this._trvViewer = PTWidgetTool.createTreeViewer((Composite)composite, (boolean)true, (int)2);
        this._trvViewer.setUseHashlookup(true);
        this._trvViewer.setContentProvider((IContentProvider)new PacPublishingContentProvider(this.getTopLevelMode()));
        this._trvViewer.setLabelProvider((IBaseLabelProvider)new PacPublishingLabelProvider(this.getDisplayMode()));
        this._trvViewer.setComparator((ViewerComparator)new PTViewerComparator(this.getSortMode()));
        this._trvViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PacPublishSelectionWizardPage.this._pbRemove.setEnabled(selection.size() > 0);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        this._trvViewer.getControl().setLayoutData((Object)gridData);
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._REMOVE);
        this._pbRemove = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)false);
        this._pbRemove.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.addSelectionListener(this._pbRemove);
        this.createContextMenu(this._trvViewer.getControl());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.setControl((Control)composite);
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacPublishSelectionWizardPage.this._topLevelActionGroup.fillMenu(menu);
                PacPublishSelectionWizardPage.this._topLevelActionGroup.check(PacPublishSelectionWizardPage.this.getTopLevelMode());
                menu.add((IContributionItem)new Separator(PTSortActionGroup._SEPARATOR));
                PacPublishSelectionWizardPage.this._sortActionGroup.fillMenu(menu);
                PacPublishSelectionWizardPage.this._sortActionGroup.check(PacPublishSelectionWizardPage.this.getSortMode());
                PacPublishSelectionWizardPage.this._displayActionGroup.fillMenu(menu);
                PacPublishSelectionWizardPage.this._displayActionGroup.check(PacPublishSelectionWizardPage.this.getDisplayMode());
                menu.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu contextMenu = menuMgr.createContextMenu(control);
        control.setMenu(contextMenu);
    }

    protected void handleModifyText(ModifyEvent e) {
        if (e.widget == this._txtSessionTitle) {
            this._session.setTitle(this._txtSessionTitle.getText());
        }
    }

    protected void handleButtonSelected(SelectionEvent e) {
        if (e.widget == this._pbRemove) {
            Shell shell = this.getShell();
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            IStructuredSelection selection = (IStructuredSelection)this._trvViewer.getSelection();
            HashSet<PTElement> removedElements = new HashSet<PTElement>(selection.size());
            for (Object object : selection) {
                if (object instanceof PTFolder) {
                    removedElements.addAll(((PTFolder)object).getElements());
                    continue;
                }
                if (object instanceof PTPackage) {
                    removedElements.addAll(((PTPackage)object).getElements());
                    continue;
                }
                if (object instanceof PTProject) {
                    removedElements.addAll(((PTProject)object).getElements());
                    continue;
                }
                if (!(object instanceof PTElement)) continue;
                removedElements.add((PTElement)object);
            }
            this.getRemovedElements().addAll(removedElements);
            for (PTElement element : removedElements) {
                this.getEditedLocation().removeElement(element);
            }
            this.refresh();
            shell.setCursor(null);
        }
    }

    public Set<PTElement> getRemovedElements() {
        if (this._removedElements == null) {
            this._removedElements = new HashSet<PTElement>();
        }
        return this._removedElements;
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void setupData() {
        this._editedLocation = this._session.getEditableLocation();
        this._trvViewer.setInput((Object)this.getEditedLocation());
    }

    public PacPublishingSession getSession() {
        return this._session;
    }

    public PTLocation getEditedLocation() {
        return this._editedLocation;
    }

    public void refresh() {
        if (this._trvViewer != null) {
            this._trvViewer.refresh();
        }
    }

    public int getTopLevelMode() {
        return this._topLevelMode;
    }

    public void setTopLevelMode(int topLevelMode) {
        this._topLevelMode = topLevelMode;
        this._prefs.putInt("_PREF_PUBLISH_SELECTION_PAGE_TOP_LEVEL", this.getTopLevelMode());
        IContentProvider contentProvider = this._trvViewer.getContentProvider();
        if (contentProvider instanceof IPTContentProvider) {
            ((IPTContentProvider)contentProvider).setTopLevelMode(this.getTopLevelMode());
        }
    }

    public int getSortMode() {
        return this._sortMode;
    }

    public void setSortMode(int sortMode) {
        this._sortMode = sortMode;
        this._prefs.putInt("_PREF_PUBLISH_SELECTION_PAGE_SORT", this.getSortMode());
        PTViewerComparator sorter = (PTViewerComparator)this._trvViewer.getComparator();
        ((PTComparator)sorter.getComparator()).setSortMode(this.getSortMode());
    }

    public int getDisplayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        this._prefs.putInt("_PREF_PUBLISH_SELECTION_PAGE_DISPLAY", this.getDisplayMode());
        IBaseLabelProvider labelProvider = this._trvViewer.getLabelProvider();
        if (labelProvider instanceof IPTLabelProvider) {
            ((IPTLabelProvider)labelProvider).setDisplayMode(this.getDisplayMode());
        }
    }

    public void updatePreferences() {
    }
}

