/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard.page;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.wizard.page.PTWizardPage;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import com.ibm.pdp.pac.publishing.model.PacPublishingSession;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.provider.PacResourceContentProvider;
import com.ibm.pdp.pac.publishing.provider.PacResourceLabelProvider;
import com.ibm.pdp.pac.publishing.wizard.PacAbstractPublishWizard;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import com.ibm.pdp.pac.publishing.wizard.PacSchemaWizard;
import com.ibm.pdp.pdppath.nature.PDPPathNature;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;

public class PacPublishOutputWizardPage
extends PTWizardPage
implements IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _OUTPUT_FILE = 0;
    private static final int _OUTPUT_FOLDER = 1;
    private static final int _FORM = 0;
    private static final int _LIST = 1;
    private static final String _XML_EXTENSION = "*.xml";
    private static final String _HTML_EXTENSION = "*.html";
    private static final String _CSV_EXTENSION = "*.csv";
    private static final String _ALL_EXTENSION = "*.*";
    private Button _ckbSerializeRef;
    private Button _pbAdvanced;
    private Button _rdbXML;
    private Button _rdbHTML;
    private Combo _cbbLayout;
    private Button _rdbCSV;
    private Button _ckbManyFiles;
    private PageBook _pagebook;
    private Composite[] _panes;
    private Button _rdbFileLocal;
    private Text _txtFileLocalFolder;
    private TreeViewer _trvViewerFile;
    private Text _txtFileLocalName;
    private Button _rdbFileExternal;
    private Text _txtFileExternalName;
    private Button _pbFileBrowse;
    private Button _rdbFolderLocal;
    private Text _txtFolderLocalName;
    private TreeViewer _trvViewerFolder;
    private Button _rdbFolderExternal;
    private Text _txtFolderExternalName;
    private Button _pbFolderBrowse;
    private PacPublishingSession _session;

    public PacPublishOutputWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_OUTPUT_PAGE_TITLE));
        this.setDescription(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_OUTPUT_PAGE_DESC));
        this._prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.publish_content";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        GridData gridData = new GridData(4, 1, true, false);
        composite.setLayoutData((Object)gridData);
        this.setHelp(composite);
        this.createContentGroup(composite);
        this.createFormatGroup(composite);
        this.createOutputGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createContentGroup(Composite parent) {
        String grpLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_CONTENT_GROUP);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)grpLabel);
        GridData gridData = new GridData(4, 1, true, false);
        group.setLayoutData((Object)gridData);
        this._ckbSerializeRef = PTWidgetTool.createCheckButton((Composite)group, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._SERIALIZE_REF));
        this.addSelectionListener(this._ckbSerializeRef);
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._ADVANCED);
        this._pbAdvanced = PTWidgetTool.createPushButton((Composite)group, (String)pbLabel, (boolean)true);
        this._pbAdvanced.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.addSelectionListener(this._pbAdvanced);
    }

    private void createFormatGroup(Composite parent) {
        String grpLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_FORMAT_GROUP);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)grpLabel);
        String rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_XML);
        this._rdbXML = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)true);
        this._rdbXML.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbXML);
        rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_HTML);
        this._rdbHTML = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false);
        this._rdbHTML.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.addSelectionListener(this._rdbHTML);
        String form = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_FORM);
        String list = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_LIST);
        String[] layoutLabels = new String[]{form, list};
        this._cbbLayout = PTWidgetTool.createCombo((Composite)group);
        this._cbbLayout.setItems(layoutLabels);
        this._cbbLayout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PacPublishOutputWizardPage.this.handleButtonSelected(e);
            }
        });
        this._cbbLayout.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_CSV);
        this._rdbCSV = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false);
        this._rdbCSV.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbCSV);
    }

    private void createOutputGroup(Composite parent) {
        String grpLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_OUTPUT_GROUP);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)grpLabel);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        String rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._TREE_STRUCTURED_OUTPUT);
        this._ckbManyFiles = PTWidgetTool.createCheckBox((Composite)group, (String)rdbLabel);
        this._ckbManyFiles.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.addSelectionListener(this._ckbManyFiles);
        this._pagebook = new PageBook((Composite)group, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        gridData.heightHint = 300;
        this._pagebook.setLayoutData((Object)gridData);
        this._panes = new Composite[2];
        this._panes[0] = this.createFilePane((Composite)this._pagebook);
        this._panes[1] = this.createFolderPane((Composite)this._pagebook);
    }

    private Composite createFilePane(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        String rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._LOCAL_OUTPUT);
        this._rdbFileLocal = PTWidgetTool.createRadioButton((Composite)composite, (String)rdbLabel, (boolean)true, (int)2);
        this.addSelectionListener(this._rdbFileLocal);
        Composite localPane = PTWidgetTool.createComposite((Composite)composite, (int)2, (int)2, (boolean)false);
        localPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this._txtFileLocalFolder = PTWidgetTool.createTextField((Composite)localPane, (boolean)false, (boolean)false, (int)2);
        this.addModifyListener(this._txtFileLocalFolder);
        this._trvViewerFile = PTWidgetTool.createTreeViewer((Composite)localPane, (boolean)true);
        this._trvViewerFile.setUseHashlookup(true);
        this._trvViewerFile.setContentProvider((IContentProvider)new PacResourceContentProvider());
        this._trvViewerFile.setLabelProvider((IBaseLabelProvider)new PacResourceLabelProvider());
        this._trvViewerFile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    IResource resource = (IResource)selection.getFirstElement();
                    String resourceName = resource.getFullPath().toString().substring(1);
                    PacPublishOutputWizardPage.this._txtFileLocalFolder.setText(resourceName);
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this._trvViewerFile.getControl().setLayoutData((Object)gridData);
        PTWidgetTool.createLabel((Composite)localPane, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_FILE));
        this._txtFileLocalName = PTWidgetTool.createTextField((Composite)localPane, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtFileLocalName);
        rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._EXTERNAL_FILE_OUTPUT);
        this._rdbFileExternal = PTWidgetTool.createRadioButton((Composite)composite, (String)rdbLabel, (boolean)false, (int)2);
        this.addSelectionListener(this._rdbFileExternal);
        Composite externalPane = PTWidgetTool.createComposite((Composite)composite, (int)2, (int)2, (boolean)false);
        this._txtFileExternalName = PTWidgetTool.createTextField((Composite)externalPane, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtFileExternalName);
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._BROWSE);
        this._pbFileBrowse = PTWidgetTool.createPushButton((Composite)externalPane, (String)pbLabel, (boolean)true);
        this.addSelectionListener(this._pbFileBrowse);
        return composite;
    }

    private Composite createFolderPane(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        String rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._LOCAL_OUTPUT);
        this._rdbFolderLocal = PTWidgetTool.createRadioButton((Composite)composite, (String)rdbLabel, (boolean)true, (int)2);
        this.addSelectionListener(this._rdbFolderLocal);
        Composite localPane = PTWidgetTool.createComposite((Composite)composite, (int)2, (int)2, (boolean)false);
        localPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this._txtFolderLocalName = PTWidgetTool.createTextField((Composite)localPane, (boolean)false, (boolean)false, (int)2);
        this.addModifyListener(this._txtFolderLocalName);
        this._trvViewerFolder = PTWidgetTool.createTreeViewer((Composite)localPane, (boolean)true);
        this._trvViewerFolder.setUseHashlookup(true);
        this._trvViewerFolder.setContentProvider((IContentProvider)new PacResourceContentProvider());
        this._trvViewerFolder.setLabelProvider((IBaseLabelProvider)new PacResourceLabelProvider());
        this._trvViewerFolder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    IResource resource = (IResource)selection.getFirstElement();
                    String resourceName = resource.getFullPath().toString().substring(1);
                    PacPublishOutputWizardPage.this._txtFolderLocalName.setText(resourceName);
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this._trvViewerFolder.getControl().setLayoutData((Object)gridData);
        rdbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._EXTERNAL_FOLDER_OUTPUT);
        this._rdbFolderExternal = PTWidgetTool.createRadioButton((Composite)composite, (String)rdbLabel, (boolean)false, (int)2);
        this.addSelectionListener(this._rdbFolderExternal);
        Composite externalPane = PTWidgetTool.createComposite((Composite)composite, (int)2, (int)2, (boolean)false);
        this._txtFolderExternalName = PTWidgetTool.createTextField((Composite)externalPane, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtFolderExternalName);
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._BROWSE);
        this._pbFolderBrowse = PTWidgetTool.createPushButton((Composite)externalPane, (String)pbLabel, (boolean)true);
        this.addSelectionListener(this._pbFolderBrowse);
        return composite;
    }

    protected void handleModifyText(ModifyEvent e) {
        if (e.widget == this._txtFileLocalFolder || e.widget == this._txtFileLocalName || e.widget == this._txtFileExternalName) {
            if (e.widget == this._txtFileLocalFolder) {
                this._session.setFileLocalFolder(this._txtFileLocalFolder.getText());
            } else if (e.widget == this._txtFileLocalName) {
                this._session.setFileLocalName(this._txtFileLocalName.getText());
            } else if (e.widget == this._txtFileExternalName) {
                this._session.setFileExternalName(this._txtFileExternalName.getText());
            }
            this.setPageComplete(this.isPageComplete());
        } else if (e.widget == this._txtFolderLocalName || e.widget == this._txtFolderExternalName) {
            if (e.widget == this._txtFolderLocalName) {
                this._session.setFolderLocalName(this._txtFolderLocalName.getText());
            } else if (e.widget == this._txtFolderExternalName) {
                this._session.setFolderExternalName(this._txtFolderExternalName.getText());
            }
            this.setPageComplete(this.isPageComplete());
        }
    }

    protected void handleButtonSelected(SelectionEvent e) {
        DirectoryDialog dialog;
        String folderName;
        if (e.widget == this._ckbSerializeRef) {
            this._session.setSerializeRef(this._ckbSerializeRef.getSelection());
        } else if (e.widget == this._pbAdvanced) {
            PacSchemaWizard wizard = new PacSchemaWizard(this._session);
            WizardDialog dialog2 = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog2.open();
        } else if (e.widget == this._rdbXML || e.widget == this._rdbHTML || e.widget == this._rdbCSV) {
            if (this._rdbXML.getSelection()) {
                this._session.setOutputFormat(PacPublishingPattern.OutputFormat._XML);
            } else if (this._rdbHTML.getSelection()) {
                if (this._cbbLayout.getSelectionIndex() == 0) {
                    this._session.setOutputFormat(PacPublishingPattern.OutputFormat._HTML_FORM);
                } else if (this._cbbLayout.getSelectionIndex() == 1) {
                    this._session.setOutputFormat(PacPublishingPattern.OutputFormat._HTML_LIST);
                }
            } else if (this._rdbCSV.getSelection()) {
                this._session.setOutputFormat(PacPublishingPattern.OutputFormat._CSV);
            }
            this.refresh();
        } else if (e.widget == this._cbbLayout) {
            if (this._cbbLayout.getSelectionIndex() == 0) {
                this._session.setOutputFormat(PacPublishingPattern.OutputFormat._HTML_FORM);
            } else if (this._cbbLayout.getSelectionIndex() == 1) {
                this._session.setOutputFormat(PacPublishingPattern.OutputFormat._HTML_LIST);
            }
            this.refresh();
        } else if (e.widget == this._ckbManyFiles) {
            this._session.setOutputStructure(PacPublishingPattern.OutputStructure._FILE);
            if (this._ckbManyFiles.getSelection()) {
                this._session.setOutputStructure(PacPublishingPattern.OutputStructure._FOLDER);
            }
            this.refresh();
        } else if (e.widget == this._rdbFileLocal || e.widget == this._rdbFileExternal) {
            if (this._rdbFileLocal.getSelection()) {
                this._session.setOutputTarget(PacPublishingPattern.OutputTarget._LOCAL);
            } else {
                this._session.setOutputTarget(PacPublishingPattern.OutputTarget._EXTERNAL);
            }
            this._rdbFolderLocal.setSelection(this._rdbFileLocal.getSelection());
            this._rdbFolderExternal.setSelection(!this._rdbFileLocal.getSelection());
            this.refresh();
        } else if (e.widget == this._rdbFolderLocal || e.widget == this._rdbFolderExternal) {
            if (this._rdbFolderLocal.getSelection()) {
                this._session.setOutputTarget(PacPublishingPattern.OutputTarget._LOCAL);
            } else {
                this._session.setOutputTarget(PacPublishingPattern.OutputTarget._EXTERNAL);
            }
            this._rdbFileLocal.setSelection(this._rdbFolderLocal.getSelection());
            this._rdbFileExternal.setSelection(!this._rdbFolderLocal.getSelection());
            this.refresh();
        } else if (e.widget == this._pbFileBrowse) {
            String extension = _ALL_EXTENSION;
            if (this._rdbXML.getSelection()) {
                extension = _XML_EXTENSION;
            } else if (this._rdbHTML.getSelection()) {
                extension = _HTML_EXTENSION;
            } else if (this._rdbCSV.getSelection()) {
                extension = _CSV_EXTENSION;
            }
            FileDialog dialog3 = new FileDialog(this.getShell(), 40960);
            dialog3.setFilterExtensions(new String[]{extension});
            String fileName = dialog3.open();
            if (fileName != null && fileName.length() > 0) {
                if (!fileName.endsWith(extension.substring(1))) {
                    fileName = String.valueOf(fileName) + extension.substring(1);
                }
                this._txtFileExternalName.setText(fileName);
            }
        } else if (e.widget == this._pbFolderBrowse && (folderName = (dialog = new DirectoryDialog(this.getShell(), 36864)).open()) != null && folderName.length() > 0) {
            this._txtFolderExternalName.setText(folderName);
        }
    }

    public boolean isPageComplete() {
        String message = "";
        if (this._panes[0].isVisible()) {
            String file;
            if (this._rdbFileLocal.getSelection()) {
                String file2;
                String folder = this._txtFileLocalFolder.getText();
                if (folder.length() > 0) {
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = workspaceRoot.findMember(folder);
                    if (resource == null) {
                        message = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_CONTAINER_NOT_EXIST);
                    }
                } else {
                    message = PacPublishWizardLabel.getString(PacPublishWizardLabel._NO_OUTPUT_FOLDER);
                }
                if (message.length() == 0 && (file2 = this._txtFileLocalName.getText()).length() == 0) {
                    message = PacPublishWizardLabel.getString(PacPublishWizardLabel._NO_OUTPUT_FILE);
                }
            } else if (this._rdbFileExternal.getSelection() && (file = this._txtFileExternalName.getText()).length() == 0) {
                message = PacPublishWizardLabel.getString(PacPublishWizardLabel._NO_OUTPUT_FILE);
            }
        } else if (this._panes[1].isVisible()) {
            String folder;
            if (this._rdbFolderLocal.getSelection()) {
                String folder2 = this._txtFolderLocalName.getText();
                if (folder2.length() > 0) {
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = workspaceRoot.findMember(folder2);
                    if (resource == null) {
                        message = PacPublishWizardLabel.getString(PacPublishWizardLabel._OUTPUT_CONTAINER_NOT_EXIST);
                    }
                } else {
                    message = PacPublishWizardLabel.getString(PacPublishWizardLabel._NO_OUTPUT_FOLDER);
                }
            } else if (this._rdbFolderExternal.getSelection() && (folder = this._txtFolderExternalName.getText()).length() == 0) {
                message = PacPublishWizardLabel.getString(PacPublishWizardLabel._NO_OUTPUT_FOLDER);
            }
        }
        if (message.length() > 0) {
            this.setErrorMessage(message);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            PacAbstractPublishWizard publishWizard = (PacAbstractPublishWizard)this.getWizard();
            if (this._session != publishWizard.getPublishedSession()) {
                this._session = publishWizard.getPublishedSession();
                this.setupData();
            }
            this._ckbSerializeRef.setFocus();
        }
    }

    private void setupData() {
        if (this._session == null) {
            return;
        }
        if (this._session.getDate() == null) {
            this._session.setDate(new Date(System.currentTimeMillis()));
            this._session.setSerializeRef(this._prefs.getBoolean("_PREF_PUBLISH_SERIALIZE_REF", false));
            PacPublishingPattern.OutputFormat outputFormat = PacPublishingPattern.OutputFormat.valueOf(this._prefs.get("_PREF_PUBLISH_FORMAT", PacPublishingPattern.OutputFormat._XML.toString()));
            this._session.setOutputFormat(outputFormat);
            PacPublishingPattern.OutputStructure outputStructure = PacPublishingPattern.OutputStructure.valueOf(this._prefs.get("_PREF_PUBLISH_STRUCTURE", PacPublishingPattern.OutputStructure._FILE.toString()));
            this._session.setOutputStructure(outputStructure);
            PacPublishingPattern.OutputTarget outputTarget = PacPublishingPattern.OutputTarget.valueOf(this._prefs.get("_PREF_PUBLISH_TARGET", PacPublishingPattern.OutputTarget._EXTERNAL.toString()));
            this._session.setOutputTarget(outputTarget);
            this._session.setFileLocalFolder(this._prefs.get("_PREF_PUBLISH_FILE_LOCAL_FOLDER", ""));
            this._session.setFileLocalName(this._prefs.get("_PREF_PUBLISH_FILE_LOCAL_NAME", ""));
            this._session.setFileExternalName(this._prefs.get("_PREF_PUBLISH_FILE_EXTERNAL_NAME", ""));
            this._session.setFolderLocalName(this._prefs.get("_PREF_PUBLISH_FOLDER_LOCAL_NAME", ""));
            this._session.setFolderExternalName(this._prefs.get("_PREF_PUBLISH_FOLDER_EXTERNAL_NAME", ""));
        }
        this._ckbSerializeRef.setSelection(this._session.getSerializeRef());
        this._rdbXML.setSelection(this._session.getOutputFormat() == PacPublishingPattern.OutputFormat._XML);
        this._rdbHTML.setSelection(this._session.getOutputFormat() == PacPublishingPattern.OutputFormat._HTML_FORM || this._session.getOutputFormat() == PacPublishingPattern.OutputFormat._HTML_LIST);
        this._rdbCSV.setSelection(this._session.getOutputFormat() == PacPublishingPattern.OutputFormat._CSV);
        this._cbbLayout.select(0);
        if (this._session.getOutputFormat() == PacPublishingPattern.OutputFormat._HTML_LIST) {
            this._cbbLayout.select(1);
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PDPPathNature.getNature((String)project.getName()) == null) {
                projects.add(project);
            }
            ++n2;
        }
        this._ckbManyFiles.setSelection(this._session.getOutputStructure() == PacPublishingPattern.OutputStructure._FOLDER);
        this._rdbFileLocal.setSelection(this._session.getOutputTarget() == PacPublishingPattern.OutputTarget._LOCAL);
        this._rdbFileExternal.setSelection(this._session.getOutputTarget() == PacPublishingPattern.OutputTarget._EXTERNAL);
        this._txtFileLocalFolder.setText(this._session.getFileLocalFolder());
        this._txtFileLocalName.setText(this._session.getFileLocalName());
        this._txtFileExternalName.setText(this._session.getFileExternalName());
        this._trvViewerFile.setInput(projects);
        IResource resource = workspaceRoot.findMember((IPath)new Path(this._txtFileLocalFolder.getText()));
        if (resource != null) {
            this._trvViewerFile.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        this._rdbFolderLocal.setSelection(this._session.getOutputTarget() == PacPublishingPattern.OutputTarget._LOCAL);
        this._rdbFolderExternal.setSelection(this._session.getOutputTarget() == PacPublishingPattern.OutputTarget._EXTERNAL);
        this._txtFolderLocalName.setText(this._session.getFolderLocalName());
        this._txtFolderExternalName.setText(this._session.getFolderExternalName());
        this._trvViewerFolder.setInput(projects);
        resource = workspaceRoot.findMember((IPath)new Path(this._txtFolderLocalName.getText()));
        if (resource != null) {
            this._trvViewerFolder.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        this.refresh();
    }

    public void refresh() {
        boolean displayMode = false;
        if (this._rdbHTML.getSelection() && this._cbbLayout.getSelectionIndex() == 1 || this._rdbCSV.getSelection()) {
            displayMode = true;
        }
        this._cbbLayout.setEnabled(this._rdbHTML.getSelection());
        if (!displayMode) {
            this._ckbManyFiles.setEnabled(true);
            if (!this._ckbManyFiles.getSelection()) {
                this._pagebook.showPage((Control)this._panes[0]);
            } else {
                this._pagebook.showPage((Control)this._panes[1]);
            }
        } else if (displayMode) {
            this._ckbManyFiles.setEnabled(false);
            this._pagebook.showPage((Control)this._panes[0]);
        }
        this._txtFileLocalFolder.setEnabled(this._rdbFileLocal.getSelection());
        this._trvViewerFile.getControl().setEnabled(this._rdbFileLocal.getSelection());
        this._txtFileLocalName.setEnabled(this._rdbFileLocal.getSelection());
        this._txtFileExternalName.setEnabled(this._rdbFileExternal.getSelection());
        this._pbFileBrowse.setEnabled(this._rdbFileExternal.getSelection());
        this._txtFolderLocalName.setEnabled(this._rdbFolderLocal.getSelection());
        this._trvViewerFolder.getControl().setEnabled(this._rdbFolderLocal.getSelection());
        this._txtFolderExternalName.setEnabled(this._rdbFolderExternal.getSelection());
        this._pbFolderBrowse.setEnabled(this._rdbFolderExternal.getSelection());
        this.setPageComplete(this.isPageComplete());
    }

    public void updatePreferences() {
        this._prefs.putBoolean("_PREF_PUBLISH_SERIALIZE_REF", this._session.getSerializeRef());
        this._prefs.put("_PREF_PUBLISH_FORMAT", this._session.getOutputFormat().toString());
        this._prefs.put("_PREF_PUBLISH_STRUCTURE", this._session.getOutputStructure().toString());
        this._prefs.put("_PREF_PUBLISH_TARGET", this._session.getOutputTarget().toString());
        this._prefs.put("_PREF_PUBLISH_FILE_LOCAL_FOLDER", this._session.getFileLocalFolder());
        this._prefs.put("_PREF_PUBLISH_FILE_LOCAL_NAME", this._session.getFileLocalName());
        this._prefs.put("_PREF_PUBLISH_FILE_EXTERNAL_NAME", this._session.getFileExternalName());
        this._prefs.put("_PREF_PUBLISH_FOLDER_LOCAL_NAME", this._session.getFolderLocalName());
        this._prefs.put("_PREF_PUBLISH_FOLDER_EXTERNAL_NAME", this._session.getFolderExternalName());
    }
}

