/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard.page;

import com.ibm.pdp.explorer.view.provider.IPTLabelProvider;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.wizard.page.PTWizardPage;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.actiongroup.PacDisplayActionGroup;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.provider.PacPublishingOrderLabelProvider;
import com.ibm.pdp.pac.publishing.wizard.PacAbstractPublishWizard;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PacPublishOrderWizardPage
extends PTWizardPage
implements IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TableViewer _tblViewer;
    private Button _pbMoveUp;
    private Button _pbMoveDown;
    private List<Document> _metaDocuments;
    private int _displayMode = 5;
    private PacDisplayActionGroup _displayActionGroup;

    public PacPublishOrderWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_ORDER_PAGE_TITLE));
        this.setDescription(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_ORDER_PAGE_DESC));
        this._prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");
        this._displayActionGroup = new PacDisplayActionGroup(this);
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.publish_order";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        this.setHelp(composite);
        this._displayMode = this._prefs.getInt("_PREF_PUBLISH_ORDER_PAGE_DISPLAY", this._displayMode);
        PTWidgetTool.createLabel((Composite)composite, (String)PacPublishWizardLabel.getString(PacPublishWizardLabel._ORGANIZE_CONTENT), (int)2);
        this._tblViewer = new TableViewer(composite, 2050);
        this._tblViewer.setUseHashlookup(true);
        this._tblViewer.setLabelProvider((IBaseLabelProvider)new PacPublishingOrderLabelProvider(this.getDisplayMode()));
        this._tblViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._tblViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this._tblViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PacPublishOrderWizardPage.this.refreshButton();
            }
        });
        this._tblViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        Composite buttonPane = PTWidgetTool.createComposite((Composite)composite, (int)1, (boolean)false);
        buttonPane.setLayoutData((Object)new GridData(2));
        String pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._UP);
        this._pbMoveUp = PTWidgetTool.createPushButton((Composite)buttonPane, (String)pbLabel, (boolean)false);
        this.addSelectionListener(this._pbMoveUp);
        pbLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._DOWN);
        this._pbMoveDown = PTWidgetTool.createPushButton((Composite)buttonPane, (String)pbLabel, (boolean)false);
        this.addSelectionListener(this._pbMoveDown);
        this.createContextMenu(this._tblViewer.getControl());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.setControl((Control)composite);
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacPublishOrderWizardPage.this._displayActionGroup.fillMenu(menu);
                PacPublishOrderWizardPage.this._displayActionGroup.check(PacPublishOrderWizardPage.this.getDisplayMode());
                menu.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu contextMenu = menuMgr.createContextMenu(control);
        control.setMenu(contextMenu);
    }

    protected void handleButtonSelected(SelectionEvent e) {
        IStructuredSelection selection = (IStructuredSelection)this._tblViewer.getSelection();
        if (e.widget == this._pbMoveUp) {
            List list = selection.toList();
            if (this.getDocuments().indexOf(list.get(0)) > 0) {
                for (Document metaDocument : list) {
                    int index = this.getDocuments().indexOf(metaDocument);
                    this.getDocuments().remove(index);
                    this.getDocuments().add(index - 1, metaDocument);
                }
            }
            this._tblViewer.setInput(this.getDocuments());
            this.refreshButton();
        } else if (e.widget == this._pbMoveDown) {
            List list = selection.toList();
            Collections.reverse(list);
            if (this.getDocuments().indexOf(list.get(0)) < this.getDocuments().size() - 1) {
                for (Document metaDocument : list) {
                    int index = this.getDocuments().indexOf(metaDocument);
                    this.getDocuments().remove(index);
                    this.getDocuments().add(index + 1, metaDocument);
                }
            }
            this._tblViewer.setInput(this.getDocuments());
            this.refreshButton();
        }
    }

    private void refreshButton() {
        IStructuredSelection selection = (IStructuredSelection)this._tblViewer.getSelection();
        if (selection.size() > 0 && this.getDocuments().indexOf(selection.getFirstElement()) > 0) {
            this._pbMoveUp.setEnabled(true);
        } else {
            this._pbMoveUp.setEnabled(false);
        }
        Object[] array = selection.toArray();
        if (selection.size() > 0 && this.getDocuments().indexOf(array[array.length - 1]) < this.getDocuments().size() - 1) {
            this._pbMoveDown.setEnabled(true);
        } else {
            this._pbMoveDown.setEnabled(false);
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            PacAbstractPublishWizard wizard = (PacAbstractPublishWizard)this.getWizard();
            this._metaDocuments = wizard.getPublishedSession().getDocuments();
            this._tblViewer.setInput(this.getDocuments());
            this._tblViewer.getTable().setFocus();
        }
    }

    private void setupData() {
    }

    public List<Document> getDocuments() {
        if (this._metaDocuments == null) {
            this._metaDocuments = new ArrayList<Document>();
        }
        return this._metaDocuments;
    }

    public int getSortMode() {
        return 0;
    }

    public void setSortMode(int sortMode) {
    }

    public int getDisplayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        this._prefs.putInt("_PREF_PUBLISH_ORDER_PAGE_DISPLAY", this.getDisplayMode());
        IBaseLabelProvider labelProvider = this._tblViewer.getLabelProvider();
        if (labelProvider instanceof IPTLabelProvider) {
            ((IPTLabelProvider)labelProvider).setDisplayMode(this.getDisplayMode());
        }
        this._tblViewer.refresh();
    }

    public void updatePreferences() {
    }
}

