/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.model.PacPublishingSession;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.wizard.PacAbstractPublishWizard;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import com.ibm.pdp.pac.publishing.wizard.page.PacPublishSelectionWizardPage;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class PacPublishSelectionWizard
extends PacAbstractPublishWizard
implements IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public PacPublishSelectionWizardPage _selectionPage;
    private PacPublishingSession _publishedSession;
    private IEclipsePreferences _prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");

    public PacPublishSelectionWizard(Set<Document> metaDocuments) {
        this.setWindowTitle(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_WIZARD_TITLE));
        this.setNeedsProgressMonitor(true);
        this._publishedSession = new PacPublishingSession();
        PTFacet facet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
        for (Document metaDocument : metaDocuments) {
            if (facet == null || !facet.accept(metaDocument.getType())) continue;
            this._publishedSession.addDocument(metaDocument);
        }
    }

    @Override
    public void addPages() {
        this._selectionPage = new PacPublishSelectionWizardPage("selectionPage_ID", this._publishedSession);
        this.addPage((IWizardPage)this._selectionPage);
        super.addPages();
    }

    @Override
    public PacPublishingSession getPublishedSession() {
        return this._publishedSession;
    }

    @Override
    public PTLocation getEditedLocation() {
        return this._selectionPage.getEditedLocation();
    }

    @Override
    public boolean performFinish() {
        PacPublishingSession publishedSession = this._selectionPage.getSession();
        for (PTElement element : this._selectionPage.getRemovedElements()) {
            publishedSession.removeDocument(element.getDocument());
        }
        return super.performFinish();
    }

    @Override
    protected void updatePreferences() {
        super.updatePreferences();
    }

    @Override
    public boolean canFinish() {
        if (this._selectionPage.getControl().isVisible()) {
            return false;
        }
        return super.canFinish();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

