/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.wizard;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pac.publishing.model.PacPublishingManager;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import com.ibm.pdp.pac.publishing.model.PacPublishingSession;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacPublishingSerializer;
import com.ibm.pdp.pac.publishing.tool.PacMappingTool;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import com.ibm.pdp.pac.publishing.wizard.page.PacPublishOrderWizardPage;
import com.ibm.pdp.pac.publishing.wizard.page.PacPublishOutputWizardPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public abstract class PacAbstractPublishWizard
extends Wizard
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PacPublishOutputWizardPage _outputPage;
    protected PacPublishOrderWizardPage _orderPage;
    private MetadataAccess _metadataAccess = MetadataAccess.getMetadataAccess();
    private Set<String> _retainedProjects;
    private Set<String> _processedIds;

    public void addPages() {
        this._outputPage = new PacPublishOutputWizardPage("outputPage_ID");
        this.addPage((IWizardPage)this._outputPage);
        this._orderPage = new PacPublishOrderWizardPage("orderPage_ID");
        this.addPage((IWizardPage)this._orderPage);
        super.addPages();
    }

    public abstract PacPublishingSession getPublishedSession();

    public abstract PTLocation getEditedLocation();

    public boolean performFinish() {
        PacPublishingSession publishedSession = this.getPublishedSession();
        publishedSession.setDate(new Date(System.currentTimeMillis()));
        PacPublishingManager.getSessions().add(0, publishedSession);
        final PacPublishingPattern pattern = new PacPublishingPattern();
        pattern._title = publishedSession.getTitle();
        pattern._metaDocuments = new ArrayList<Document>(publishedSession.getDocuments());
        pattern._serializeRef = publishedSession.getSerializeRef();
        pattern._checkedClasses = publishedSession.getCheckedClasses();
        pattern._checkedFeatures = publishedSession.getCheckedFeatures();
        pattern._outputFormat = publishedSession.getOutputFormat();
        pattern._outputStructure = publishedSession.getOutputStructure();
        pattern._outputTarget = publishedSession.getOutputTarget();
        pattern._fileLocalFolder = publishedSession.getFileLocalFolder();
        pattern._fileLocalName = publishedSession.getFileLocalName();
        pattern._fileExternalName = publishedSession.getFileExternalName();
        pattern._folderLocalName = publishedSession.getFolderLocalName();
        pattern._folderExternalName = publishedSession.getFolderExternalName();
        Job publishingJob = new Job(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISHING_JOB)){

            protected IStatus run(IProgressMonitor monitor) {
                if (pattern._serializeRef) {
                    monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._ANALYZE_INSTANCES), -1);
                    PacAbstractPublishWizard.this._retainedProjects = new HashSet();
                    PacAbstractPublishWizard.this.computeRequiredPath(pattern._metaDocuments, monitor);
                    PacAbstractPublishWizard.this._processedIds = new HashSet();
                    HashSet<String> sourceIds = new HashSet<String>();
                    for (Document metaDocument : pattern._metaDocuments) {
                        sourceIds.add(metaDocument.getId());
                    }
                    PacAbstractPublishWizard.this.computeDependencies(sourceIds, monitor);
                    for (String sourceId : PacAbstractPublishWizard.this._processedIds) {
                        IPTElement element;
                        PTLocation location;
                        if (sourceIds.contains(sourceId) || (location = PacAbstractPublishWizard.this.getLocation(sourceId)) == null || (element = location.getElement(sourceId)) == null) continue;
                        pattern._metaDocuments.add(element.getDocument());
                    }
                }
                int i = pattern._metaDocuments.size() - 1;
                while (i >= 0) {
                    Document metaDocument;
                    metaDocument = pattern._metaDocuments.get(i);
                    if (!PacMappingTool.isDocumentTypeChecked(pattern._checkedClasses, metaDocument)) {
                        pattern._metaDocuments.remove(i);
                    }
                    --i;
                }
                final List statusList = PacAbstractPublishWizard.this.publishPattern(pattern, monitor);
                if (!monitor.isCanceled()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (statusList.size() > 0) {
                                String dialogLabel = PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISHING_ERROR_LABEL);
                                MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 4, dialogLabel, null);
                                int i = 0;
                                while (i < statusList.size()) {
                                    IStatus status = (IStatus)statusList.get(i);
                                    multiStatus.add(status);
                                    ++i;
                                }
                                String dialogTitle = PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISHING_ERROR_TITLE);
                                PTMessageManager.handleErrors((String)dialogTitle, (MultiStatus)multiStatus);
                            } else {
                                PTMessageManager.handleInformation((String)PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISHING_ENDED));
                            }
                        }
                    });
                }
                monitor.done();
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        publishingJob.setPriority(50);
        publishingJob.setUser(true);
        publishingJob.schedule();
        this.updatePreferences();
        return true;
    }

    private void computeRequiredPath(List<Document> metaDocuments, IProgressMonitor monitor) {
        for (Document metaDocument : metaDocuments) {
            if (this._retainedProjects.contains(metaDocument.getProject())) continue;
            this._retainedProjects.addAll(PTNature.getPaths((String)metaDocument.getProject()));
        }
    }

    private void computeDependencies(Set<String> sourceIds, IProgressMonitor monitor) {
        if (sourceIds == null || sourceIds.size() == 0) {
            return;
        }
        Object[] array = new String[]{Integer.toString(this._processedIds.size())};
        monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_ANALYZED_INSTANCES, array));
        if (monitor.isCanceled()) {
            return;
        }
        Map subReferences = this._metadataAccess.readReferences(sourceIds, 0);
        this._processedIds.addAll(sourceIds);
        HashSet<String> addedIds = new HashSet<String>();
        for (Map.Entry entry : subReferences.entrySet()) {
            String sourceId = (String)entry.getKey();
            List metaReferences = (List)entry.getValue();
            PTLocation location = this.getLocation(sourceId);
            if (location == null) continue;
            for (Reference metaReference : metaReferences) {
                String targetId = metaReference.getTargetId();
                String[] targetTokens = MetadataService.getTokens((String)targetId);
                String designURI = PTElement.getDesignURI((String)targetTokens[1], (String)targetTokens[2], (String)targetTokens[3], (String)targetTokens[4]);
                List elements = location.getByDesignURI(designURI);
                for (PTElement element : elements) {
                    String concreteId;
                    if (element.getFile() == null || !this._retainedProjects.contains(element.getProjectName()) || this._processedIds.contains(concreteId = element.getDocument().getId())) continue;
                    addedIds.add(concreteId);
                }
            }
        }
        if (addedIds.size() > 0) {
            this.computeDependencies(addedIds, monitor);
        }
    }

    private PTLocation getLocation(String designId) {
        PTLocation location = null;
        PTNature nature = PTNature.getNature((String)MetadataService.getProject((String)designId));
        if (nature != null) {
            location = PTModelManager.getLocation((String)nature.getLocation());
        }
        return location;
    }

    private List<IStatus> publishPattern(PacPublishingPattern pattern, IProgressMonitor monitor) {
        List<IStatus> statusList = Collections.emptyList();
        PacPublishingSerializer publishingSerializer = new PacPublishingSerializer(pattern);
        statusList = publishingSerializer.serialize(monitor);
        return statusList;
    }

    protected void updatePreferences() {
        this._outputPage.updatePreferences();
    }

    public boolean canFinish() {
        if (this._outputPage.getControl().isVisible() && this._outputPage.isPageComplete()) {
            return true;
        }
        return this._orderPage.getControl().isVisible();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

