/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.tool;

import com.ibm.pdp.maf.rpp.kernel.Element;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PacSchemaItem {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Class<?> _clazz;
    private Method _method;
    private PacSchemaItem _parent;
    private List<PacSchemaItem> _children = null;

    public static boolean isSimpleType(Class<?> type) {
        return type == String.class || type.isEnum() || type == Integer.TYPE;
    }

    public static boolean isChildOf(Class<?> aClass, Class<?> parentClass) {
        return parentClass.isAssignableFrom(aClass);
    }

    public static boolean isMultiple(Method method) {
        return method != null && method.getReturnType() == List.class;
    }

    public static SchemaItemKind getKind(Method method) {
        if (method != null) {
            if (PacSchemaItem.isSimpleType(method.getReturnType())) {
                return SchemaItemKind._ATTRIBUTE;
            }
            if (PacSchemaItem.isChildOf(method.getReturnType(), RadicalElement.class)) {
                return SchemaItemKind._AGGREGATION;
            }
            if (PacSchemaItem.isChildOf(method.getReturnType(), Element.class)) {
                return SchemaItemKind._COMPOSITION;
            }
            if (PacSchemaItem.isMultiple(method)) {
                if (PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), RadicalElement.class)) {
                    return SchemaItemKind._AGGREGATION;
                }
                if (PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), Element.class) || PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), String.class)) {
                    return SchemaItemKind._COMPOSITION;
                }
            }
        }
        return null;
    }

    public static Class<?> getGenericClass(Method method) {
        Type[] arguments;
        Type genericType = method.getGenericReturnType();
        if (genericType instanceof ParameterizedType && (arguments = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && arguments[0] instanceof Class) {
            return (Class)arguments[0];
        }
        return null;
    }

    public static String getIdentifier(String className, String featureName) {
        StringBuilder buffer = new StringBuilder(className);
        buffer.append("#").append(featureName);
        return buffer.toString();
    }

    public PacSchemaItem(Class<?> clazz) {
        this._clazz = clazz;
    }

    public PacSchemaItem(Method method) {
        this._method = method;
    }

    public Class<?> getClazz() {
        return this._clazz;
    }

    public Method getMethod() {
        return this._method;
    }

    public SchemaItemKind getKind() {
        if (this.getClazz() != null) {
            return SchemaItemKind._CLASS;
        }
        if (this.getMethod() != null) {
            return PacSchemaItem.getKind(this.getMethod());
        }
        return null;
    }

    public String getName() {
        if (this.getClazz() != null) {
            return this.getClazz().getName();
        }
        if (this.getMethod() != null) {
            return this.getMethod().getName().replace("get", "").toLowerCase();
        }
        return "";
    }

    public String getSimpleName() {
        if (this.getClazz() != null) {
            return this.getClazz().getSimpleName();
        }
        return this.getName();
    }

    public String getIdentifier() {
        if (this.getClazz() != null) {
            return this.getName();
        }
        if (this.getMethod() != null) {
            return PacSchemaItem.getIdentifier(this.getMethod().getDeclaringClass().getName(), this.getName());
        }
        return "";
    }

    public PacSchemaItem getParent() {
        return this._parent;
    }

    public void setParent(PacSchemaItem parent) {
        this._parent = parent;
        if (this.getParent() != null) {
            this.getParent().getChildren().add(this);
        }
    }

    public List<PacSchemaItem> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<PacSchemaItem>();
        }
        return this._children;
    }

    public Set<Class<?>> getCalledClasses() {
        HashSet calledClasses = new HashSet();
        if (this.getKind() == SchemaItemKind._CLASS) {
            for (PacSchemaItem childItem : this.getChildren()) {
                if (childItem.getKind() != SchemaItemKind._COMPOSITION) continue;
                if (PacSchemaItem.isMultiple(childItem.getMethod())) {
                    Class<?> genericClass = PacSchemaItem.getGenericClass(childItem.getMethod());
                    if (genericClass == null) continue;
                    calledClasses.add(genericClass);
                    continue;
                }
                Class<?> returnType = childItem.getMethod().getReturnType();
                if (returnType == null) continue;
                calledClasses.add(returnType);
            }
        }
        return calledClasses;
    }

    public Set<PacSchemaItem> getSuperclasses() {
        HashSet<PacSchemaItem> superClasses = new HashSet<PacSchemaItem>();
        if (this.getKind() == SchemaItemKind._CLASS) {
            PacSchemaItem parentItem = this.getParent();
            while (parentItem != null) {
                superClasses.add(parentItem);
                parentItem = parentItem.getParent();
            }
        }
        return superClasses;
    }

    public Set<PacSchemaItem> getSubclasses() {
        HashSet<PacSchemaItem> subClasses = new HashSet<PacSchemaItem>();
        if (this.getKind() == SchemaItemKind._CLASS) {
            for (PacSchemaItem childItem : this.getChildren()) {
                if (childItem.getKind() != SchemaItemKind._CLASS) continue;
                subClasses.add(childItem);
                subClasses.addAll(childItem.getSubclasses());
            }
        }
        return subClasses;
    }

    public void update(Set<Class<?>> retainedClasses) {
        int i = this.getChildren().size() - 1;
        while (i >= 0) {
            PacSchemaItem childItem = this.getChildren().get(i);
            if (childItem.getKind() == SchemaItemKind._CLASS) {
                if (!retainedClasses.contains(childItem.getClazz())) {
                    this.getChildren().remove(i);
                } else {
                    childItem.update(retainedClasses);
                }
            }
            --i;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getKind() == SchemaItemKind._CLASS) {
            buffer.append("Class: ");
        } else if (this.getKind() == SchemaItemKind._ATTRIBUTE) {
            buffer.append("Attribute: ");
        } else if (this.getKind() == SchemaItemKind._COMPOSITION) {
            buffer.append("Composition: ");
        } else if (this.getKind() == SchemaItemKind._AGGREGATION) {
            buffer.append("Aggregation: ");
        }
        buffer.append(this.getSimpleName());
        return buffer.toString();
    }

    public static enum SchemaItemKind {
        _CLASS,
        _ATTRIBUTE,
        _COMPOSITION,
        _AGGREGATION;

    }
}

