/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.tool;

import com.ibm.pdp.maf.rpp.kernel.Element;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import java.util.Comparator;

public class PacSchemaComparator
implements Comparator<Object> {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static int getCriteria(PacSchemaItem item) {
        if (item.getKind() == PacSchemaItem.SchemaItemKind._ATTRIBUTE) {
            return 0;
        }
        if (item.getKind() == PacSchemaItem.SchemaItemKind._COMPOSITION) {
            return 1;
        }
        if (item.getKind() == PacSchemaItem.SchemaItemKind._AGGREGATION) {
            return 2;
        }
        if (item.getKind() == PacSchemaItem.SchemaItemKind._CLASS) {
            return 3;
        }
        return -1;
    }

    @Override
    public int compare(Object object1, Object object2) {
        if (object1 instanceof PacSchemaItem && object2 instanceof PacSchemaItem) {
            int criteria2;
            PacSchemaItem item1 = (PacSchemaItem)object1;
            PacSchemaItem item2 = (PacSchemaItem)object2;
            int criteria1 = PacSchemaComparator.getCriteria(item1);
            if (criteria1 == (criteria2 = PacSchemaComparator.getCriteria(item2))) {
                if (item1.getKind() == PacSchemaItem.SchemaItemKind._CLASS) {
                    if (item1.getClazz() == RadicalElement.class) {
                        return -1;
                    }
                    if (item1.getClazz() == Element.class) {
                        return 1;
                    }
                    return item1.getClazz().getSimpleName().compareTo(item2.getClazz().getSimpleName());
                }
                return item1.getName().compareTo(item2.getName());
            }
            return criteria1 - criteria2;
        }
        return 0;
    }
}

