/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.tool;

import com.ibm.pdp.maf.rpp.kernel.MetaDataAggregate;
import com.ibm.pdp.maf.rpp.kernel.MetaEntity;
import com.ibm.pdp.maf.rpp.kernel.MetaEntityType;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.UserEntity;
import com.ibm.pdp.maf.rpp.pac.blockbase.AbstractBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.CodasylBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.HierarchicalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.RelationalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.SocrateBlockBase;
import com.ibm.pdp.maf.rpp.pac.copybook.Copybook;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElement;
import com.ibm.pdp.maf.rpp.pac.datastructure.DataStructure;
import com.ibm.pdp.maf.rpp.pac.dialog.Dialog;
import com.ibm.pdp.maf.rpp.pac.dialog.Screen;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.CommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.DialogCommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.DialogFolder;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.Folder;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.DialogFolderView;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.FolderView;
import com.ibm.pdp.maf.rpp.pac.dialogserver.DialogServer;
import com.ibm.pdp.maf.rpp.pac.dialogserver.Server;
import com.ibm.pdp.maf.rpp.pac.errorlabel.ErrorLabel;
import com.ibm.pdp.maf.rpp.pac.inputaid.InputAid;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.pac.macro.Macro;
import com.ibm.pdp.maf.rpp.pac.program.Program;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalView;
import com.ibm.pdp.maf.rpp.pac.segment.MonoStructureSegment;
import com.ibm.pdp.maf.rpp.pac.segment.StandardSegment;
import com.ibm.pdp.maf.rpp.pac.segment.Table;
import com.ibm.pdp.maf.rpp.pac.text.Text;
import com.ibm.pdp.maf.rpp.pac.volume.Volume;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.meta.Document;
import java.util.Set;

public class PacMappingTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _SEGMENT = "Segment";
    public static final String _BLOCK_BASE = "BlockBase";

    public static Class<?> getMAFInterface(String emfType) {
        if (emfType.equals("dataaggregate")) {
            return AbstractSegment.class;
        }
        if (emfType.equals("dataelement")) {
            return DataElement.class;
        }
        if (emfType.equals("dataunit")) {
            return DataStructure.class;
        }
        if (emfType.equals("metadataaggregate")) {
            return MetaDataAggregate.class;
        }
        if (emfType.equals("metaentity")) {
            return MetaEntity.class;
        }
        if (emfType.equals("metaentitytype")) {
            return MetaEntityType.class;
        }
        if (emfType.equals("pacblockbase")) {
            return AbstractBlockBase.class;
        }
        if (emfType.equals("paccommunicationmonitor")) {
            return CommunicationMonitor.class;
        }
        if (emfType.equals("paccopybook")) {
            return Copybook.class;
        }
        if (emfType.equals("pacdialog")) {
            return Dialog.class;
        }
        if (emfType.equals("pacdialogcommunicationmonitor")) {
            return DialogCommunicationMonitor.class;
        }
        if (emfType.equals("pacdialogfolder")) {
            return DialogFolder.class;
        }
        if (emfType.equals("pacdialogfolderview")) {
            return DialogFolderView.class;
        }
        if (emfType.equals("pacdialogserver")) {
            return DialogServer.class;
        }
        if (emfType.equals("pacerrorlabel")) {
            return ErrorLabel.class;
        }
        if (emfType.equals("pacfolder")) {
            return Folder.class;
        }
        if (emfType.equals("pacfolderview")) {
            return FolderView.class;
        }
        if (emfType.equals("pacinputaid")) {
            return InputAid.class;
        }
        if (emfType.equals("paclibrary")) {
            return Library.class;
        }
        if (emfType.equals("pacmacro")) {
            return Macro.class;
        }
        if (emfType.equals("pacprogram")) {
            return Program.class;
        }
        if (emfType.equals("pacreport")) {
            return Report.class;
        }
        if (emfType.equals("pacscreen")) {
            return Screen.class;
        }
        if (emfType.equals("pacserver")) {
            return Server.class;
        }
        if (emfType.equals("pactext")) {
            return Text.class;
        }
        if (emfType.equals("pacvolume")) {
            return Volume.class;
        }
        if (emfType.equals("userentity")) {
            return UserEntity.class;
        }
        return null;
    }

    public static String getMAFType(String emfType) {
        if (emfType.equals("dataaggregate")) {
            return _SEGMENT;
        }
        if (emfType.equals("pacblockbase")) {
            return _BLOCK_BASE;
        }
        Class<?> mafClass = PacMappingTool.getMAFInterface(emfType);
        if (mafClass != null) {
            return mafClass.getSimpleName();
        }
        return "";
    }

    public static Class<?> getMAFInterface(Document metaDocument) {
        String type;
        String name;
        String metaType;
        String packageName;
        String projectName;
        IMAFModelService mafService;
        RadicalElement radicalElement;
        Class<?> mafInterface = PacMappingTool.getMAFInterface(metaDocument.getType());
        if ((mafInterface == AbstractSegment.class || mafInterface == AbstractBlockBase.class) && (radicalElement = (mafService = MAFModelManager.getServiceInstance()).getRadicalElement(projectName = metaDocument.getProject(), packageName = metaDocument.getPackage(), metaType = metaDocument.getMetaType(), name = metaDocument.getName(), type = metaDocument.getType())) != null && radicalElement.getClass().getInterfaces().length > 0) {
            return radicalElement.getClass().getInterfaces()[0];
        }
        return mafInterface;
    }

    public static String getMAFType(Document metaDocument) {
        String type;
        String name;
        String metaType;
        String packageName;
        String projectName;
        IMAFModelService mafService;
        RadicalElement radicalElement;
        String mafType = PacMappingTool.getMAFType(metaDocument.getType());
        if ((mafType.equals(_SEGMENT) || mafType.equals(_BLOCK_BASE)) && (radicalElement = (mafService = MAFModelManager.getServiceInstance()).getRadicalElement(projectName = metaDocument.getProject(), packageName = metaDocument.getPackage(), metaType = metaDocument.getMetaType(), name = metaDocument.getName(), type = metaDocument.getType())) != null) {
            return radicalElement.getClass().getSimpleName();
        }
        return mafType;
    }

    public static boolean isDocumentTypeChecked(Set<String> mafCheckedClasses, Document metaDocument) {
        if (mafCheckedClasses == null || mafCheckedClasses.size() == 0) {
            return true;
        }
        String emfType = metaDocument.getType();
        if (emfType.equals("dataaggregate")) {
            return mafCheckedClasses.contains(StandardSegment.class.getName()) || mafCheckedClasses.contains(Table.class.getName()) || mafCheckedClasses.contains(MonoStructureSegment.class.getName()) || mafCheckedClasses.contains(LogicalView.class.getName());
        }
        if (emfType.equals("pacblockbase")) {
            return mafCheckedClasses.contains(RelationalBlockBase.class.getName()) || mafCheckedClasses.contains(HierarchicalBlockBase.class.getName()) || mafCheckedClasses.contains(CodasylBlockBase.class.getName()) || mafCheckedClasses.contains(SocrateBlockBase.class.getName());
        }
        Class<?> mafClass = PacMappingTool.getMAFInterface(emfType);
        if (mafClass != null) {
            return mafCheckedClasses.contains(mafClass.getName());
        }
        return false;
    }
}

