/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.service;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import com.ibm.pdp.pac.publishing.serializer.PacPublishingSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PacPublishingService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _XML = 0;
    public static final int _HTML = 1;

    public static List<IStatus> publish(IPTLocation location, String designId, int outputFormat, boolean serializeReferences, String fileName) {
        if (!(location instanceof PTLocation)) {
            return Collections.emptyList();
        }
        IPTElement element = location.getElement(designId);
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<Document> metaDocuments = new ArrayList<Document>();
        metaDocuments.add(element.getDocument());
        PacPublishingPattern pattern = new PacPublishingPattern();
        pattern._metaDocuments = metaDocuments;
        if (outputFormat == 0) {
            pattern._outputFormat = PacPublishingPattern.OutputFormat._XML;
        } else if (outputFormat == 1) {
            pattern._outputFormat = PacPublishingPattern.OutputFormat._HTML_FORM;
        } else {
            System.out.println("");
        }
        pattern._serializeRef = serializeReferences;
        if (serializeReferences) {
            Set<String> retainedProjects = PacPublishingService.computeRequiredPath(pattern._metaDocuments);
            HashSet<String> sourceIds = new HashSet<String>();
            for (Document metaDocument : pattern._metaDocuments) {
                sourceIds.add(metaDocument.getId());
            }
            HashSet<String> processedIds = new HashSet<String>();
            PacPublishingService.computeDependencies(location, sourceIds, retainedProjects, processedIds);
            for (String sourceId : processedIds) {
                if (sourceIds.contains(sourceId) || (element = location.getElement(sourceId)) == null) continue;
                pattern._metaDocuments.add(element.getDocument());
            }
        }
        pattern._outputTarget = PacPublishingPattern.OutputTarget._EXTERNAL;
        pattern._outputStructure = PacPublishingPattern.OutputStructure._FILE;
        pattern._fileExternalName = fileName;
        pattern._title = "";
        PacPublishingSerializer serializer = new PacPublishingSerializer(pattern);
        List<IStatus> statusList = serializer.serialize((IProgressMonitor)new NullProgressMonitor());
        return statusList;
    }

    private static Set<String> computeRequiredPath(List<Document> metaDocuments) {
        HashSet<String> retainedProjects = new HashSet<String>();
        for (Document metaDocument : metaDocuments) {
            if (retainedProjects.contains(metaDocument.getProject())) continue;
            retainedProjects.addAll(PTNature.getPaths((String)metaDocument.getProject()));
        }
        return retainedProjects;
    }

    private static void computeDependencies(IPTLocation location, Set<String> sourceIds, Set<String> retainedProjects, Set<String> processedIds) {
        if (sourceIds == null || sourceIds.size() == 0) {
            return;
        }
        Map subReferences = MetadataAccess.getMetadataAccess().readReferences(sourceIds, 0);
        processedIds.addAll(sourceIds);
        HashSet<String> addedIds = new HashSet<String>();
        for (List metaReferences : subReferences.values()) {
            for (Reference metaReference : metaReferences) {
                String targetId = metaReference.getTargetId();
                String[] targetTokens = MetadataService.getTokens((String)targetId);
                String designURI = PTElement.getDesignURI((String)targetTokens[1], (String)targetTokens[2], (String)targetTokens[3], (String)targetTokens[4]);
                List elements = ((PTLocation)location).getByDesignURI(designURI);
                for (PTElement element : elements) {
                    String concreteId;
                    if (element.getFile() == null || !retainedProjects.contains(element.getProjectName()) || processedIds.contains(concreteId = element.getDocument().getId())) continue;
                    addedIds.add(concreteId);
                }
            }
        }
        if (addedIds.size() > 0) {
            PacPublishingService.computeDependencies(location, addedIds, retainedProjects, processedIds);
        }
    }
}

