/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.serializer;

import com.ibm.pdp.maf.rpp.kernel.Element;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PacXSLSerializer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SortedMap<String, Class<?>> _composition = null;

    private static boolean isSimpleType(Class<?> type) {
        return type == String.class || type.isEnum() || type == Integer.TYPE;
    }

    private static boolean isChildOf(Class<?> aClass, Class<?> motherClass) {
        return motherClass.isAssignableFrom(aClass);
    }

    public String serialize(Class<?> clazz) {
        this._composition = new TreeMap();
        this.extractComposition(clazz);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(baos);
            this.serializeHeader(xmlWriter);
            this.serializeRootTemplate(clazz, xmlWriter);
            this.serializeRootClassTemplate(clazz, xmlWriter);
            for (Map.Entry<String, Class<?>> entry : this._composition.entrySet()) {
                this.serializeMultipleRelationTemplate(entry, xmlWriter);
            }
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
        String xmlContent = baos.toString();
        return xmlContent;
    }

    private void extractComposition(Class<?> clazz) {
        Method[] methods;
        if (clazz.getInterfaces().length == 0) {
            return;
        }
        Method[] methodArray = methods = clazz.getInterfaces()[0].getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> returnType;
            Method method = methodArray[n2];
            if (method.getGenericParameterTypes().length <= 0 && (returnType = method.getReturnType()) == List.class) {
                String relationName = method.getName().replace("get", "");
                Class<?> genericClazz = this.getGenericClass(method);
                this._composition.put(relationName, genericClazz);
                this.extractComposition(genericClazz);
            }
            ++n2;
        }
    }

    private void serializeHeader(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("xsl:stylesheet");
        xmlWriter.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.writeNamespace("p", "https://com.ibm.pdp.pac.publishing");
        xmlWriter.writeAttribute("version", "1.0");
    }

    private void serializeRootTemplate(Class<?> clazz, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("xsl:template");
        xmlWriter.writeAttribute("match", "p:rpp");
        xmlWriter.writeStartElement("html");
        xmlWriter.writeStartElement("head");
        xmlWriter.writeStartElement("title");
        xmlWriter.writeCharacters("Prototype");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("meta");
        xmlWriter.writeAttribute("http-equiv", "Content-Type");
        xmlWriter.writeAttribute("content", "text/html; charset=ISO-8859-1");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("link");
        xmlWriter.writeAttribute("rel", "stylesheet");
        xmlWriter.writeAttribute("href", "rpp.css");
        xmlWriter.writeAttribute("type", "text/css");
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("body");
        xmlWriter.writeStartElement("xsl:apply-templates");
        xmlWriter.writeAttribute("select", "p:" + clazz.getSimpleName().toLowerCase());
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void serializeRootClassTemplate(Class<?> clazz, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("xsl:template");
        xmlWriter.writeAttribute("match", "p:" + clazz.getSimpleName().toLowerCase());
        xmlWriter.writeStartElement("h1");
        this.serializeClassName(clazz, xmlWriter);
        xmlWriter.writeEndElement();
        this.serializeClassComposition(clazz, xmlWriter);
        xmlWriter.writeEndElement();
    }

    private void serializeClassName(Class<?> clazz, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeCharacters(clazz.getSimpleName());
        xmlWriter.writeStartElement("xsl:value-of");
        xmlWriter.writeAttribute("select", "@name");
        xmlWriter.writeEndElement();
    }

    private void serializeClassComposition(Class<?> clazz, XMLStreamWriter xmlWriter) throws XMLStreamException {
        Method[] methods = new Method[]{};
        if (!clazz.isInterface()) {
            if (clazz.getInterfaces().length > 0) {
                methods = clazz.getInterfaces()[0].getMethods();
            }
        } else {
            methods = clazz.getMethods();
        }
        ArrayList<Method> attributeMethods = new ArrayList<Method>();
        ArrayList<Method> unaryRelationMethods = new ArrayList<Method>();
        ArrayList<Method> multipleRelationMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getGenericParameterTypes().length <= 0) {
                Class<?> returnType = method.getReturnType();
                if (PacXSLSerializer.isSimpleType(returnType)) {
                    attributeMethods.add(method);
                } else if (PacXSLSerializer.isChildOf(returnType, Element.class)) {
                    unaryRelationMethods.add(method);
                } else if (returnType == List.class) {
                    multipleRelationMethods.add(method);
                }
            }
            ++n2;
        }
        xmlWriter.writeStartElement("table");
        for (Method method : attributeMethods) {
            if (method.getName().equals("getName") || method.getName().equals("getPackage")) continue;
            this.serializeAttribute(method, xmlWriter);
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("table");
        for (Method method : unaryRelationMethods) {
            this.serializeUnaryRelation(method, xmlWriter);
        }
        xmlWriter.writeEndElement();
        for (Method method : multipleRelationMethods) {
            this.serializeMultipleRelation(method, xmlWriter);
        }
    }

    private void serializeAttribute(Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attName = method.getName().replace("get", "");
        xmlWriter.writeStartElement("tr");
        xmlWriter.writeStartElement("td");
        xmlWriter.writeAttribute("width", "140");
        xmlWriter.writeCharacters(attName);
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("td");
        xmlWriter.writeAttribute("width", "140");
        xmlWriter.writeStartElement("xsl:value-of");
        xmlWriter.writeAttribute("select", "@" + attName.toLowerCase());
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void serializeUnaryRelation(Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "");
        xmlWriter.writeStartElement("tr");
        xmlWriter.writeStartElement("td");
        xmlWriter.writeAttribute("width", "140");
        xmlWriter.writeCharacters(relationName);
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("td");
        xmlWriter.writeAttribute("width", "140");
        xmlWriter.writeStartElement("a");
        xmlWriter.writeAttribute("hRef", "temporary");
        xmlWriter.writeStartElement("xsl:value-of");
        xmlWriter.writeAttribute("select", "p:" + relationName.toLowerCase() + "/@idref");
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void serializeMultipleRelation(Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "");
        xmlWriter.writeStartElement("xsl:apply-templates");
        xmlWriter.writeAttribute("select", "p:" + relationName.toLowerCase());
        xmlWriter.writeEndElement();
    }

    private void serializeMultipleRelationTemplate(Map.Entry<String, Class<?>> entry, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = entry.getKey();
        Class<?> clazz = entry.getValue();
        clazz.getClasses();
        clazz.getDeclaredClasses();
        clazz.getPackage();
        clazz.getGenericInterfaces();
        clazz.getInterfaces();
        xmlWriter.writeStartElement("xsl:template");
        xmlWriter.writeAttribute("match", "p:" + relationName.toLowerCase());
        xmlWriter.writeStartElement("xsl:variable");
        xmlWriter.writeAttribute("name", "position");
        xmlWriter.writeAttribute("select", "position()");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("xsl:if");
        xmlWriter.writeAttribute("test", "$position=1");
        xmlWriter.writeStartElement("h3");
        xmlWriter.writeCharacters(relationName);
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("ul");
        xmlWriter.writeStartElement("li");
        xmlWriter.writeStartElement("p");
        xmlWriter.writeStartElement("xsl:value-of");
        xmlWriter.writeAttribute("select", "@xsi:type");
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        this.serializeClassComposition(clazz, xmlWriter);
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private Class<?> getGenericClass(Method method) {
        Type[] arguments;
        Type genericType = method.getGenericReturnType();
        if (genericType instanceof ParameterizedType && (arguments = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && arguments[0] instanceof Class) {
            return (Class)arguments[0];
        }
        return null;
    }
}

