/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.serializer;

import com.ibm.pdp.maf.rpp.kernel.Element;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacAbstractSerializer;
import com.ibm.pdp.pac.publishing.serializer.PacPublishSerializerLabel;
import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PacXMLSerializer
extends PacAbstractSerializer
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacXMLSerializer(Set<String> checkedClasses, Map<String, Set<String>> checkedFeatures) {
        this._checkedClasses = checkedClasses;
        this._allCheckedFeatures = checkedFeatures;
    }

    public void serializeTableContents(List<Document> metaDocuments, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:tablecontents");
        for (Document metaDocument : metaDocuments) {
            xmlWriter.writeStartElement("rpp:artifact");
            xmlWriter.writeAttribute("idref", PacXMLSerializer.getId(metaDocument));
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    public IStatus serialize(Document metaDocument, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String type;
        String name;
        String metaType;
        String packageName;
        String projectName;
        IMAFModelService mafService = MAFModelManager.getServiceInstance();
        RadicalElement radicalElement = mafService.getRadicalElement(projectName = metaDocument.getProject(), packageName = metaDocument.getPackage(), metaType = metaDocument.getMetaType(), name = metaDocument.getName(), type = metaDocument.getType());
        if (radicalElement == null) {
            Object[] array = new String[]{metaDocument.getId()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._LOAD_ARTIFACT, array);
            return new Status(4, "org.eclipse.ui", 0, msg, null);
        }
        this.serialize(radicalElement, xmlWriter);
        return null;
    }

    public void serialize(XMLStreamWriter xmlWriter, RadicalElement radicalElement) throws XMLStreamException {
        this.serialize(radicalElement, xmlWriter);
    }

    public void serialize(RadicalElement radicalElement, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("rpp:" + radicalElement.getClass().getSimpleName().toLowerCase());
        xmlWriter.writeAttribute("id", PacXMLSerializer.getId(radicalElement));
        this.serializeComposition((Element)radicalElement, xmlWriter);
        xmlWriter.writeEndElement();
    }

    private void serializeComposition(Element element, XMLStreamWriter xmlWriter) throws XMLStreamException {
        boolean isFeatureChecked;
        Method method;
        Method[] methods = element.getClass().getInterfaces()[0].getMethods();
        int i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && PacSchemaItem.getKind(method) == PacSchemaItem.SchemaItemKind._ATTRIBUTE && (isFeatureChecked = this.isFeatureChecked(method.getDeclaringClass().getName(), method.getName()))) {
                this.serializeAttribute(element, method, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
        i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && !PacSchemaItem.isMultiple(method) && PacSchemaItem.isChildOf(method.getReturnType(), Element.class) && (isFeatureChecked = this.isFeatureChecked(method.getDeclaringClass().getName(), method.getName()))) {
                this.serializeUnaryRelation(element, method, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
        i = methods.length - 1;
        while (i >= 0) {
            method = methods[i];
            if (method != null && PacSchemaItem.isMultiple(method) && (PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), Element.class) || PacSchemaItem.isChildOf(PacSchemaItem.getGenericClass(method), String.class)) && (isFeatureChecked = this.isFeatureChecked(method.getDeclaringClass().getName(), method.getName()))) {
                this.serializeMultipleRelation(element, method, xmlWriter);
                methods[i] = null;
            }
            --i;
        }
    }

    private void serializeAttribute(Element element, Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attName = method.getName().replace("get", "").toLowerCase();
        Object attValue = null;
        try {
            attValue = method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        if (attValue != null && attValue.toString().trim().length() > 0) {
            xmlWriter.writeAttribute(attName, attValue.toString());
        }
    }

    private void serializeUnaryRelation(Element element, Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "").toLowerCase();
        Element value = null;
        try {
            value = (Element)method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        if (value instanceof Element) {
            StringBuilder buffer = new StringBuilder("rpp:");
            String declaringClassName = method.getDeclaringClass().getSimpleName().toLowerCase();
            buffer.append(declaringClassName).append("_").append(relationName);
            xmlWriter.writeStartElement(buffer.toString());
            this.serializeObject(value, xmlWriter);
            xmlWriter.writeEndElement();
        }
    }

    private void serializeMultipleRelation(Element element, Method method, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String relationName = method.getName().replace("get", "").toLowerCase();
        List values = null;
        try {
            values = (List)method.invoke((Object)element, null);
        }
        catch (Exception exception) {}
        if (values != null && values.size() > 0) {
            for (Object value : values) {
                if (!(value instanceof Element) && !(value instanceof String)) continue;
                StringBuilder buffer = new StringBuilder("rpp:");
                String declaringClassName = method.getDeclaringClass().getSimpleName().toLowerCase();
                buffer.append(declaringClassName).append("_").append(relationName);
                xmlWriter.writeStartElement(buffer.toString());
                this.serializeObject(value, xmlWriter);
                xmlWriter.writeEndElement();
            }
        }
    }

    private void serializeObject(Object object, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (object instanceof RadicalElement) {
            RadicalElement radicalElement = (RadicalElement)object;
            xmlWriter.writeAttribute("idref", PacXMLSerializer.getId(radicalElement));
        } else if (object instanceof Element) {
            Element element = (Element)object;
            xmlWriter.writeAttribute("xsi:type", element.getClass().getInterfaces()[0].getName());
            this.serializeComposition(element, xmlWriter);
        } else if (object instanceof String) {
            String s = (String)object;
            xmlWriter.writeCharacters(s);
        }
    }
}

