/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.serializer;

import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import com.ibm.pdp.pac.publishing.plugin.PacPublishingPlugin;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacCSVSerializer;
import com.ibm.pdp.pac.publishing.serializer.PacPublishSerializerLabel;
import com.ibm.pdp.pac.publishing.serializer.PacXMLSerializer;
import com.ibm.pdp.pac.publishing.tool.PacMappingTool;
import com.ibm.pdp.pac.publishing.wizard.PacPublishWizardLabel;
import com.ibm.pdp.util.csv.CsvWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class PacPublishingSerializer
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _XSL = "xsl";
    private static final String _XML = "xml";
    private static final String _HTML = "html";
    private static final String _INDEX = "index";
    private static final String _TABLE_OF_CONTENTS = "TableContents";
    private static final String _ALL_LIST = "All_list";
    private static final int _BUFFER_SIZE = 10000;
    private static final String _OUTPUT_TITLE = "output.title";
    private static final String _OUTPUT_CSS = "output.css";
    private static final String _OUTPUT_STRUCTURE = "output.structure";
    private static final String _STRUCTURE_FOLDER = "folder";
    private static final String _OUTPUT_FEATURES = "output.features";
    private static Map<String, Transformer> _formTransformers;
    private static Transformer _listTransformer;
    private PacPublishingPattern _pattern;

    private static Transformer getFormTransformer(String styleSheet) throws TransformerConfigurationException {
        if (_formTransformers == null) {
            _formTransformers = new HashMap<String, Transformer>();
        }
        StringBuilder buffer = new StringBuilder(styleSheet);
        buffer.append(".").append(_XSL);
        String styleSheetId = buffer.toString();
        Transformer transformer = _formTransformers.get(styleSheetId);
        if (transformer == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLFormInputStream(href);
                    return new StreamSource(xslInputStream);
                }
            });
            InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLFormInputStream(styleSheetId);
            if (xslInputStream != null) {
                StreamSource xslSource = new StreamSource(xslInputStream);
                transformer = factory.newTransformer(xslSource);
                _formTransformers.put(styleSheetId, transformer);
            }
        }
        return transformer;
    }

    private static Transformer getListTransformer() throws TransformerConfigurationException {
        if (_listTransformer == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLListInputStream(href);
                    return new StreamSource(xslInputStream);
                }
            });
            StringBuilder buffer = new StringBuilder(_ALL_LIST);
            buffer.append(".").append(_XSL);
            String styleSheetId = buffer.toString();
            InputStream xslInputStream = PacPublishingPlugin.getDefault().getXSLListInputStream(styleSheetId);
            if (xslInputStream != null) {
                StreamSource xslSource = new StreamSource(xslInputStream);
                _listTransformer = factory.newTransformer(xslSource);
            }
        }
        return _listTransformer;
    }

    private static String getFileExtension(PacPublishingPattern.OutputFormat format) {
        if (format == PacPublishingPattern.OutputFormat._XML) {
            return _XML;
        }
        if (format == PacPublishingPattern.OutputFormat._HTML_FORM) {
            return _HTML;
        }
        return "";
    }

    private static String getFileName(Document metaDocument, PacPublishingPattern.OutputFormat format) {
        StringBuilder buffer = new StringBuilder(metaDocument.getName());
        if (metaDocument.getMetaType() != null && metaDocument.getMetaType().length() > 0) {
            buffer.append(".").append(metaDocument.getMetaType());
        }
        buffer.append(".").append(PacMappingTool.getMAFType(metaDocument.getType()));
        buffer.append(".").append(PacPublishingSerializer.getFileExtension(format));
        return buffer.toString();
    }

    public PacPublishingSerializer(PacPublishingPattern pattern) {
        this._pattern = pattern;
    }

    private PacPublishingPattern getPattern() {
        return this._pattern;
    }

    public List<IStatus> serialize(IProgressMonitor monitor) {
        List<IStatus> statusList = Collections.emptyList();
        if (this.getPattern()._outputFormat == PacPublishingPattern.OutputFormat._XML) {
            if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FILE) {
                statusList = this.serializeXMLInFile(monitor);
            } else if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FOLDER) {
                statusList = this.serializeXMLInFolder(monitor);
            }
        } else if (this.getPattern()._outputFormat == PacPublishingPattern.OutputFormat._HTML_FORM) {
            if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FILE) {
                statusList = this.serializeHTMLFormInFile(monitor);
            } else if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FOLDER) {
                statusList = this.serializeHTMLFormInFolder(monitor);
            }
        } else if (this.getPattern()._outputFormat == PacPublishingPattern.OutputFormat._HTML_LIST) {
            statusList = this.serializeHTMLListInFile(monitor);
        } else if (this.getPattern()._outputFormat == PacPublishingPattern.OutputFormat._CSV) {
            statusList = this.serializeCSVInFile(monitor);
        }
        return statusList;
    }

    private List<IStatus> serializeXMLInFile(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), -1);
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
            this.serializeTableContents(this.getPattern()._metaDocuments, false, xmlWriter);
            IStatus status = null;
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
            int nbInstances = 0;
            for (Document metaDocument : this.getPattern()._metaDocuments) {
                try {
                    status = this.serializeXML(metaDocument, false, xmlWriter);
                }
                catch (XMLStreamException e) {
                    Object[] array = new String[]{metaDocument.getId(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_ARTIFACT, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                if (status != null) {
                    statusList.add(status);
                }
                if (monitor.isCanceled()) break;
                Object[] array = new String[]{Integer.toString(++nbInstances)};
                monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array));
                monitor.worked(1);
            }
            this.closeXMLWriter(xmlWriter);
            status = this.writeFile(xmlStream);
            if (status != null) {
                statusList.add(status);
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private List<IStatus> serializeHTMLFormInFile(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            IStatus status = this.serializeStyleSheet();
            if (status != null) {
                statusList.add(status);
                return statusList;
            }
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), -1);
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
            this.serializeTableContents(this.getPattern()._metaDocuments, true, xmlWriter);
            this.closeXMLWriter(xmlWriter);
            ByteArrayOutputStream htmlStream = null;
            try {
                htmlStream = this.formTransform(_TABLE_OF_CONTENTS, new ByteArrayInputStream(xmlStream.toByteArray()));
            }
            catch (TransformerException e) {
                Object[] array = new String[]{_TABLE_OF_CONTENTS, e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_FILE, array);
                statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
                return statusList;
            }
            StringBuilder htmlBuffer = new StringBuilder(htmlStream.toString());
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
            int nbInstances = 0;
            for (Document metaDocument : this.getPattern()._metaDocuments) {
                String msg;
                Object[] array;
                try {
                    xmlStream = new ByteArrayOutputStream();
                    xmlWriter = this.openXMLWriter(xmlStream);
                    status = this.serializeXML(metaDocument, true, xmlWriter);
                    this.closeXMLWriter(xmlWriter);
                    if (status != null) {
                        statusList.add(status);
                    }
                    String mafType = PacMappingTool.getMAFType(metaDocument);
                    htmlStream = this.formTransform(mafType, new ByteArrayInputStream(xmlStream.toByteArray()));
                    htmlBuffer.append(htmlStream.toString());
                }
                catch (XMLStreamException e) {
                    array = new String[]{metaDocument.getId(), e.getMessage()};
                    msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_ARTIFACT, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                catch (TransformerException e) {
                    array = new String[]{metaDocument.getId(), e.getMessage()};
                    msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_FILE, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                if (monitor.isCanceled()) break;
                Object[] array2 = new String[]{Integer.toString(++nbInstances)};
                monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array2));
                monitor.worked(1);
            }
            htmlStream = new ByteArrayOutputStream();
            htmlStream.write(htmlBuffer.toString().getBytes());
            status = this.writeFile(htmlStream);
            if (status != null) {
                statusList.add(status);
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        catch (IOException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._BUFFER_ACCESS, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private List<IStatus> serializeHTMLListInFile(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
            IStatus status = this.serializeStyleSheet();
            if (status != null) {
                statusList.add(status);
                return statusList;
            }
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
            int nbInstances = 0;
            for (Document metaDocument : this.getPattern()._metaDocuments) {
                try {
                    status = this.serializeXML(metaDocument, true, xmlWriter);
                }
                catch (XMLStreamException e) {
                    Object[] array = new String[]{metaDocument.getId(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_ARTIFACT, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                if (status != null) {
                    statusList.add(status);
                }
                if (monitor.isCanceled()) break;
                Object[] array = new String[]{Integer.toString(++nbInstances)};
                monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array));
                monitor.worked(1);
            }
            this.closeXMLWriter(xmlWriter);
            ByteArrayOutputStream htmlStream = this.listTransform(new ByteArrayInputStream(xmlStream.toByteArray()));
            status = this.writeFile(htmlStream);
            if (status != null) {
                statusList.add(status);
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        catch (TransformerException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_LIST, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private List<IStatus> serializeCSVInFile(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), -1);
        PacCSVSerializer serializer = new PacCSVSerializer(this.getPattern()._checkedClasses, this.getPattern()._checkedFeatures);
        List<Method> columns = serializer.retrieveColumns(this.getPattern()._metaDocuments);
        ByteArrayOutputStream csvStream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(csvStream), 10000);
        String separator = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._CSV_SEPARATOR);
        char csvSep = ',';
        if (separator.length() > 0) {
            csvSep = separator.charAt(0);
        }
        CsvWriter csvWriter = new CsvWriter((Writer)writer, csvSep, '\"', System.getProperty("line.separator"));
        csvWriter.addCell("Class");
        for (Method method : columns) {
            csvWriter.addCell(method.getName().replace("get", ""));
        }
        csvWriter.endOfRow();
        IStatus status = null;
        monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
        int nbInstances = 0;
        for (Document metaDocument : this.getPattern()._metaDocuments) {
            status = this.serializeCSV(metaDocument, columns, csvWriter);
            if (status != null) {
                statusList.add(status);
            }
            if (monitor.isCanceled()) break;
            Object[] array = new String[]{Integer.toString(++nbInstances)};
            monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array));
            monitor.worked(1);
        }
        csvWriter.close();
        status = this.writeFile(csvStream);
        if (status != null) {
            statusList.add(status);
        }
        return statusList;
    }

    private List<IStatus> serializeXMLInFolder(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), -1);
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
            this.serializeTableContents(this.getPattern()._metaDocuments, false, xmlWriter);
            this.closeXMLWriter(xmlWriter);
            StringBuilder buffer = new StringBuilder(_INDEX);
            buffer.append(".").append(PacPublishingSerializer.getFileExtension(this.getPattern()._outputFormat));
            IStatus status = this.writeFileInFolder(buffer.toString(), null, xmlStream);
            if (status != null) {
                return statusList;
            }
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
            int nbInstances = 0;
            for (Document metaDocument : this.getPattern()._metaDocuments) {
                Object[] array;
                try {
                    xmlStream = new ByteArrayOutputStream();
                    xmlWriter = this.openXMLWriter(xmlStream);
                    status = this.serializeXML(metaDocument, false, xmlWriter);
                }
                catch (XMLStreamException e) {
                    array = new String[]{metaDocument.getId(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_ARTIFACT, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                if (status != null) {
                    statusList.add(status);
                }
                this.closeXMLWriter(xmlWriter);
                String fileName = PacPublishingSerializer.getFileName(metaDocument, this.getPattern()._outputFormat);
                status = this.writeFileInFolder(fileName, metaDocument.getProject(), xmlStream);
                if (status != null) {
                    statusList.add(status);
                }
                if (!monitor.isCanceled()) {
                    array = new String[]{Integer.toString(++nbInstances)};
                    monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array));
                    monitor.worked(1);
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private List<IStatus> serializeHTMLFormInFolder(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        try {
            IStatus status = this.serializeStyleSheet();
            if (status != null) {
                statusList.add(status);
                return statusList;
            }
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), -1);
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            XMLStreamWriter xmlWriter = this.openXMLWriter(xmlStream);
            this.serializeTableContents(this.getPattern()._metaDocuments, true, xmlWriter);
            this.closeXMLWriter(xmlWriter);
            ByteArrayOutputStream htmlStream = null;
            try {
                htmlStream = this.formTransform(_TABLE_OF_CONTENTS, new ByteArrayInputStream(xmlStream.toByteArray()));
            }
            catch (TransformerException e) {
                Object[] array = new String[]{_TABLE_OF_CONTENTS, e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_FILE, array);
                statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
                return statusList;
            }
            StringBuilder buffer = new StringBuilder(_INDEX);
            buffer.append(".").append(PacPublishingSerializer.getFileExtension(this.getPattern()._outputFormat));
            status = this.writeFileInFolder(buffer.toString(), null, htmlStream);
            if (status != null) {
                statusList.add(status);
                return statusList;
            }
            monitor.beginTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._PUBLISH_INSTANCES), this.getPattern()._metaDocuments.size());
            int nbInstances = 0;
            for (Document metaDocument : this.getPattern()._metaDocuments) {
                String msg;
                Object[] array;
                try {
                    xmlStream = new ByteArrayOutputStream();
                    xmlWriter = this.openXMLWriter(xmlStream);
                    status = this.serializeXML(metaDocument, true, xmlWriter);
                    this.closeXMLWriter(xmlWriter);
                    if (status != null) {
                        statusList.add(status);
                    }
                    String mafType = PacMappingTool.getMAFType(metaDocument);
                    htmlStream = this.formTransform(mafType, new ByteArrayInputStream(xmlStream.toByteArray()));
                }
                catch (XMLStreamException e) {
                    array = new String[]{metaDocument.getId(), e.getMessage()};
                    msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_ARTIFACT, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                catch (TransformerException e) {
                    array = new String[]{metaDocument.getId(), e.getMessage()};
                    msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._TRANSFORM_FILE, array);
                    status = new Status(4, "org.eclipse.ui", 0, msg, null);
                }
                String fileName = PacPublishingSerializer.getFileName(metaDocument, this.getPattern()._outputFormat);
                status = this.writeFileInFolder(fileName, metaDocument.getProject(), htmlStream);
                if (status != null) {
                    statusList.add(status);
                }
                if (!monitor.isCanceled()) {
                    array = new String[]{Integer.toString(++nbInstances)};
                    monitor.subTask(PacPublishWizardLabel.getString(PacPublishWizardLabel._NB_PUBLISHED_INSTANCES, array));
                    monitor.worked(1);
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            Object[] array = new String[]{e.getMessage()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._SERIALIZE_XML, array);
            statusList.add((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return statusList;
        }
        return statusList;
    }

    private XMLStreamWriter openXMLWriter(OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriter xmlWriter = null;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        xmlWriter = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        xmlWriter.writeStartDocument("UTF-8", "1.0");
        xmlWriter.writeStartElement("rpp:publishing");
        xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.writeNamespace("rpp", "https://com.ibm.pdp.pac.publishing");
        return xmlWriter;
    }

    private void closeXMLWriter(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeEndElement();
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
    }

    private IStatus serializeStyleSheet() {
        InputStream cssInputStream = null;
        if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._LOCAL) {
            StringBuilder buffer = new StringBuilder();
            if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FILE) {
                buffer.append(this.getPattern()._fileLocalFolder);
            } else if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FOLDER) {
                buffer.append(this.getPattern()._folderLocalName);
            }
            buffer.append("/").append("rpp.css");
            try {
                try {
                    cssInputStream = PacPublishingPlugin.getDefault().getCSSInputStream();
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = workspaceRoot.getFile((IPath)new Path(buffer.toString()));
                    if (!file.exists()) {
                        file.create(cssInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    Object[] array = new String[]{buffer.toString(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                    Status status = new Status(4, "org.eclipse.ui", 0, msg, null);
                    try {
                        cssInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    cssInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                cssInputStream.close();
            }
            catch (IOException iOException) {}
        } else if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._EXTERNAL) {
            StringBuilder buffer = new StringBuilder();
            if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FILE) {
                Path path = new Path(this.getPattern()._fileExternalName);
                if (path.getDevice() != null) {
                    buffer.append(path.getDevice());
                }
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    buffer.append("/").append(path.segment(i));
                    ++i;
                }
            } else if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FOLDER) {
                buffer.append(this.getPattern()._folderExternalName);
            }
            buffer.append("/").append("rpp.css");
            try {
                try {
                    cssInputStream = PacPublishingPlugin.getDefault().getCSSInputStream();
                    File file = new File(buffer.toString());
                    if (!file.exists()) {
                        StringBuilder cssBuffer = new StringBuilder();
                        int c = 0;
                        while ((c = cssInputStream.read()) != -1) {
                            cssBuffer.append((char)c);
                        }
                        FileOutputStream fos = this.createExternalFile(buffer.toString());
                        BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
                        outputStreamBuffer.write(cssBuffer.toString().getBytes());
                        outputStreamBuffer.close();
                        fos.close();
                    }
                }
                catch (IOException e) {
                    Object[] array = new String[]{buffer.toString(), e.getMessage()};
                    String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                    Status status = new Status(4, "org.eclipse.ui", 0, msg, null);
                    try {
                        cssInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    cssInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                cssInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private void serializeTableContents(List<Document> metaDocuments, boolean forHTML, XMLStreamWriter xmlWriter) throws XMLStreamException {
        PacXMLSerializer serializer = new PacXMLSerializer(this.getPattern()._checkedClasses, this.getPattern()._checkedFeatures);
        serializer.serializeTableContents(metaDocuments, xmlWriter);
    }

    private IStatus serializeXML(Document metaDocument, boolean forHTML, XMLStreamWriter xmlWriter) throws XMLStreamException {
        PacXMLSerializer serializer = new PacXMLSerializer(this.getPattern()._checkedClasses, this.getPattern()._checkedFeatures);
        IStatus status = serializer.serialize(metaDocument, xmlWriter);
        return status;
    }

    private IStatus serializeCSV(Document metaDocument, List<Method> columns, CsvWriter csvWriter) {
        PacCSVSerializer serializer = new PacCSVSerializer(this.getPattern()._checkedClasses, this.getPattern()._checkedFeatures);
        return serializer.serialize(metaDocument, columns, csvWriter);
    }

    private IStatus writeFile(ByteArrayOutputStream outputStream) {
        if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._LOCAL) {
            StringBuilder buffer = new StringBuilder(this.getPattern()._fileLocalFolder);
            buffer.append("/").append(this.getPattern()._fileLocalName);
            try {
                this.createLocalFile(buffer.toString(), outputStream);
            }
            catch (CoreException e) {
                Object[] array = new String[]{buffer.toString(), e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._EXTERNAL) {
            try {
                FileOutputStream fos = this.createExternalFile(this.getPattern()._fileExternalName);
                BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
                outputStreamBuffer.write(outputStream.toByteArray());
                outputStreamBuffer.close();
                fos.close();
            }
            catch (IOException e) {
                Object[] array = new String[]{this.getPattern()._fileExternalName, e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        return null;
    }

    private IStatus writeFileInFolder(String fileName, String subFolderName, ByteArrayOutputStream outputStream) {
        if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._LOCAL) {
            StringBuilder buffer = new StringBuilder(this.getPattern()._folderLocalName);
            if (subFolderName != null && subFolderName.length() > 0) {
                buffer.append("/").append(subFolderName);
            }
            try {
                this.createLocalFolder(buffer.toString());
                buffer.append("/").append(fileName);
                this.createLocalFile(buffer.toString(), outputStream);
            }
            catch (CoreException e) {
                Object[] array = new String[]{buffer.toString(), e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        if (this.getPattern()._outputTarget == PacPublishingPattern.OutputTarget._EXTERNAL) {
            StringBuilder buffer = new StringBuilder(this.getPattern()._folderExternalName);
            if (subFolderName != null && subFolderName.length() > 0) {
                buffer.append("/").append(subFolderName);
            }
            try {
                this.createExternalFolder(buffer.toString());
                buffer.append("/").append(fileName);
                FileOutputStream fos = this.createExternalFile(buffer.toString());
                BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
                outputStreamBuffer.write(outputStream.toByteArray());
                outputStreamBuffer.close();
                fos.close();
            }
            catch (IOException e) {
                Object[] array = new String[]{buffer.toString(), e.getMessage()};
                String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._FILE_ACCESS, array);
                return new Status(4, "org.eclipse.ui", 0, msg, null);
            }
        }
        return null;
    }

    private void createLocalFile(String fileName, ByteArrayOutputStream fileContent) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(fileName));
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(fileContent.toByteArray()), 0, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.create((InputStream)new ByteArrayInputStream(fileContent.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private FileOutputStream createExternalFile(String fileName) throws FileNotFoundException {
        return new FileOutputStream(fileName);
    }

    private void createLocalFolder(String folderName) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(folderName);
        IProject container = null;
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            if (i == 0) {
                IProject project = workspaceRoot.getProject(segment);
                if (project == null || !project.exists()) {
                    return;
                }
                container = project;
            } else {
                IFolder folder = container.getFolder((IPath)new Path(segment));
                if (folder == null || !folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                container = folder;
            }
            ++i;
        }
    }

    private void createExternalFolder(String folderName) throws FileNotFoundException {
        File file = new File(folderName);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
    }

    private ByteArrayOutputStream formTransform(String styleSheet, InputStream xmlInputStream) throws TransformerException {
        Transformer transformer = PacPublishingSerializer.getFormTransformer(styleSheet);
        transformer.setParameter(_OUTPUT_TITLE, this.getPattern()._title);
        transformer.setParameter(_OUTPUT_CSS, "rpp.css");
        transformer.setParameter(_OUTPUT_STRUCTURE, "");
        if (this.getPattern()._outputStructure == PacPublishingPattern.OutputStructure._FOLDER) {
            if (!styleSheet.equals(_TABLE_OF_CONTENTS)) {
                transformer.setParameter(_OUTPUT_CSS, "../rpp.css");
            }
            transformer.setParameter(_OUTPUT_STRUCTURE, _STRUCTURE_FOLDER);
        }
        ByteArrayOutputStream htmlOutputStream = new ByteArrayOutputStream();
        StreamSource xmlSource = new StreamSource(xmlInputStream);
        StreamResult htmlResult = new StreamResult(htmlOutputStream);
        transformer.transform(xmlSource, htmlResult);
        return htmlOutputStream;
    }

    private ByteArrayOutputStream listTransform(InputStream xmlInputStream) throws TransformerException {
        Transformer transformer = PacPublishingSerializer.getListTransformer();
        transformer.setParameter(_OUTPUT_TITLE, this.getPattern()._title);
        transformer.setParameter(_OUTPUT_FEATURES, "");
        if (this.getPattern()._checkedFeatures != null) {
            StringBuilder buffer = new StringBuilder("");
            for (Map.Entry<String, Set<String>> entry : this.getPattern()._checkedFeatures.entrySet()) {
                String className = entry.getKey();
                int index = className.lastIndexOf(46);
                if (index > 0) {
                    className = className.substring(index + 1);
                }
                for (String featureName : entry.getValue()) {
                    buffer.append("#").append(className).append(".").append(featureName);
                }
            }
            transformer.setParameter(_OUTPUT_FEATURES, buffer.toString());
        }
        ByteArrayOutputStream htmlOutputStream = new ByteArrayOutputStream();
        StreamSource xmlSource = new StreamSource(xmlInputStream);
        StreamResult htmlResult = new StreamResult(htmlOutputStream);
        transformer.transform(xmlSource, htmlResult);
        return htmlOutputStream;
    }
}

