/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.serializer;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.serializer.PacAbstractSerializer;
import com.ibm.pdp.pac.publishing.serializer.PacPublishSerializerLabel;
import com.ibm.pdp.pac.publishing.tool.PacMappingTool;
import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import com.ibm.pdp.util.csv.CsvWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PacCSVSerializer
extends PacAbstractSerializer
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacCSVSerializer(Set<String> checkedClasses, Map<String, Set<String>> checkedFeatures) {
        this._checkedClasses = checkedClasses;
        this._allCheckedFeatures = checkedFeatures;
    }

    public List<Method> retrieveColumns(List<Document> metaDocuments) {
        HashSet<Class> keyedInterfaces = new HashSet<Class>();
        ArrayList<Class> mafInterfaces = new ArrayList<Class>();
        for (Document metaDocument : metaDocuments) {
            Class mafInterface = PacMappingTool.getMAFInterface(metaDocument);
            if (mafInterface == null || !mafInterface.isInterface() || keyedInterfaces.contains(mafInterface)) continue;
            keyedInterfaces.add(mafInterface);
            mafInterfaces.add(mafInterface);
        }
        HashSet<Method> keyedMethods = new HashSet<Method>();
        ArrayList<Method> columns = new ArrayList<Method>();
        for (Class mafInterface : mafInterfaces) {
            Method[] methods = mafInterface.getMethods();
            int i = methods.length - 1;
            while (i >= 0) {
                boolean isFeatureChecked;
                Method method = methods[i];
                if (method != null && PacSchemaItem.getKind(method) == PacSchemaItem.SchemaItemKind._ATTRIBUTE && (isFeatureChecked = this.isFeatureChecked(method.getDeclaringClass().getName(), method.getName())) && !keyedMethods.contains(method)) {
                    keyedMethods.add(method);
                    columns.add(method);
                }
                --i;
            }
        }
        return columns;
    }

    public IStatus serialize(Document metaDocument, List<Method> columns, CsvWriter csvWriter) {
        String type;
        String name;
        String metaType;
        String packageName;
        String projectName;
        IMAFModelService mafService = MAFModelManager.getServiceInstance();
        RadicalElement radicalElement = mafService.getRadicalElement(projectName = metaDocument.getProject(), packageName = metaDocument.getPackage(), metaType = metaDocument.getMetaType(), name = metaDocument.getName(), type = metaDocument.getType());
        if (radicalElement == null) {
            Object[] array = new String[]{metaDocument.getId()};
            String msg = PacPublishSerializerLabel.getString(PacPublishSerializerLabel._LOAD_ARTIFACT, array);
            return new Status(4, "org.eclipse.ui", 0, msg, null);
        }
        this.serialize(radicalElement, columns, csvWriter);
        return null;
    }

    private void serialize(RadicalElement radicalElement, List<Method> columns, CsvWriter csvWriter) {
        csvWriter.addCell(radicalElement.getClass().getSimpleName());
        for (Method method : columns) {
            Object attValue = null;
            try {
                attValue = method.invoke((Object)radicalElement, null);
            }
            catch (Exception exception) {
                attValue = "-";
            }
            if (attValue == null) {
                attValue = "null";
            }
            csvWriter.addCell(attValue.toString());
        }
        csvWriter.endOfRow();
    }
}

