/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.serializer;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.blockbase.AbstractBlockBase;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.publishing.tool.PacMappingTool;
import java.util.Map;
import java.util.Set;

public abstract class PacAbstractSerializer
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Set<String> _checkedClasses = null;
    protected Map<String, Set<String>> _allCheckedFeatures = null;

    protected static String getId(RadicalElement radicalElement) {
        StringBuilder buffer = new StringBuilder(radicalElement.getProject());
        if (radicalElement.getPackage() != null && radicalElement.getPackage().length() > 0) {
            buffer.append("/").append(radicalElement.getPackage().replace('.', '/'));
        }
        buffer.append("/").append(radicalElement.getName());
        String metaType = null;
        if (metaType != null && metaType.length() > 0) {
            buffer.append(".").append(metaType);
        }
        buffer.append(".").append(PacAbstractSerializer.getRadicalType(radicalElement));
        return buffer.toString();
    }

    protected static String getId(Document metaDocument) {
        StringBuilder buffer = new StringBuilder(metaDocument.getProject());
        if (metaDocument.getPackage() != null && metaDocument.getPackage().length() > 0) {
            buffer.append("/").append(metaDocument.getPackage().replace('.', '/'));
        }
        buffer.append("/").append(metaDocument.getName());
        if (metaDocument.getMetaType() != null && metaDocument.getMetaType().length() > 0) {
            buffer.append(".").append(metaDocument.getMetaType());
        }
        buffer.append(".").append(PacMappingTool.getMAFType(metaDocument.getType()));
        return buffer.toString();
    }

    protected static String getRadicalType(RadicalElement radicalElement) {
        if (radicalElement instanceof AbstractSegment) {
            return "Segment";
        }
        if (radicalElement instanceof AbstractBlockBase) {
            return "Blockbase";
        }
        return radicalElement.getClass().getSimpleName();
    }

    protected boolean isFeatureChecked(String className, String featureName) {
        if (this._allCheckedFeatures == null || this._allCheckedFeatures.size() == 0) {
            return true;
        }
        if (this._allCheckedFeatures.containsKey(className)) {
            Set<String> checkedFeatures = this._allCheckedFeatures.get(className);
            return checkedFeatures == null || checkedFeatures.contains(featureName);
        }
        return false;
    }
}

