/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.provider;

import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.pac.publishing.plugin.PacPublishingPlugin;
import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PacSchemaLabelProvider
extends LabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Image getImage(Object element) {
        Image image = PTExplorerPlugin.getDefault().getImage("unknown");
        if (element instanceof PacSchemaItem) {
            PacSchemaItem schemaItem = (PacSchemaItem)element;
            if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._ATTRIBUTE) {
                image = PacPublishingPlugin.getDefault().getImage("attribute");
            } else if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._COMPOSITION) {
                image = PacPublishingPlugin.getDefault().getImage("composition");
            } else if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._AGGREGATION) {
                image = PacPublishingPlugin.getDefault().getImage("aggregation");
            } else if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._CLASS) {
                image = PacPublishingPlugin.getDefault().getImage("class");
            }
        }
        return image;
    }

    public String getText(Object element) {
        String label = "Unknown";
        if (element instanceof PacSchemaItem) {
            PacSchemaItem schemaItem = (PacSchemaItem)element;
            StringBuilder buffer = new StringBuilder(schemaItem.getSimpleName());
            if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._ATTRIBUTE) {
                Class<?> returnType = schemaItem.getMethod().getReturnType();
                if (returnType != null) {
                    buffer.append("  (").append(returnType.getSimpleName()).append(")");
                }
            } else if (schemaItem.getKind() == PacSchemaItem.SchemaItemKind._COMPOSITION || schemaItem.getKind() == PacSchemaItem.SchemaItemKind._AGGREGATION) {
                if (PacSchemaItem.isMultiple(schemaItem.getMethod())) {
                    Class<?> returnType = schemaItem.getMethod().getReturnType();
                    if (returnType != null) {
                        buffer.append("  (").append(returnType.getSimpleName());
                        Class<?> genericClass = PacSchemaItem.getGenericClass(schemaItem.getMethod());
                        if (genericClass != null) {
                            buffer.append("<").append(genericClass.getSimpleName()).append(">");
                        }
                        buffer.append(")");
                    }
                } else {
                    Class<?> returnType = schemaItem.getMethod().getReturnType();
                    if (returnType != null) {
                        buffer.append("  (").append(returnType.getSimpleName()).append(")");
                    }
                }
            } else {
                schemaItem.getKind();
            }
            label = buffer.toString();
        }
        return label;
    }
}

