/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.provider;

import com.ibm.pdp.pac.publishing.tool.PacSchemaItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PacSchemaContentProvider
implements ITreeContentProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean _hideAttributes = false;
    private boolean _hideComposition = false;
    private boolean _hideAggregation = false;

    public PacSchemaContentProvider() {
    }

    public PacSchemaContentProvider(boolean hideAttributes, boolean hideComposition, boolean hideAggregation) {
        this._hideAttributes = hideAttributes;
        this._hideComposition = hideComposition;
        this._hideAggregation = hideAggregation;
    }

    public Object[] getElements(Object element) {
        Object[] array = new Object[]{};
        if (element instanceof List) {
            array = ((List)element).toArray();
        }
        return array;
    }

    public Object[] getChildren(Object element) {
        Object[] array = new Object[]{};
        if (element instanceof PacSchemaItem) {
            PacSchemaItem schemaItem = (PacSchemaItem)element;
            if (this._hideAttributes || this._hideComposition || this._hideAggregation) {
                ArrayList<PacSchemaItem> children = new ArrayList<PacSchemaItem>(schemaItem.getChildren().size());
                for (PacSchemaItem item : schemaItem.getChildren()) {
                    if (this._hideAttributes && item.getKind() == PacSchemaItem.SchemaItemKind._ATTRIBUTE || this._hideComposition && item.getKind() == PacSchemaItem.SchemaItemKind._COMPOSITION || this._hideAggregation && item.getKind() == PacSchemaItem.SchemaItemKind._AGGREGATION) continue;
                    children.add(item);
                }
                array = children.toArray();
            } else {
                array = schemaItem.getChildren().toArray();
            }
        }
        return array;
    }

    public Object getParent(Object element) {
        PacSchemaItem parent = null;
        if (element instanceof PacSchemaItem) {
            parent = ((PacSchemaItem)element).getParent();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PacSchemaItem) {
            PacSchemaItem schemaItem = (PacSchemaItem)element;
            if (this._hideAttributes || this._hideComposition || this._hideAggregation) {
                for (PacSchemaItem item : schemaItem.getChildren()) {
                    if (this._hideAttributes && item.getKind() == PacSchemaItem.SchemaItemKind._ATTRIBUTE || this._hideComposition && item.getKind() == PacSchemaItem.SchemaItemKind._COMPOSITION || this._hideAggregation && item.getKind() == PacSchemaItem.SchemaItemKind._AGGREGATION) continue;
                    return true;
                }
            } else {
                return schemaItem.getChildren().size() > 0;
            }
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void hideAttributes(boolean hideAttributes) {
        this._hideAttributes = hideAttributes;
    }

    public void hideComposition(boolean hideComposition) {
        this._hideComposition = hideComposition;
    }

    public void hideAggregation(boolean hideAggregation) {
        this._hideAggregation = hideAggregation;
    }
}

