/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.provider;

import com.ibm.pdp.explorer.editor.provider.PTFacetLabelProvider;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTFolder;
import com.ibm.pdp.explorer.model.PTModelLabel;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTPackage;
import com.ibm.pdp.explorer.model.PTProject;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.PTViewLabel;
import com.ibm.pdp.explorer.view.provider.IPTLabelProvider;
import com.ibm.pdp.explorer.view.tool.PTDecorator;
import com.ibm.pdp.mdl.meta.Document;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PacPublishingLabelProvider
extends LabelProvider
implements IPTLabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTDecorator _decorator = PTDecorator.getInstance();
    private int _displayMode = 28;

    public PacPublishingLabelProvider(int displayMode) {
        this._displayMode = displayMode;
    }

    public Image getImage(Object object) {
        Image image = PTExplorerPlugin.getDefault().getImage("unknown");
        String overlayKey = "";
        int quadrant = 3;
        if (object instanceof PTFolder || object instanceof PTPackage || object instanceof PTProject) {
            if (object instanceof PTFolder) {
                image = PTExplorerPlugin.getDefault().getImage("folder");
            } else if (object instanceof PTPackage) {
                image = PTExplorerPlugin.getDefault().getImage("package");
            } else if (object instanceof PTProject) {
                image = PTExplorerPlugin.getDefault().getImage("project");
            }
            image = this._decorator.decorateImage(image, overlayKey, quadrant);
        } else if (object instanceof PTElement) {
            PTElement element = (PTElement)object;
            Document metaDocument = element.getDocument();
            PTFacet facet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
            PTFacetLabelProvider labelProvider = facet.getLabelProvider(metaDocument.getType());
            if (labelProvider != null) {
                image = labelProvider.getImage((Object)metaDocument, overlayKey, quadrant);
            }
        }
        return image;
    }

    public String getText(Object object) {
        String label = PTModelLabel.getString((String)PTModelLabel._UNKNOWN);
        if (object instanceof PTFolder || object instanceof PTPackage || object instanceof PTProject) {
            String displayName = "";
            List elements = new ArrayList();
            if (object instanceof PTFolder) {
                displayName = ((PTFolder)object).getDisplayName();
                elements = ((PTFolder)object).getElements();
            } else if (object instanceof PTPackage) {
                displayName = ((PTPackage)object).getName();
                elements = ((PTPackage)object).getElements();
            } else if (object instanceof PTProject) {
                displayName = ((PTProject)object).getName();
                elements = ((PTProject)object).getElements();
            }
            StringBuilder buffer = new StringBuilder(displayName);
            buffer.append(" - ");
            buffer.append(elements.size());
            buffer.append(" ");
            buffer.append(PTViewLabel.getString((String)PTViewLabel._INSTANCES));
            label = buffer.toString();
        } else if (object instanceof PTElement) {
            Document metaDocument = ((PTElement)object).getDocument();
            PTFacet facet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
            PTFacetLabelProvider labelProvider = facet.getLabelProvider(metaDocument.getType());
            if (labelProvider != null) {
                label = labelProvider.getText((Object)metaDocument);
            }
            label = this._decorator.decorateLabel(label, (Object)metaDocument, this._displayMode);
        }
        return label;
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
    }
}

