/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.plugin;

import com.ibm.pdp.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PacPublishingPlugin
extends AbstractUIPlugin {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = "com.ibm.pdp.pac.publishing";
    public static final String _HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    private static PacPublishingPlugin _plugin;
    private static URL _folderURL;
    private Map<String, Image> _images = new HashMap<String, Image>();
    private Map<String, ImageDescriptor> _descriptors = new HashMap<String, ImageDescriptor>();

    public PacPublishingPlugin() {
        _plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static PacPublishingPlugin getDefault() {
        return _plugin;
    }

    public static URL getFolderURL() {
        if (_folderURL == null) {
            _folderURL = PacPublishingPlugin.getDefault().getBundle().getEntry("/");
        }
        return _folderURL;
    }

    public Image getImage(String key) {
        Image image = this._images.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            image = descriptor.createImage();
            this._images.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imgDescriptor = this._descriptors.get(key);
        if (imgDescriptor == null) {
            try {
                URL gifImageURL = new URL(PacPublishingPlugin.getFolderURL(), "icons/" + key + ".gif");
                imgDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
                this._descriptors.put(key, imgDescriptor);
            }
            catch (MalformedURLException e) {
                throw Util.rethrow((Throwable)e);
            }
        }
        return imgDescriptor;
    }

    public InputStream getCSSInputStream() {
        BufferedInputStream cssInputStream;
        try {
            URL url = new URL(PacPublishingPlugin.getFolderURL(), "styleSheets/rpp.css");
            cssInputStream = new BufferedInputStream(url.openStream(), 10000);
        }
        catch (IOException e) {
            throw Util.rethrow((Throwable)e);
        }
        return cssInputStream;
    }

    public InputStream getXSLFormInputStream(String key) {
        BufferedInputStream xslInputStream = null;
        try {
            URL url = new URL(PacPublishingPlugin.getFolderURL(), "styleSheets/form/" + key);
            xslInputStream = new BufferedInputStream(url.openStream(), 10000);
        }
        catch (IOException e) {
            throw Util.rethrow((Throwable)e);
        }
        return xslInputStream;
    }

    public InputStream getXSLListInputStream(String key) {
        BufferedInputStream xslInputStream = null;
        try {
            URL url = new URL(PacPublishingPlugin.getFolderURL(), "styleSheets/list/" + key);
            xslInputStream = new BufferedInputStream(url.openStream(), 10000);
        }
        catch (IOException e) {
            throw Util.rethrow((Throwable)e);
        }
        return xslInputStream;
    }

    public InputStream getXSLVolumeInputStream(String key) {
        BufferedInputStream xslInputStream = null;
        try {
            URL url = new URL(PacPublishingPlugin.getFolderURL(), "styleSheets/volume/" + key);
            xslInputStream = new BufferedInputStream(url.openStream(), 10000);
        }
        catch (IOException iOException) {
            try {
                URL url = new URL(PacPublishingPlugin.getFolderURL(), "styleSheets/form/" + key);
                xslInputStream = new BufferedInputStream(url.openStream(), 10000);
            }
            catch (IOException e2) {
                throw Util.rethrow((Throwable)e2);
            }
        }
        return xslInputStream;
    }
}

