/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.model;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.publishing.model.PacPublishingPattern;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PacPublishingSession {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date _date;
    private PacPublishingPattern _pattern = new PacPublishingPattern();
    private Set<String> _designIds = null;

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public String getTitle() {
        if (this._pattern._title == null) {
            this._pattern._title = "";
        }
        return this._pattern._title;
    }

    public void setTitle(String title) {
        this._pattern._title = title;
    }

    public boolean getSerializeRef() {
        return this._pattern._serializeRef;
    }

    public void setSerializeRef(boolean serializeRef) {
        this._pattern._serializeRef = serializeRef;
    }

    public PacPublishingPattern.OutputFormat getOutputFormat() {
        return this._pattern._outputFormat;
    }

    public void setOutputFormat(PacPublishingPattern.OutputFormat outputFormat) {
        this._pattern._outputFormat = outputFormat;
    }

    public PacPublishingPattern.OutputStructure getOutputStructure() {
        return this._pattern._outputStructure;
    }

    public void setOutputStructure(PacPublishingPattern.OutputStructure outputStructure) {
        this._pattern._outputStructure = outputStructure;
    }

    public PacPublishingPattern.OutputTarget getOutputTarget() {
        return this._pattern._outputTarget;
    }

    public void setOutputTarget(PacPublishingPattern.OutputTarget outputTarget) {
        this._pattern._outputTarget = outputTarget;
    }

    public String getFileLocalFolder() {
        if (this._pattern._fileLocalFolder == null) {
            this._pattern._fileLocalFolder = "";
        }
        return this._pattern._fileLocalFolder;
    }

    public void setFileLocalFolder(String fileLocalFolder) {
        this._pattern._fileLocalFolder = fileLocalFolder;
    }

    public String getFileLocalName() {
        if (this._pattern._fileLocalName == null) {
            this._pattern._fileLocalName = "";
        }
        return this._pattern._fileLocalName;
    }

    public void setFileLocalName(String fileLocalName) {
        this._pattern._fileLocalName = fileLocalName;
    }

    public String getFileExternalName() {
        if (this._pattern._fileExternalName == null) {
            this._pattern._fileExternalName = "";
        }
        return this._pattern._fileExternalName;
    }

    public void setFileExternalName(String fileExternalName) {
        this._pattern._fileExternalName = fileExternalName;
    }

    public String getFolderLocalName() {
        if (this._pattern._folderLocalName == null) {
            this._pattern._folderLocalName = "";
        }
        return this._pattern._folderLocalName;
    }

    public void setFolderLocalName(String folderLocalName) {
        this._pattern._folderLocalName = folderLocalName;
    }

    public String getFolderExternalName() {
        if (this._pattern._folderExternalName == null) {
            this._pattern._folderExternalName = "";
        }
        return this._pattern._folderExternalName;
    }

    public void setFolderExternalName(String folderExternalName) {
        this._pattern._folderExternalName = folderExternalName;
    }

    public PTLocation getEditableLocation() {
        PTLocation location = new PTLocation("Publishing");
        location.open(false, false);
        for (Document metaDocument : this.getDocuments()) {
            PTElement wrapper = new PTElement(metaDocument, location);
            location.addElement(wrapper);
        }
        return location;
    }

    public List<Document> getDocuments() {
        if (this._pattern._metaDocuments == null) {
            this._pattern._metaDocuments = new ArrayList<Document>();
        }
        return this._pattern._metaDocuments;
    }

    private Set<String> getDesignIds() {
        if (this._designIds == null) {
            this._designIds = new HashSet<String>();
        }
        return this._designIds;
    }

    public void addDocument(Document metaDocument) {
        if (!this.getDesignIds().contains(metaDocument.getId())) {
            this.getDesignIds().add(metaDocument.getId());
            this.getDocuments().add(metaDocument);
        }
    }

    public void removeDocument(Document metaDocument) {
        this.getDesignIds().remove(metaDocument.getId());
        this.getDocuments().remove(metaDocument);
    }

    public Set<String> getCheckedClasses() {
        if (this._pattern._checkedClasses == null) {
            this._pattern._checkedClasses = new HashSet<String>();
        }
        return this._pattern._checkedClasses;
    }

    public Map<String, Set<String>> getCheckedFeatures() {
        if (this._pattern._checkedFeatures == null) {
            this._pattern._checkedFeatures = new HashMap<String, Set<String>>();
        }
        return this._pattern._checkedFeatures;
    }

    public PacPublishingSession duplicate() {
        PacPublishingSession duplicate = new PacPublishingSession();
        duplicate.setDate(this.getDate());
        duplicate.setTitle(this.getTitle());
        duplicate.setSerializeRef(this.getSerializeRef());
        for (Document metaDocument : this.getDocuments()) {
            duplicate.addDocument(metaDocument);
        }
        duplicate.getCheckedClasses().addAll(this.getCheckedClasses());
        duplicate.getCheckedFeatures().putAll(this.getCheckedFeatures());
        duplicate.setOutputFormat(this.getOutputFormat());
        duplicate.setOutputStructure(this.getOutputStructure());
        duplicate.setOutputTarget(this.getOutputTarget());
        duplicate.setFileLocalFolder(this.getFileLocalFolder());
        duplicate.setFileLocalName(this.getFileLocalName());
        duplicate.setFileExternalName(this.getFileExternalName());
        duplicate.setFolderLocalName(this.getFolderLocalName());
        duplicate.setFolderExternalName(this.getFolderExternalName());
        return duplicate;
    }
}

