/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.dialog;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFolder;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTPackage;
import com.ibm.pdp.explorer.model.PTProject;
import com.ibm.pdp.explorer.model.tool.PTComparator;
import com.ibm.pdp.explorer.view.IPTStructuredViewer;
import com.ibm.pdp.explorer.view.actiongroup.PTDisplayActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSortActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTTopLevelActionGroup;
import com.ibm.pdp.explorer.view.provider.IPTContentProvider;
import com.ibm.pdp.explorer.view.provider.IPTLabelProvider;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.view.tool.PTViewerComparator;
import com.ibm.pdp.pac.publishing.dialog.PacDialogLabel;
import com.ibm.pdp.pac.publishing.plugin.IPacPublishingPreferences;
import com.ibm.pdp.pac.publishing.provider.PacPublishingContentProvider;
import com.ibm.pdp.pac.publishing.provider.PacPublishingLabelProvider;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PacEditSessionDialog
extends Dialog
implements IPTStructuredViewer,
IPacPublishingPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TreeViewer _trvViewer = null;
    private Button _pbRemove;
    private String _sessionLabel;
    private PTLocation _editedLocation;
    private Set<PTElement> _removedElements;
    private IEclipsePreferences _prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.explorer");
    private int _topLevelMode = 3;
    private int _sortMode = 1;
    private int _displayMode = 5;
    private PTTopLevelActionGroup _topLevelActionGroup;
    private PTSortActionGroup _sortActionGroup;
    private PTDisplayActionGroup _displayActionGroup;

    public PacEditSessionDialog(Shell shell, String sessionLabel, PTLocation editedLocation) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        int[] topLevelModes = new int[]{1, 2, 3};
        this._topLevelActionGroup = new PTTopLevelActionGroup((IPTStructuredViewer)this, topLevelModes);
        int[] sortModes = new int[]{1, 2, 3};
        this._sortActionGroup = new PTSortActionGroup((IPTStructuredViewer)this, sortModes);
        int[] displayModes = new int[]{4, 8, 16};
        this._displayActionGroup = new PTDisplayActionGroup((IPTStructuredViewer)this, displayModes);
        this._sessionLabel = sessionLabel;
        this._editedLocation = editedLocation;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PacDialogLabel.getString(PacDialogLabel._SESSION_DIALOG_TITLE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextId());
        this._topLevelMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_TOP_LEVEL", this._topLevelMode);
        this._sortMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_SORT", this._sortMode);
        this._displayMode = this._prefs.getInt("_PREF_PUBLISH_SESSION_PAGE_DISPLAY", this._displayMode);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.heightHint = 600;
        composite.setLayoutData((Object)gridData);
        Object[] array = new String[]{this._sessionLabel};
        String label = PacDialogLabel.getString(PacDialogLabel._SESSION_DIALOG_DESC, array);
        PTWidgetTool.createLabel((Composite)composite, (String)label);
        this._trvViewer = PTWidgetTool.createTreeViewer((Composite)composite, (boolean)true);
        this._trvViewer.setUseHashlookup(true);
        this._trvViewer.setContentProvider((IContentProvider)new PacPublishingContentProvider(this.getTopLevelMode()));
        this._trvViewer.setLabelProvider((IBaseLabelProvider)new PacPublishingLabelProvider(this.getDisplayMode()));
        this._trvViewer.setComparator((ViewerComparator)new PTViewerComparator(this.getSortMode()));
        this._trvViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PacEditSessionDialog.this._pbRemove.setEnabled(selection.size() > 0);
            }
        });
        String pbLabel = PacDialogLabel.getString(PacDialogLabel._REMOVE);
        this._pbRemove = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)true);
        this._pbRemove.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this._pbRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PacEditSessionDialog.this.getShell();
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
                IStructuredSelection selection = (IStructuredSelection)PacEditSessionDialog.this._trvViewer.getSelection();
                HashSet<PTElement> removedElements = new HashSet<PTElement>(selection.size());
                for (Object object : selection) {
                    if (object instanceof PTFolder) {
                        removedElements.addAll(((PTFolder)object).getElements());
                        continue;
                    }
                    if (object instanceof PTPackage) {
                        removedElements.addAll(((PTPackage)object).getElements());
                        continue;
                    }
                    if (object instanceof PTProject) {
                        removedElements.addAll(((PTProject)object).getElements());
                        continue;
                    }
                    if (!(object instanceof PTElement)) continue;
                    removedElements.add((PTElement)object);
                }
                PacEditSessionDialog.this.getRemovedElements().addAll(removedElements);
                for (PTElement element : removedElements) {
                    PacEditSessionDialog.this._editedLocation.removeElement(element);
                }
                PacEditSessionDialog.this.refresh();
                shell.setCursor(null);
            }
        });
        this.createContextMenu(this._trvViewer.getControl());
        this.setInput();
        return composite;
    }

    private String getContextId() {
        return "com.ibm.pdp.doc.cshelp.?";
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacEditSessionDialog.this._topLevelActionGroup.fillMenu(menu);
                PacEditSessionDialog.this._topLevelActionGroup.check(PacEditSessionDialog.this.getTopLevelMode());
                menu.add((IContributionItem)new Separator(PTSortActionGroup._SEPARATOR));
                PacEditSessionDialog.this._sortActionGroup.fillMenu(menu);
                PacEditSessionDialog.this._sortActionGroup.check(PacEditSessionDialog.this.getSortMode());
                PacEditSessionDialog.this._displayActionGroup.fillMenu(menu);
                PacEditSessionDialog.this._displayActionGroup.check(PacEditSessionDialog.this.getDisplayMode());
                menu.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu contextMenu = menuMgr.createContextMenu(control);
        control.setMenu(contextMenu);
    }

    private void setInput() {
        this._trvViewer.setInput((Object)this._editedLocation);
        this._trvViewer.expandToLevel(2);
        this._pbRemove.setEnabled(false);
    }

    public Set<PTElement> getRemovedElements() {
        if (this._removedElements == null) {
            this._removedElements = new HashSet<PTElement>();
        }
        return this._removedElements;
    }

    public void refresh() {
        if (this._trvViewer != null) {
            this._trvViewer.refresh();
        }
    }

    public int getTopLevelMode() {
        return this._topLevelMode;
    }

    public void setTopLevelMode(int topLevelMode) {
        this._topLevelMode = topLevelMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_TOP_LEVEL", this.getTopLevelMode());
        IContentProvider contentProvider = this._trvViewer.getContentProvider();
        if (contentProvider instanceof IPTContentProvider) {
            ((IPTContentProvider)contentProvider).setTopLevelMode(this.getTopLevelMode());
        }
    }

    public int getSortMode() {
        return this._sortMode;
    }

    public void setSortMode(int sortMode) {
        this._sortMode = sortMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_SORT", this.getSortMode());
        PTViewerComparator sorter = (PTViewerComparator)this._trvViewer.getComparator();
        ((PTComparator)sorter.getComparator()).setSortMode(this.getSortMode());
    }

    public int getDisplayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        this._prefs.putInt("_PREF_PUBLISH_SESSION_PAGE_DISPLAY", this.getDisplayMode());
        IBaseLabelProvider labelProvider = this._trvViewer.getLabelProvider();
        if (labelProvider instanceof IPTLabelProvider) {
            ((IPTLabelProvider)labelProvider).setDisplayMode(this.getDisplayMode());
        }
    }
}

