/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.actiongroup;

import com.ibm.pdp.explorer.associate.IPTContextualDocumentWrapper;
import com.ibm.pdp.explorer.view.PTExplorerView;
import com.ibm.pdp.pac.publishing.action.PacAddToSessionAction;
import com.ibm.pdp.pac.publishing.action.PacPublishAction;
import com.ibm.pdp.pac.publishing.action.PacPublishSessionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.ActionGroup;

public class PacPublishActionGroup
extends ActionGroup {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacPublishActionGroup.class.getName()) + "_ID";
    public static final String _SEPARATOR = String.valueOf(PacPublishActionGroup.class.getName()) + "_SEPARATOR";
    private String _viewId = null;
    private Viewer _viewer;
    private PacPublishAction _publishSelectionAction;
    private PacAddToSessionAction _addAction;
    private PacPublishSessionAction _publishSessionAction;

    public PacPublishActionGroup(String viewId, Viewer viewer) {
        this._viewId = viewId;
        this._viewer = viewer;
    }

    public void fillContextMenu(IMenuManager menuMgr) {
        IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
        if (menuMgr.find("rpp.additions") != null) {
            menuMgr.insertAfter("rpp.additions", (IContributionItem)new Separator(_SEPARATOR));
            if (selection.size() > 0) {
                boolean isResolved = this.isResolved(selection);
                this._publishSelectionAction = new PacPublishAction(this._viewer);
                this._publishSelectionAction.setEnabled(isResolved);
                menuMgr.insertBefore(_SEPARATOR, (IAction)this._publishSelectionAction);
                this._addAction = new PacAddToSessionAction(this._viewer);
                this._addAction.setEnabled(isResolved);
                menuMgr.insertBefore(_SEPARATOR, (IAction)this._addAction);
            }
            if (this._viewId.equals(PTExplorerView._VIEW_ID)) {
                this._publishSessionAction = new PacPublishSessionAction(this._viewer);
                menuMgr.insertBefore(_SEPARATOR, (IAction)this._publishSessionAction);
            }
        }
    }

    private boolean isResolved(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            if (selectedObject instanceof IPTContextualDocumentWrapper && !((IPTContextualDocumentWrapper)selectedObject).isResolved()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

