/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.publishing.action;

import com.ibm.pdp.explorer.associate.IPTDocumentWrapper;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTFolder;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTPackage;
import com.ibm.pdp.explorer.model.PTProject;
import com.ibm.pdp.pac.publishing.PacPublishingLabel;
import com.ibm.pdp.pac.publishing.plugin.PacPublishingPlugin;
import com.ibm.pdp.pac.publishing.tool.PacDocumentComparator;
import com.ibm.pdp.pac.publishing.wizard.PacPublishSelectionWizard;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class PacPublishAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacPublishAction.class.getName()) + "_ID";
    private Viewer _viewer;

    public PacPublishAction(Viewer viewer) {
        this._viewer = viewer;
        this.setText(PacPublishingLabel.getString(PacPublishingLabel._PUBLISH));
        this.setToolTipText(this.getText());
        this.setImageDescriptor(PacPublishingPlugin.getDefault().getImageDescriptor("session"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Shell shell = this._viewer.getControl().getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        TreeSet<Object> metaDocuments = new TreeSet<Object>(new PacDocumentComparator());
        for (Object object : selection) {
            if (object instanceof PTLocation) {
                PTLocation location = (PTLocation)object;
                if (!location.isOpened()) continue;
                for (PTElement element : location.getElements().values()) {
                    metaDocuments.add(element.getDocument());
                }
                continue;
            }
            if (object instanceof PTFolder) {
                for (PTElement element : ((PTFolder)object).getElements()) {
                    metaDocuments.add(element.getDocument());
                }
                continue;
            }
            if (object instanceof PTPackage) {
                for (PTElement element : ((PTPackage)object).getElements()) {
                    metaDocuments.add(element.getDocument());
                }
                continue;
            }
            if (object instanceof PTProject) {
                for (PTElement element : ((PTProject)object).getElements()) {
                    metaDocuments.add(element.getDocument());
                }
                continue;
            }
            if (!(object instanceof IPTDocumentWrapper)) continue;
            IPTDocumentWrapper wrapper = (IPTDocumentWrapper)object;
            metaDocuments.add(wrapper.getDocument());
        }
        PacPublishSelectionWizard wizard = new PacPublishSelectionWizard(metaDocuments);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            shell.setCursor(null);
        }
        shell.setCursor(null);
    }
}

