/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description.wizard;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacErrorLabel;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacInputAid;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.pac.description.DataElementExportDLines;
import com.ibm.pdp.pac.description.DataUnitExportLSLines;
import com.ibm.pdp.pac.description.DatabaseBlockExportDLines;
import com.ibm.pdp.pac.description.PacDescriptionLabel;
import com.ibm.pdp.pac.description.ProgramExportCDLines;
import com.ibm.pdp.pac.description.RadicalEntityExportCPLines;
import com.ibm.pdp.pac.description.RadicalEntityExportGCLines;
import com.ibm.pdp.pac.description.ReportExportCELines;
import com.ibm.pdp.pac.description.ReportExportDLines;
import com.ibm.pdp.pac.description.ReportExportLLines;
import com.ibm.pdp.pac.description.ScreenExportCELines;
import com.ibm.pdp.pac.description.ScreenExportCSLines;
import com.ibm.pdp.pac.description.SegmentExportCELines;
import com.ibm.pdp.pac.description.SegmentExportLALLines;
import com.ibm.pdp.pac.description.ServerExportCSLines;
import com.ibm.pdp.pac.description.wizard.PacDescriptionWizardLabel;
import com.ibm.pdp.pac.description.wizard.page.PacExportDescriptionWizardPage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class PacExportDescriptionWizard
extends Wizard
implements IWorkbenchWizard {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _CSV_EXTENSION = "csv";
    private RadicalEntity _radicalObject;
    private PacExportDescriptionWizardPage _exportDescriptionPage;
    List<String> _lsfile = new ArrayList<String>();

    public PacExportDescriptionWizard(RadicalEntity radicalObject) {
        this._radicalObject = radicalObject;
        this.setWindowTitle(PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._EXPORT_WIZARD_DESCRIPTION_TITLE));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this._exportDescriptionPage = new PacExportDescriptionWizardPage(this, "exportDescriptionPage_ID");
        this.addPage((IWizardPage)this._exportDescriptionPage);
    }

    public boolean performFinish() {
        final Object[] checkedElements = this._exportDescriptionPage._cbtvDescriptions.getCheckedElements();
        final String destination = this._exportDescriptionPage._txtDestination.getText();
        File directoryDest = new File(destination);
        boolean isCreationDone = false;
        isCreationDone = directoryDest.exists() ? directoryDest.isDirectory() : directoryDest.mkdir();
        if (isCreationDone) {
            Job exportJob = new Job(PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._EXPORT_DESCRIPTION_JOB)){

                protected IStatus run(IProgressMonitor monitor) {
                    final ArrayList<Object> statusList = new ArrayList<Object>();
                    if (checkedElements != null) {
                        AbstractRadicalEntityExport lines = null;
                        Object[] objectArray = checkedElements;
                        int n = checkedElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName;
                            String entityType;
                            String fileName2;
                            Object checkedElement = objectArray[n2];
                            EReference eReference = (EReference)checkedElement;
                            if (PacExportDescriptionWizard.this._radicalObject instanceof PacProgram) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacProgram_CDLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "PGM", "CD");
                                    lines = new ProgramExportCDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacProgram_CPLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "PGM", "CP");
                                    lines = new RadicalEntityExportCPLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacStructuredLanguageEntity_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "PGM", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacMacro) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacStructuredLanguageEntity_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "MSP", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof DataAggregate) {
                                if (checkedElement.equals(KernelPackage.eINSTANCE.getDataAggregateDescription_Components())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SEG", "CE");
                                    lines = new SegmentExportCELines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacExportDescriptionWizardPage.PacDataAggregate_LAL)) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SEG", "LAL");
                                    lines = new SegmentExportLALLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacDataAggregate_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SEG", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof DataUnit) {
                                if (checkedElement.equals(KernelPackage.eINSTANCE.getDataUnit_Components())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DST", "LS");
                                    lines = new DataUnitExportLSLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacDataUnit_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DST", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacScreen) {
                                entityType = PacDescriptionLabel._EXPORT_SCREEN_PREFIX;
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacScreen_CELines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "CE");
                                    lines = new ScreenExportCELines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialog_CPLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "CP");
                                    lines = new RadicalEntityExportCPLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialog_CSLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "CS");
                                    lines = new ScreenExportCSLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialog_GCLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacServer) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogServer_CSLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SRV", "CS");
                                    lines = new ServerExportCSLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogServer_CPLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SRV", "CP");
                                    lines = new RadicalEntityExportCPLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogServer_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "SRV", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacDialogServer) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogServer_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DSV", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof DataElement) {
                                entityType = PacDescriptionLabel._EXPORT_DATAELEMENT_PREFIX;
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacDataElement_DLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "D");
                                    lines = new DataElementExportDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacDataElement_GCLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacReport) {
                                entityType = PacDescriptionLabel._EXPORT_REPORT_PREFIX;
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacReport_DLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "D");
                                    lines = new ReportExportDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacReport_CELines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "CE");
                                    lines = new ReportExportCELines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacReport_LLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "L");
                                    lines = new ReportExportLLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacReport_GCLines())) {
                                    fileName = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), entityType, "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacText) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacText_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "TXT", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacVolume) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacVolume_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "VOL", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacLibrary) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacLibrary_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "LIB", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacInputAid) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacInputAid_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "IA", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacFolder) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogFolder_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "FD", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacFolderView) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogFolderView_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "FDV", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacDialogFolderView) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogFolderView_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DFV", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacDialogFolder) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogFolder_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DFO", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacDialog) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialog_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DIA", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacBlockBase) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacBlockBase_DRLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DBD", "DR");
                                    lines = new DatabaseBlockExportDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacBlockBase_DCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DBD", "DC");
                                    lines = new DatabaseBlockExportDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacBlockBase_DHLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DBD", "DH");
                                    lines = new DatabaseBlockExportDLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                } else if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacBlockBase_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DBD", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacCommunicationMonitor) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogCommunicationMonitor_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "CMO", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacDialogCommunicationMonitor) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacAbstractDialogCommunicationMonitor_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "DCM", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacCopybook) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacCopybook_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "CPB", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof PacErrorLabel) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacErrorLabel_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "ERL", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof MetaEntity) {
                                if (checkedElement.equals(PacbasePackage.eINSTANCE.getPacMetaEntity_GCLines())) {
                                    fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "MEE", "GC");
                                    lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                    PacExportDescriptionWizard.this._lsfile.add(fileName2);
                                }
                            } else if (PacExportDescriptionWizard.this._radicalObject instanceof UserEntity && checkedElement.equals(PacbasePackage.eINSTANCE.getPacUserEntity_GCLines())) {
                                fileName2 = PacExportDescriptionWizard.this.getFileName(destination, PacExportDescriptionWizard.this.getRadicalObject(), "UE", "GC");
                                lines = new RadicalEntityExportGCLines(PacExportDescriptionWizard.this.getRadicalObject(), fileName2);
                                PacExportDescriptionWizard.this._lsfile.add(fileName2);
                            }
                            try {
                                byte[] bytes = lines.retrieveBytes((IProgressMonitor)new NullProgressMonitor());
                                IStatus status = lines.writeFile(bytes);
                                if (status != null) {
                                    statusList.add(status);
                                }
                            }
                            catch (Exception e) {
                                String msg = "";
                                msg = e.getCause() != null ? String.valueOf(eReference.getName()) + ": " + e.getCause().getMessage() : String.valueOf(eReference.getName()) + ": " + e.getMessage();
                                statusList.add(new Status(4, "org.eclipse.ui", 0, msg, null));
                            }
                            ++n2;
                        }
                    }
                    if (!monitor.isCanceled()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (statusList.size() > 0) {
                                    String dialogLabel = PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._EXPORT_DESCRIPTION_ERROR_LABEL);
                                    MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 4, dialogLabel, null);
                                    int i = 0;
                                    while (i < statusList.size()) {
                                        IStatus status = (IStatus)statusList.get(i);
                                        multiStatus.add(status);
                                        ++i;
                                    }
                                    String dialogTitle = PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._EXPORT_DESCRIPTION_ERROR_TITLE);
                                    PTMessageManager.handleErrors((String)dialogTitle, (MultiStatus)multiStatus);
                                } else if (!(this).PacExportDescriptionWizard.this._lsfile.isEmpty()) {
                                    StringBuilder sb = new StringBuilder(PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._EXPORT_DESCRIPTION_LSFILE_TITLE));
                                    for (String file : (this).PacExportDescriptionWizard.this._lsfile) {
                                        sb.append("\r\n").append(file);
                                    }
                                    PTMessageManager.handleInformation((String)sb.toString());
                                }
                            }
                        });
                    }
                    monitor.done();
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            exportJob.setPriority(50);
            exportJob.setUser(true);
            exportJob.schedule();
            this._exportDescriptionPage.updatePreferences();
        } else {
            StringBuilder sb = new StringBuilder(PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel.getString(PacDescriptionWizardLabel._DESCRIPTION_DESTINATION_FOLDER_ERROR)));
            for (String file : this._lsfile) {
                sb.append("\r\n").append(file);
            }
            PTMessageManager.handleInformation((String)sb.toString());
        }
        return true;
    }

    public boolean canFinish() {
        return this._exportDescriptionPage.isPageComplete();
    }

    public RadicalEntity getRadicalObject() {
        return this._radicalObject;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private String getFileName(String folderPath, RadicalEntity re, String entityType, String description) {
        String projectName = re.getProject().replace('.', '_');
        String fileName = folderPath;
        String fileSeparator = System.getProperty("file.separator");
        if (!folderPath.endsWith(fileSeparator)) {
            fileName = String.valueOf(fileName) + fileSeparator;
        }
        if (re instanceof UserEntity) {
            UserEntity mdlue = (UserEntity)re;
            fileName = String.valueOf(fileName) + entityType + "_" + re.getName() + "." + mdlue.getMetaEntity().getName() + "_" + description + "_" + projectName + "." + _CSV_EXTENSION;
        } else {
            fileName = String.valueOf(fileName) + entityType + "_" + re.getName() + "_" + description + "_" + projectName + "." + _CSV_EXTENSION;
        }
        return fileName;
    }

    static /* synthetic */ PacExportDescriptionWizardPage access$2(PacExportDescriptionWizard pacExportDescriptionWizard) {
        return pacExportDescriptionWizard._exportDescriptionPage;
    }
}

