/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.InputAidGLine;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractCELine;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment;
import com.ibm.pdp.maf.rpp.pac.segment.CELine;
import com.ibm.pdp.maf.rpp.pac.segment.ClassControlValues;
import com.ibm.pdp.maf.rpp.pac.segment.Component;
import com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.Filler;
import com.ibm.pdp.maf.rpp.pac.segment.GroupComponent;
import com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent;
import com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent;
import com.ibm.pdp.maf.rpp.pac.segment.LVUndefinedDataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalView;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalViewComponent;
import com.ibm.pdp.maf.rpp.pac.segment.MoreControls;
import com.ibm.pdp.maf.rpp.pac.segment.PresenceCheck;
import com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup;
import com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent;
import com.ibm.pdp.maf.rpp.pac.segment.SubSchemaAssignment;
import com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataAggregateTypeValues;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.ArrayList;
import java.util.List;

public class SegmentExportCELines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SegmentExportCELines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof DataAggregate) {
            String type;
            String name;
            String packageName;
            String projectName;
            DataAggregate da = (DataAggregate)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = da.getProject(), packageName = da.getPackage(), name = da.getName(), type = da.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for segment " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for segment " + name);
            }
            boolean isLogicalView = false;
            for (RadicalEntityExtension extension : da.getExtensions()) {
                PacDataAggregate pda;
                if (!(extension instanceof PacDataAggregate) || !(pda = (PacDataAggregate)extension).getDataAggregateType().equals(PacDataAggregateTypeValues._V_LITERAL)) continue;
                isLogicalView = true;
            }
            AbstractSegment segment = (AbstractSegment)radicalElement;
            LogicalView lv = null;
            if (isLogicalView) {
                lv = (LogicalView)radicalElement;
            }
            this.printHeader(csvWriter, isLogicalView);
            int LALSize = segment.getLevelAddressLength().size();
            ArrayList<SegmentCELine> flatList = new ArrayList<SegmentCELine>();
            ArrayList<LVCELine> lvflatList = new ArrayList<LVCELine>();
            int CELinesSize = 0;
            if (isLogicalView) {
                this.buildLVCEList(lv.getCELines(), lvflatList, false);
                CELinesSize = lvflatList.size();
            } else {
                this.buildSegmentCEList(segment.getCELines(), flatList, false);
                CELinesSize = flatList.size();
            }
            if (LALSize != CELinesSize) {
                System.err.println("LAL and CELines don't have the same size for segment " + name + ", LAL'size = " + LALSize + ", CELines'size = " + CELinesSize);
                throw new RuntimeException("LAL and CELines don't have the same size for segment " + name + ", LAL'size = " + LALSize + ", CELines'size = " + CELinesSize);
            }
            int i = 0;
            while (i < segment.getLevelAddressLength().size()) {
                LevelAddressLength levelAddressLength = (LevelAddressLength)segment.getLevelAddressLength().get(i);
                SegmentCELine segmentCELine = null;
                LVCELine lvCELine = null;
                if (isLogicalView) {
                    lvCELine = (LVCELine)lvflatList.get(i);
                    if (lvCELine._redefineNumber > -1) {
                        csvWriter.addCell("R" + lvCELine._redefineNumber);
                    } else {
                        csvWriter.addCell("");
                    }
                } else {
                    segmentCELine = (SegmentCELine)flatList.get(i);
                    if (segmentCELine._redefineNumber > -1) {
                        csvWriter.addCell("R" + segmentCELine._redefineNumber);
                    } else {
                        csvWriter.addCell("");
                    }
                }
                this.printCommonDetail(csvWriter, levelAddressLength);
                List<Object> gcLines = new ArrayList();
                List<Object> geLines = new ArrayList();
                List<Object> ggLines = new ArrayList();
                if (isLogicalView) {
                    gcLines = this.getGCLines(lvCELine._ceLine);
                    geLines = this.getGELines(lvCELine._ceLine);
                    ggLines = this.getGGLines(lvCELine._ceLine);
                } else {
                    gcLines = this.getGCLines(segmentCELine._ceLine);
                    geLines = this.getGELines(segmentCELine._ceLine);
                    ggLines = this.getGGLines(segmentCELine._ceLine);
                }
                int max = 1;
                max = isLogicalView ? Math.max(lvCELine._nb_control, max) : Math.max(segmentCELine._nb_control, max);
                max = Math.max(gcLines.size(), max);
                max = Math.max(geLines.size(), max);
                max = Math.max(ggLines.size(), max);
                int j = 0;
                while (j < max) {
                    Object m;
                    if (j == 0) {
                        if (isLogicalView) {
                            csvWriter.addCell(this.valueOf(lvCELine._type));
                            if (levelAddressLength.getOccursDisplay() > 0) {
                                csvWriter.addCell(Integer.toString(levelAddressLength.getOccursDisplay()));
                            } else {
                                csvWriter.addCell("");
                            }
                            csvWriter.addCell(this.valueOf(lvCELine._presence));
                            if (j < lvCELine._nb_control) {
                                m = lvCELine._lvmore.get(0);
                                csvWriter.addCell(this.valueOf(((LVMore)m)._transferDirection));
                                csvWriter.addCell(this.valueOf(((LVMore)m)._operator));
                                csvWriter.addCell(lvCELine._ssa);
                                csvWriter.addCell(((LVMore)m)._updateTarget);
                            } else {
                                this.printBlankColumns(csvWriter, 4);
                            }
                        } else {
                            if (levelAddressLength.getOccursDisplay() > 0) {
                                csvWriter.addCell(Integer.toString(levelAddressLength.getOccursDisplay()));
                            } else {
                                csvWriter.addCell("");
                            }
                            csvWriter.addCell(segmentCELine._sortKey);
                            csvWriter.addCell(segmentCELine._presenceCheck);
                            if (j < segmentCELine._nb_control || segmentCELine._classControl != null && !segmentCELine._classControl.equals("")) {
                                if (segmentCELine._classControl == null || segmentCELine._classControl.equals("")) {
                                    segmentCELine._classControl = " ";
                                }
                                if (segmentCELine._nb_control > 0) {
                                    m = segmentCELine._more.get(0);
                                    csvWriter.addCell(String.valueOf(segmentCELine._classControl) + ((More)m)._operator + ((More)m)._negation + ((More)m)._type);
                                    csvWriter.addCell(((More)m)._controlValue);
                                    csvWriter.addCell(((More)m)._updateTarget);
                                } else {
                                    csvWriter.addCell(segmentCELine._classControl);
                                    this.printBlankColumns(csvWriter, 2);
                                }
                            } else {
                                this.printBlankColumns(csvWriter, 3);
                            }
                        }
                    } else if (isLogicalView) {
                        csvWriter.endOfRow();
                        this.printBlankColumns(csvWriter, 9);
                        if (j < lvCELine._nb_control) {
                            m = lvCELine._lvmore.get(j);
                            csvWriter.addCell(this.valueOf(((LVMore)m)._transferDirection));
                            csvWriter.addCell(this.valueOf(((LVMore)m)._operator));
                            csvWriter.addCell("");
                            csvWriter.addCell(((LVMore)m)._updateTarget);
                        } else {
                            this.printBlankColumns(csvWriter, 4);
                        }
                    } else {
                        csvWriter.endOfRow();
                        this.printBlankColumns(csvWriter, 9);
                        if (j < segmentCELine._nb_control) {
                            m = segmentCELine._more.get(j);
                            csvWriter.addCell(String.valueOf(segmentCELine._classControl) + ((More)m)._operator + ((More)m)._negation + ((More)m)._type);
                            csvWriter.addCell(((More)m)._controlValue);
                            csvWriter.addCell(((More)m)._updateTarget);
                        } else {
                            this.printBlankColumns(csvWriter, 3);
                        }
                    }
                    if (j < gcLines.size()) {
                        GLine gcLine = (GLine)gcLines.get(j);
                        this.printGCLine(csvWriter, gcLine);
                    } else {
                        this.printBlankColumns(csvWriter, 3);
                    }
                    if (j < geLines.size()) {
                        GLine geLine = (GLine)geLines.get(j);
                        this.printGELine(csvWriter, geLine);
                    } else {
                        this.printBlankColumns(csvWriter, 3);
                    }
                    if (j < ggLines.size()) {
                        GLine ggLine = (GLine)ggLines.get(j);
                        this.printGGLine(csvWriter, ggLine);
                    } else {
                        this.printBlankColumns(csvWriter, 3);
                        csvWriter.addLastCell("");
                    }
                    ++j;
                }
                csvWriter.endOfRow();
                ++i;
            }
        }
    }

    private void printBlankColumns(CsvWriter csvWriter, int n) {
        int i = 0;
        while (i < n) {
            csvWriter.addCell("");
            ++i;
        }
    }

    private void printHeader(CsvWriter csvWriter, boolean isLogicalView) {
        if (isLogicalView) {
            this.printBlankColumns(csvWriter, 13);
        } else {
            this.printBlankColumns(csvWriter, 12);
        }
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GCLINE_EDIT_SECTION_HEADER));
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GELINE_EDIT_SECTION_HEADER));
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GGLINE_EDIT_SECTION_HEADER));
        csvWriter.addCell("");
        csvWriter.addLastCell("");
        csvWriter.endOfRow();
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REDEFINES));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._CELINE_COLUMN_LEVEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_FORMAT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_USAGE));
        if (isLogicalView) {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_DATATYPE));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_OCCURS));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_PRESENCE));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_DIRECTION));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_OPER));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_SCHEMA));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LV_CELINE_COLUMN_TRANSFER));
        } else {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_OCCURS));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_SORTKEY));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_CMS456));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_CONT));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_VALUE_SFC));
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_CELINE_COLUMN_UPDATE_TARGET));
        }
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_LINK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GLINE_LINK));
        csvWriter.endOfRow();
    }

    private void printCommonDetail(CsvWriter csvWriter, LevelAddressLength levelAddressLength) {
        csvWriter.addCell(Integer.toString(levelAddressLength.getLevel()));
        csvWriter.addCell(this.textValue(levelAddressLength.getName()));
        csvWriter.addCell(this.textValue(levelAddressLength.getLabel()));
        csvWriter.addCell(levelAddressLength.getInternalFormat());
        csvWriter.addCell(levelAddressLength.getUsage());
    }

    private void buildLVCEList(List<CELine> ceLines, List<LVCELine> flatList, boolean isRedefines) {
        int redefinesNumber = 0;
        for (CELine ceLine : ceLines) {
            LVCELine s = new LVCELine();
            s._redefineNumber = isRedefines ? redefinesNumber : -1;
            s._ceLine = ceLine;
            if (ceLine instanceof LVDataElementComponent) {
                s._type = ((LVDataElementComponent)ceLine).getDataType().toString();
                s._presence = ((LVDataElementComponent)ceLine).getPresence().toString();
                this.computeLVMoreControls((LogicalViewComponent)((LVDataElementComponent)ceLine), s);
                s._ssa = this.computeSubSchema((LogicalViewComponent)((LVDataElementComponent)ceLine), s);
                flatList.add(s);
            } else if (ceLine instanceof LVGroupComponent) {
                s._type = ((LVGroupComponent)ceLine).getDataType().toString();
                s._presence = ((LVGroupComponent)ceLine).getPresence().toString();
                this.computeLVMoreControls((LogicalViewComponent)((LVGroupComponent)ceLine), s);
                s._ssa = this.computeSubSchema((LogicalViewComponent)((LVGroupComponent)ceLine), s);
                flatList.add(s);
                this.buildLVCEList(((LVGroupComponent)ceLine).getCompositionGroup(), flatList, false);
            } else if (ceLine instanceof LVSegmentComponent) {
                s._type = ((LVSegmentComponent)ceLine).getDataType().toString();
                s._presence = ((LVSegmentComponent)ceLine).getPresence().toString();
                this.computeLVMoreControls((LogicalViewComponent)((LVSegmentComponent)ceLine), s);
                s._ssa = this.computeSubSchema((LogicalViewComponent)((LVSegmentComponent)ceLine), s);
                flatList.add(s);
                AbstractSegment segment = ((LVSegmentComponent)ceLine).getSegment();
                if (segment != null) {
                    this.buildLVCEList(segment.getCELines(), flatList, false);
                }
            } else if (ceLine instanceof LVUndefinedDataElementComponent) {
                s._type = ((LVUndefinedDataElementComponent)ceLine).getDataType().toString();
                s._presence = ((LVUndefinedDataElementComponent)ceLine).getPresence().toString();
                this.computeLVMoreControls((LogicalViewComponent)((LVUndefinedDataElementComponent)ceLine), s);
                s._ssa = this.computeSubSchema((LogicalViewComponent)((LVUndefinedDataElementComponent)ceLine), s);
                flatList.add(s);
            } else if (ceLine instanceof Filler) {
                s._type = "";
                s._presence = "";
                s._nb_control = 0;
                s._ssa = "";
                flatList.add(s);
            } else if (ceLine instanceof RedefinesGroup) {
                this.buildLVCEList(((RedefinesGroup)ceLine).getSetOfRedefines(), flatList, true);
            }
            ++redefinesNumber;
        }
    }

    private void buildSegmentCEList(List<CELine> ceLines, List<SegmentCELine> flatList, boolean isRedefines) {
        int redefinesNumber = 0;
        for (CELine ceLine : ceLines) {
            SegmentCELine s = new SegmentCELine();
            s._redefineNumber = isRedefines ? redefinesNumber : -1;
            s._ceLine = ceLine;
            if (ceLine instanceof DataElementComponent) {
                this.computeSortKey((Component)((DataElementComponent)ceLine), s);
                this.computeClassControl((Component)((DataElementComponent)ceLine), s);
                s._presenceCheck = this.computePresenceCheck((Component)((DataElementComponent)ceLine));
                this.computeMoreControls((Component)((DataElementComponent)ceLine), s);
                flatList.add(s);
            } else if (ceLine instanceof GroupComponent) {
                s._sortKey = ((GroupComponent)ceLine).getSortKey();
                s._presenceCheck = "";
                s._nb_control = 0;
                flatList.add(s);
                this.buildSegmentCEList(((GroupComponent)ceLine).getCompositionGroup(), flatList, false);
            } else if (ceLine instanceof SegmentComponent) {
                s._sortKey = ((SegmentComponent)ceLine).getSortKey();
                s._presenceCheck = "";
                s._nb_control = 0;
                flatList.add(s);
                AbstractSegment segment = ((SegmentComponent)ceLine).getSegment();
                if (segment != null) {
                    this.buildSegmentCEList(segment.getCELines(), flatList, false);
                }
            } else if (ceLine instanceof UndefinedDataElementComponent) {
                this.computeSortKey((Component)((UndefinedDataElementComponent)ceLine), s);
                this.computeClassControl((Component)((UndefinedDataElementComponent)ceLine), s);
                s._presenceCheck = this.computePresenceCheck((Component)((UndefinedDataElementComponent)ceLine));
                this.computeMoreControls((Component)((UndefinedDataElementComponent)ceLine), s);
                flatList.add(s);
            } else if (ceLine instanceof Filler) {
                s._sortKey = ((Filler)ceLine).getSortKey();
                s._presenceCheck = "";
                s._nb_control = 0;
                flatList.add(s);
            } else if (ceLine instanceof RedefinesGroup) {
                this.buildSegmentCEList(((RedefinesGroup)ceLine).getSetOfRedefines(), flatList, true);
            }
            ++redefinesNumber;
        }
    }

    private String computePresenceCheck(Component ceLine) {
        PresenceCheck pc = ceLine.getPresenceCheck();
        if (pc == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        if (this.getLiteralValue(pc.getInCreation().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInCreation().toString()));
        }
        if (this.getLiteralValue(pc.getInModification().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInModification().toString()));
        }
        if (this.getLiteralValue(pc.getInDeletion().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInDeletion().toString()));
        }
        if (this.getLiteralValue(pc.getInType4().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInType4().toString()));
        }
        if (this.getLiteralValue(pc.getInType5().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInType5().toString()));
        }
        if (this.getLiteralValue(pc.getInType6().toString()).equals("F")) {
            sb.append(" ");
        } else {
            sb.append(this.getLiteralValue(pc.getInType6().toString()));
        }
        return sb.toString();
    }

    private String computeSubSchema(LogicalViewComponent ceLine, LVCELine s) {
        if (ceLine == null) {
            return "";
        }
        SubSchemaAssignment ssa = ceLine.getSubSchemaAssignment();
        StringBuilder sb = new StringBuilder("");
        if (ssa.getSubSchema1()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema2()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema3()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema4()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema5()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema6()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema7()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema8()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema9()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        if (ssa.getSubSchema10()) {
            sb.append("O");
        } else {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void computeLVMoreControls(LogicalViewComponent ceLine, LVCELine s) {
        s._nb_control = 0;
        List moreControls = ceLine.getMoreControls();
        s._lvmore = new ArrayList<LVMore>();
        for (MoreControls mc : moreControls) {
            ++s._nb_control;
            LVMore m = new LVMore();
            m._operator = mc.getOperator() == null || this.getLiteralValue(mc.getOperator()).toString().equals("") ? " " : mc.getOperator();
            m._transferDirection = mc.getTransferDirection() == null || mc.getTransferDirection().toString().equals("") ? " " : mc.getTransferDirection().toString();
            m._updateTarget = this.textValue(mc.getUpdateTarget());
            s._lvmore.add(m);
        }
    }

    private void computeMoreControls(Component ceLine, SegmentCELine s) {
        s._nb_control = 0;
        List moreControls = ceLine.getMoreControls();
        s._more = new ArrayList<More>();
        for (MoreControls mc : moreControls) {
            ++s._nb_control;
            More m = new More();
            String operator = mc.getOperator() == null || this.getLiteralValue(mc.getOperator()).toString().equals("") ? " " : mc.getOperator();
            m._operator = operator;
            String negation = mc.getNegation() == null || this.getLiteralValue(mc.getNegation()).toString().equals("") ? " " : mc.getNegation();
            m._negation = negation;
            String type = mc.getControlType() == null || this.getLiteralValue(mc.getControlType()).toString().equals("") ? " " : mc.getControlType();
            m._type = type;
            m._controlValue = this.textValue(mc.getControlValue());
            m._updateTarget = this.textValue(mc.getUpdateTarget());
            s._more.add(m);
        }
    }

    private void computeSortKey(Component ceLine, SegmentCELine s) {
        s._sortKey = ceLine.getSortKey();
    }

    private void computeClassControl(Component ceLine, SegmentCELine s) {
        s._classControl = ceLine.getClassControl() == null || ceLine.getClassControl().equals((Object)ClassControlValues.NONE) ? " " : this.valueOf(ceLine.getClassControl().toString());
    }

    private List<GLine> getGCLines(CELine ceLine) {
        ArrayList<GLine> gcLines = new ArrayList<GLine>();
        if (ceLine instanceof AbstractCELine) {
            for (GLine gLine : ((AbstractCELine)ceLine).getGCLines()) {
                gcLines.add(gLine);
            }
        }
        return gcLines;
    }

    private List<GLine> getGELines(CELine ceLine) {
        ArrayList<GLine> geLines = new ArrayList<GLine>();
        if (ceLine instanceof AbstractCELine) {
            for (GLine gLine : ((AbstractCELine)ceLine).getGELines()) {
                geLines.add(gLine);
            }
        }
        return geLines;
    }

    private List<GLine> getGGLines(CELine ceLine) {
        ArrayList<GLine> ggLines = new ArrayList<GLine>();
        if (ceLine instanceof AbstractCELine) {
            for (GLine gLine : ((AbstractCELine)ceLine).getGGLines()) {
                ggLines.add(gLine);
            }
        }
        return ggLines;
    }

    private void printGCLine(CsvWriter csvWriter, GLine gLine) {
        csvWriter.addCell(gLine.getLineType());
        if (gLine.getLineType().contains("I")) {
            CalledIAGLine ia = new CalledIAGLine();
            this.computeCalledIAGLine(gLine, ia);
            if (ia != null && ia._isIA) {
                csvWriter.addCell("" + ia._descriptions);
                csvWriter.addCell(ia._name);
            } else {
                csvWriter.addCell(this.textValue(gLine.getDescription()));
                this.printBlankColumns(csvWriter, 1);
            }
        } else {
            csvWriter.addCell(this.textValue(gLine.getDescription()));
            this.printBlankColumns(csvWriter, 1);
        }
    }

    private void printGGLine(CsvWriter csvWriter, GLine gLine) {
        this.printGCLine(csvWriter, gLine);
        this.printLinkedEntityGLine(csvWriter, gLine);
    }

    private void printGELine(CsvWriter csvWriter, GLine geLine) {
        csvWriter.addCell(geLine.getLineType());
        this.printLinkedEntityGLine(csvWriter, geLine);
        csvWriter.addCell(this.textValue(geLine.getDescription()));
    }

    private void printLinkedEntityGLine(CsvWriter csvWriter, GLine gLine) {
        if (gLine.getLinkedEntity() == null) {
            csvWriter.addLastCell("");
        } else {
            csvWriter.addLastCell(gLine.getLinkedEntity().getName());
        }
    }

    private String textValue(String text) {
        if (text == null) {
            return "";
        }
        String doubleQuote = "\"";
        if ((text.startsWith("-") || text.startsWith("=")) && !text.contains(doubleQuote)) {
            return "=(" + doubleQuote + text + doubleQuote + ")";
        }
        return text;
    }

    private String valueOf(String s) {
        if (s == null || s.equals("NONE")) {
            return "";
        }
        if (s.startsWith("_")) {
            return s.substring(1);
        }
        return s;
    }

    private void computeCalledIAGLine(GLine gLine, CalledIAGLine ia) {
        if (gLine instanceof InputAidGLine) {
            ia._isIA = true;
            ia._descriptions = ((InputAidGLine)gLine).getData();
            ia._name = ((InputAidGLine)gLine).getInputAid().getName();
        } else {
            ia._isIA = false;
        }
    }

    private class CalledIAGLine {
        public boolean _isIA;
        public String _name;
        public List<String> _descriptions;

        private CalledIAGLine() {
        }
    }

    private class LVCELine {
        public CELine _ceLine;
        public String _type;
        public String _presence;
        public String _ssa;
        public int _nb_control = 0;
        public int _redefineNumber;
        public List<LVMore> _lvmore;

        private LVCELine() {
        }
    }

    private class LVMore {
        public String _operator;
        public String _updateTarget;
        public String _transferDirection;

        private LVMore() {
        }
    }

    private class More {
        public String _operator;
        public String _negation;
        public String _type;
        public String _updateTarget;
        public String _controlValue;

        private More() {
        }
    }

    private class SegmentCELine {
        public CELine _ceLine;
        public String _sortKey;
        public String _presenceCheck;
        public int _nb_control = 0;
        public int _redefineNumber;
        public String _classControl;
        public List<More> _more;

        private SegmentCELine() {
        }
    }
}

