/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCELine;
import com.ibm.pdp.mdl.pacbase.PacCELineCategory;
import com.ibm.pdp.mdl.pacbase.PacCELineField;
import com.ibm.pdp.mdl.pacbase.PacCELineFieldComplement;
import com.ibm.pdp.mdl.pacbase.PacCELineFieldIndicator;
import com.ibm.pdp.mdl.pacbase.PacCELineLabel;
import com.ibm.pdp.mdl.pacbase.PacCELineScreenCall;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacScreenFieldTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenSourceTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenUpdateOptionValues;
import com.ibm.pdp.mdl.pacbase.dialog.PacbaseDialogLabel;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ScreenExportCELines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _lbErmsg = "ERMSG";
    private static final String _lbLierr = "LIERR";
    private static final String _lbPfkey = "PFKEY";
    private static final String _lbPaswd = "*PASWD";

    public ScreenExportCELines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        String screenName = null;
        boolean cobolTypeIs_O = false;
        EList listcelines = null;
        if (this.getRadicalEntity() instanceof PacScreen) {
            screenName = ((PacScreen)this.getRadicalEntity()).getName();
            listcelines = ((PacScreen)this.getRadicalEntity()).getCELines();
            String variant = ((PacScreen)this.getRadicalEntity()).getCobolType().toString();
            variant = ((PacScreen)this.getRadicalEntity()).getCobolType().toString().equals("_None") ? ((PacScreen)this.getRadicalEntity()).getDialog().getCobolType().toString() : ((PacScreen)this.getRadicalEntity()).getCobolType().toString();
            if (variant.equals("_O")) {
                cobolTypeIs_O = true;
            }
            listcelines = ((PacScreen)this.getRadicalEntity()).getCELines();
        }
        this.printHeader(csvWriter, cobolTypeIs_O);
        for (Object celine : listcelines) {
            PacAbstractCELine pacel = (PacAbstractCELine)celine;
            this.printCELine(csvWriter, pacel, screenName, cobolTypeIs_O);
        }
    }

    private void printCELine(CsvWriter csvWriter, PacAbstractCELine pacel, String screenName, boolean cobolTypeIs_O) {
        if (pacel instanceof PacCELineField) {
            this.printScreenFieldLine(csvWriter, (PacCELineField)pacel, screenName, cobolTypeIs_O);
        } else if (pacel instanceof PacCELineCategory) {
            this.printScreenCategoryLine(csvWriter, (PacCELineCategory)pacel);
        } else if (pacel instanceof PacCELineLabel) {
            this.printScreenLabelLine(csvWriter, (PacCELineLabel)pacel);
        } else if (pacel instanceof PacCELineScreenCall) {
            this.printScreenCallLine(csvWriter, (PacCELineScreenCall)pacel);
        }
    }

    private void printScreenCallLine(CsvWriter csvWriter, PacCELineScreenCall pacel) {
        csvWriter.addCell(pacel.getScreen().getName());
        this.printCommonScreen(csvWriter, (PacAbstractCELine)pacel);
        csvWriter.endOfRow();
    }

    private void printScreenFieldLine(CsvWriter csvWriter, PacCELineField pacel, String screenName, boolean cobolTypeIs_O) {
        this.printScreenFieldLineOne(csvWriter, pacel);
        ArrayList<Complement> complements = new ArrayList<Complement>();
        this.buildComplements(pacel, complements, screenName);
        ArrayList<Indicator> indicators = new ArrayList<Indicator>();
        this.buildIndicators(pacel, indicators);
        int max = complements.size();
        if (cobolTypeIs_O) {
            max = Math.max(max, indicators.size());
        }
        int i = 0;
        while (i < max) {
            if (i < complements.size()) {
                Complement c = (Complement)complements.get(i);
                csvWriter.addCell(c._screenName);
                this.printBlankColumns(csvWriter, 8);
                csvWriter.addCell(c._presenceCheck);
                csvWriter.addCell(c._actionCode);
                csvWriter.addCell(c._updateOption);
                csvWriter.addCell(c._updateSegment);
                csvWriter.addCell(c._sourceType);
                csvWriter.addCell(c._displaySegment);
                if (c._generatedLevel == 10) {
                    csvWriter.addCell("");
                } else {
                    csvWriter.addCell(Integer.toString(c._generatedLevel));
                }
            } else {
                this.printBlankColumns(csvWriter, 16);
            }
            if (cobolTypeIs_O) {
                this.printBlankColumns(csvWriter, 9);
            } else {
                this.printBlankColumns(csvWriter, 8);
            }
            csvWriter.addLastCell("");
            if (cobolTypeIs_O) {
                if (i < indicators.size()) {
                    Indicator in = (Indicator)indicators.get(i);
                    csvWriter.addCell(in._number);
                    csvWriter.addCell(in._switch);
                    csvWriter.addCell(in._attribute);
                    csvWriter.addCell(in._field);
                    csvWriter.addLastCell(in._data);
                } else {
                    this.printBlankColumns(csvWriter, 4);
                }
                csvWriter.addCell("");
            }
            csvWriter.endOfRow();
            ++i;
        }
    }

    private void printScreenFieldLineOne(CsvWriter csvWriter, PacCELineField pacel) {
        if (pacel.getDataElement() != null && !pacel.getDataElement().getName().equals("_None")) {
            csvWriter.addCell(pacel.getDataElement().getName());
        } else if (pacel.getFieldType() != null) {
            PacScreenFieldTypeValues ftv = pacel.getFieldType();
            if (ftv.equals(PacScreenFieldTypeValues._ERR_MSG_LITERAL)) {
                csvWriter.addCell(_lbErmsg);
            } else if (ftv.equals(PacScreenFieldTypeValues._LI_ERR_LITERAL)) {
                csvWriter.addCell(_lbLierr);
            } else if (ftv.equals(PacScreenFieldTypeValues._PF_KEY_LITERAL)) {
                csvWriter.addCell(_lbPfkey);
            } else if (ftv.equals(PacScreenFieldTypeValues._PASSWORD_LITERAL)) {
                csvWriter.addCell(_lbPaswd);
            } else {
                csvWriter.addCell(ftv.getName());
            }
        } else {
            csvWriter.addCell("");
        }
        this.printCommonScreen(csvWriter, (PacAbstractCELine)pacel);
        csvWriter.addCell(this.getLiteralValue(pacel.getFieldNature().toString()));
        csvWriter.addCell(this.getLiteralValue(pacel.getLabelPresentation().toString()));
        csvWriter.addCell(pacel.getCursor());
        if (pacel.getHorizontalRepetition() == 0) {
            csvWriter.addCell("");
        } else {
            csvWriter.addCell(Integer.toString(pacel.getHorizontalRepetition()));
        }
        if (pacel.getVerticalRepetition() == 0) {
            csvWriter.addCell("");
        } else {
            csvWriter.addCell(Integer.toString(pacel.getVerticalRepetition()));
        }
        this.printBlankColumns(csvWriter, 7);
        csvWriter.addCell(String.valueOf(this.getLiteralValue(pacel.getLabelIntensityAtt().toString())) + this.getLiteralValue(pacel.getFieldIntensityAtt().toString()));
        csvWriter.addCell(String.valueOf(this.getLiteralValue(pacel.getLabelPresentationAtt().toString())) + this.getLiteralValue(pacel.getFieldPresentationAtt().toString()));
        csvWriter.addCell(String.valueOf(this.getLiteralValue(pacel.getLabelColorAtt().toString())) + this.getLiteralValue(pacel.getFieldColorAtt().toString()));
        this.printBlankColumns(csvWriter, 3);
        csvWriter.addCell(pacel.getInitialValue());
        csvWriter.addCell(pacel.getSimulationValue());
        csvWriter.addLastCell(pacel.getIndAttributePosition());
        csvWriter.endOfRow();
    }

    private void printScreenLabelLine(CsvWriter csvWriter, PacCELineLabel pacel) {
        if (pacel.getScreen() != null) {
            csvWriter.addCell(pacel.getScreen().getName());
        } else if (pacel.getDataElement() != null) {
            csvWriter.addCell(pacel.getDataElement().getName());
        } else {
            csvWriter.addCell("");
        }
        this.printCommonScreen(csvWriter, (PacAbstractCELine)pacel);
        csvWriter.addCell(this.getLiteralValue(pacel.getLabelNature().toString()));
        csvWriter.addCell(this.getLiteralValue(pacel.getLabelPresentation().toString()));
        this.printBlankColumns(csvWriter, 13);
        csvWriter.addCell(Integer.toString(pacel.getRepetition()));
        csvWriter.addCell(pacel.getRepeatedCharacter());
        csvWriter.addLastCell(pacel.getLabel());
        csvWriter.endOfRow();
    }

    private void printScreenCategoryLine(CsvWriter csvWriter, PacCELineCategory pacel) {
        csvWriter.addCell(pacel.getCategoryName());
        this.printCommonScreen(csvWriter, (PacAbstractCELine)pacel);
        csvWriter.addCell(this.getLiteralValue(pacel.getCategoryNature().toString()));
        csvWriter.addCell(this.getLiteralValue(pacel.getLabelPresentation().toString()));
        csvWriter.addCell("");
        if (pacel.getHorizontalRepetition() == 0) {
            csvWriter.addCell("");
        } else {
            csvWriter.addCell(Integer.toString(pacel.getHorizontalRepetition()));
        }
        if (pacel.getVerticalRepetition() == 0) {
            csvWriter.addLastCell("");
        } else {
            csvWriter.addLastCell(Integer.toString(pacel.getVerticalRepetition()));
        }
        csvWriter.endOfRow();
    }

    private void printCommonScreen(CsvWriter csvWriter, PacAbstractCELine pacel) {
        csvWriter.addCell(this.getLiteralValue(pacel.getPositionType().toString()));
        if (pacel.getLinePosition() == 0) {
            csvWriter.addCell("");
        } else {
            csvWriter.addCell(Integer.toString(pacel.getLinePosition()));
        }
        if (pacel.getColumnPosition() == 0) {
            csvWriter.addCell("");
        } else {
            csvWriter.addCell(Integer.toString(pacel.getColumnPosition()));
        }
    }

    private void printHeader(CsvWriter csvWriter, boolean CobolTypeIs_O) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_DATA_ELEMENT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_POSITION_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_LINE_POSITION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_COLUMN_POSITION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_NATURE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_LABEL_PRESENTATION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_IS_CURSOR));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_HR));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_VR));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_PRESENCE_CHECK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_ACTION_CODE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_UPDATE_OPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_UPDATE_SEGMENT_CODE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_SOURCE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_DISPLAY_SEGMENT_CODE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_GENERATE_LEVEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_INTENSITY_ATTRIBUTE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_PRESENTATION_ATTRIBUTE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_COLOR_ATTRIBUTE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_REPETITION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_REPEATED_CHARACTER));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_INITIAL_VALUE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_SIMULATION_VALUE));
        if (CobolTypeIs_O) {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_INDICATOR));
        } else {
            csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CELINE_COLUMN_FIELD_INDICATOR));
        }
        if (CobolTypeIs_O) {
            csvWriter.addCell(this.getLabelValue(PacbaseDialogLabel._IND_NUMBER));
            csvWriter.addCell(this.getLabelValue(PacbaseDialogLabel._IND_SWITCH));
            csvWriter.addCell(this.getLabelValue(PacbaseDialogLabel._IND_ATTTYPE));
            csvWriter.addCell(this.getLabelValue(PacbaseDialogLabel._IND_ATTFIELD));
            csvWriter.addLastCell(this.getLabelValue(PacbaseDialogLabel._IND_ATTDATA));
        }
        csvWriter.endOfRow();
    }

    private void printBlankColumns(CsvWriter csvWriter, int n) {
        int i = 0;
        while (i < n) {
            csvWriter.addCell("");
            ++i;
        }
    }

    private void buildIndicators(PacCELineField pacel, List<Indicator> indicators) {
        EList listIndicators = pacel.getIndicators();
        for (PacCELineFieldIndicator ind : listIndicators) {
            Indicator indicator = new Indicator();
            indicator._number = ind.getIndicatorNumber();
            indicator._switch = this.getLiteralValue(ind.getSwitchIndicator().toString());
            indicator._attribute = this.getLiteralValue(ind.getAttributeType().toString());
            indicator._field = this.getLiteralValue(ind.getFieldAttribute().toString());
            indicator._data = this.getLiteralValue(ind.getDataAttribute().toString());
            indicators.add(indicator);
        }
    }

    private void buildComplements(PacCELineField pacel, List<Complement> complements, String screenName) {
        EList listfieldcompls = pacel.getComplements();
        for (PacCELineFieldComplement pcelfc : listfieldcompls) {
            if (!(pcelfc.getPresenceCheck() != null && !pcelfc.getPresenceCheck().toString().equals("_None") || pcelfc.getActionCode() != null && !pcelfc.getActionCode().toString().equals("_None") || pcelfc.getUpdateOption() != null && !pcelfc.getUpdateOption().toString().equals("_None") || pcelfc.getUpdateSegmentCode() != null && !pcelfc.getUpdateSegmentCode().toString().equals("") || pcelfc.getSourceType() != null && !pcelfc.getSourceType().toString().equals("_None") || pcelfc.getDisplaySegmentCode() != null && !pcelfc.getDisplaySegmentCode().toString().equals("")) && pcelfc.getGenerateLevel() == 10) continue;
            Complement c = new Complement();
            c._screenName = pcelfc.getScreen() != null ? (pcelfc.getScreen().equals("/") ? screenName : pcelfc.getScreen().getName()) : "";
            c._presenceCheck = this.getLiteralValue(pcelfc.getPresenceCheck().toString());
            c._actionCode = this.getLiteralValue(pcelfc.getActionCode().toString());
            c._updateOption = pcelfc.getUpdateOption() != null ? (pcelfc.getUpdateOption().equals(PacScreenUpdateOptionValues._MINUS_LITERAL) ? "-" : (pcelfc.getUpdateOption().equals(PacScreenUpdateOptionValues._PLUS_LITERAL) ? "+" : this.getLiteralValue(pcelfc.getUpdateOption().toString()))) : "";
            c._updateSegment = pcelfc.getUpdateSegmentCode().toString();
            c._sourceType = pcelfc.getSourceType() != null ? (pcelfc.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL) ? "*" : this.getLiteralValue(pcelfc.getSourceType().toString())) : "";
            c._displaySegment = pcelfc.getDisplaySegmentCode();
            c._generatedLevel = pcelfc.getGenerateLevel();
            complements.add(c);
        }
    }

    private class Complement {
        public String _screenName;
        public String _presenceCheck;
        public String _actionCode;
        public String _updateOption;
        public String _updateSegment;
        public String _sourceType;
        public String _displaySegment;
        public int _generatedLevel;

        private Complement() {
        }
    }

    private class Indicator {
        public String _number;
        public String _switch;
        public String _attribute;
        public String _field;
        public String _data;

        private Indicator() {
        }
    }
}

