/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.report.LLine;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.Iterator;
import java.util.List;

public class ReportExportLLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReportExportLLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof PacReport) {
            String type;
            String name;
            String packageName;
            String projectName;
            PacReport et = (PacReport)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = et.getProject(), packageName = et.getPackage(), name = et.getName(), type = et.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for report " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for report " + name);
            }
            Report rpt = (Report)radicalElement;
            List listlline = null;
            listlline = rpt.getLLines();
            this.printHeader(csvWriter);
            Iterator iterator = listlline.iterator();
            while (iterator.hasNext()) {
                LLine lline;
                LLine paclet = lline = (LLine)iterator.next();
                this.printLLine(csvWriter, paclet);
            }
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_LLINE_COLUMN_LABEL_ID));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_LLINE_COLUMN_JUMP));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._REPORT_LLINE_COLUMN_LABEL));
        csvWriter.endOfRow();
    }

    private void printLLine(CsvWriter csvWriter, LLine paclet) {
        if (paclet.getLabelID() != 0) {
            csvWriter.addCell(Integer.toString(paclet.getLabelID()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(paclet.getJumpType().toString()));
        csvWriter.addLastCell(this.getLiteralValue(paclet.getLabel().toString()));
        csvWriter.endOfRow();
    }
}

