/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.report.DLine;
import com.ibm.pdp.maf.rpp.pac.report.EditionLine;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.Iterator;
import java.util.List;

public class ReportExportDLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReportExportDLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof PacReport) {
            String type;
            String name;
            String packageName;
            String projectName;
            PacReport et = (PacReport)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = et.getProject(), packageName = et.getPackage(), name = et.getName(), type = et.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for data element " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for data element " + name);
            }
            Report rpt = (Report)radicalElement;
            List listdline = null;
            listdline = rpt.getDLines();
            this.printHeader(csvWriter);
            Iterator iterator = listdline.iterator();
            while (iterator.hasNext()) {
                DLine dline;
                DLine pacdet = dline = (DLine)iterator.next();
                this.printDLine(csvWriter, pacdet);
                List listedline = dline.getEditionLines();
                listedline = pacdet.getEditionLines();
                if (listedline == null) continue;
                Iterator iterator2 = listedline.iterator();
                while (iterator2.hasNext()) {
                    EditionLine lines;
                    EditionLine edline = lines = (EditionLine)iterator2.next();
                    this.printEdLine(csvWriter, edline);
                }
            }
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_CATEGORY_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_TOTALIZATION_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_FOREIGN_TOTAL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_REPETITION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_CALLED_STRUCTURE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_CALLED_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_SKIP));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_SKIP_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_FOSF));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_COMMENT));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._REPORT_DLINE_COLUMN_CONDITION));
        csvWriter.endOfRow();
    }

    private void printDLine(CsvWriter csvWriter, DLine pacdet) {
        csvWriter.addCell(this.getLiteralValue(pacdet.getCategoryID().toString()));
        csvWriter.addCell(this.getLiteralValue(pacdet.getCategoryType().toString()));
        csvWriter.addCell("");
        csvWriter.addCell("");
        if (pacdet.getRepetition() != 0) {
            csvWriter.addCell(Integer.toString(pacdet.getRepetition()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLiteralValue(pacdet.getComment().toString()));
        csvWriter.addLastCell(this.getLiteralValue(pacdet.getCategoryCondition().toString()));
        csvWriter.endOfRow();
    }

    private void printEdLine(CsvWriter csvWriter, EditionLine edline) {
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLiteralValue(edline.getTotalisationType().toString()));
        csvWriter.addCell(this.getLiteralValue(edline.getForeignTotalStructure().toString()));
        csvWriter.addCell("");
        if (edline.getStructureId() != 0) {
            csvWriter.addCell(Integer.toString(edline.getStructureId()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(Integer.toString(edline.getLabelId()));
        csvWriter.addCell(Integer.toString(edline.getJump()));
        csvWriter.addCell(this.getLiteralValue(edline.getJumpType().toString()));
        csvWriter.addCell(this.getLiteralValue(edline.getFunctionToPerform().toString()));
        csvWriter.addLastCell(this.getLiteralValue(edline.getComment().toString()));
        csvWriter.endOfRow();
    }
}

