/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.report.CELine;
import com.ibm.pdp.maf.rpp.pac.report.CompositionCELine;
import com.ibm.pdp.maf.rpp.pac.report.DataElementCELine;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.pac.report.SourceLine;
import com.ibm.pdp.maf.rpp.pac.report.UndefinedDataElementCELine;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.Iterator;
import java.util.List;

public class ReportExportCELines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ReportExportCELines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof PacReport) {
            String type;
            String name;
            String packageName;
            String projectName;
            PacReport et = (PacReport)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = et.getProject(), packageName = et.getPackage(), name = et.getName(), type = et.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for report " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for report " + name);
            }
            Report rpt = (Report)radicalElement;
            List listceline = null;
            listceline = rpt.getCELines();
            this.printHeader(csvWriter);
            for (CELine celine : listceline) {
                boolean editstruc = true;
                int strucID = celine.getStructureID();
                List compolines = celine.getComposition();
                for (CompositionCELine compline : compolines) {
                    if (compline instanceof DataElementCELine) {
                        DataElementCELine deceline = (DataElementCELine)compline;
                        this.printCELine(csvWriter, strucID, editstruc, deceline);
                    }
                    if (compline instanceof UndefinedDataElementCELine) {
                        UndefinedDataElementCELine unceline = (UndefinedDataElementCELine)compline;
                        this.printUnCELine(csvWriter, strucID, editstruc, unceline);
                    }
                    editstruc = false;
                    List listsolines = compline.getSourceLines();
                    if (listsolines == null) continue;
                    Iterator iterator = listsolines.iterator();
                    while (iterator.hasNext()) {
                        SourceLine soline;
                        SourceLine sourcl = soline = (SourceLine)iterator.next();
                        this.printSoLine(csvWriter, sourcl);
                    }
                }
            }
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_STRUCTURE_ID));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_CALLED_ELEMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_CONTINUATION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_OPERATION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_WSPREFIX));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_SOURCE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_CONDITION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_UNDEFINED_ELEMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_FORMAT));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._REPORT_CELINE_COLUMN_BLANK_WZERO));
        csvWriter.endOfRow();
    }

    private void printCELine(CsvWriter csvWriter, int strucID, boolean editstruc, DataElementCELine deceline) {
        if (editstruc) {
            if (strucID != 0) {
                csvWriter.addCell(Integer.toString(strucID));
            } else {
                csvWriter.addCell("");
            }
        }
        if (!editstruc) {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(deceline.getDataElement().getName()));
        if (deceline.getColumn() != 0) {
            csvWriter.addLastCell(Integer.toString(deceline.getColumn()));
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }

    private void printUnCELine(CsvWriter csvWriter, int strucID, boolean editstruc, UndefinedDataElementCELine unceline) {
        if (editstruc) {
            if (strucID != 0) {
                csvWriter.addCell(Integer.toString(strucID));
            } else {
                csvWriter.addCell("");
            }
        }
        if (!editstruc) {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(unceline.getName().toString()));
        if (unceline.getColumn() != 0) {
            csvWriter.addCell(Integer.toString(unceline.getColumn()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLiteralValue(unceline.getName().toString()));
        csvWriter.addCell(this.getLiteralValue(unceline.getFormat().toString()));
        if (unceline.isBlankWhenZero()) {
            csvWriter.addLastCell("Z");
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }

    private void printSoLine(CsvWriter csvWriter, SourceLine sourcl) {
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell("");
        csvWriter.addCell(this.getLiteralValue(sourcl.getContinued().toString()));
        csvWriter.addCell(this.getLiteralValue(sourcl.getOperation().toString()));
        csvWriter.addCell(this.getLiteralValue(sourcl.getWSPrefix().toString()));
        csvWriter.addCell(this.getLiteralValue(sourcl.getSource().toString()));
        csvWriter.addLastCell(this.getLiteralValue(sourcl.getCondition().toString()));
        csvWriter.endOfRow();
    }
}

