/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.Line;
import com.ibm.pdp.maf.rpp.kernel.MetaEntity;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.UserEntity;
import com.ibm.pdp.maf.rpp.pac.common.AbstractRadicalElement;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.InputAidGLine;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElement;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.List;

public class RadicalEntityExportGCLines<GCLine>
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public RadicalEntityExportGCLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        RadicalElement radicalElement;
        RadicalEntity re = this.getRadicalEntity();
        IMAFModelService mafService = MAFModelManager.getServiceInstance();
        String projectName = re.getProject();
        String packageName = re.getPackage();
        String name = re.getName();
        String type = re.eClass().getName().toLowerCase();
        if (re instanceof com.ibm.pdp.mdl.kernel.UserEntity) {
            com.ibm.pdp.mdl.kernel.UserEntity mdlue = (com.ibm.pdp.mdl.kernel.UserEntity)re;
            name = String.valueOf(name) + "." + mdlue.getMetaEntity().getName();
        }
        if ((radicalElement = mafService.getRadicalElement(projectName, packageName, name, type)) == null) {
            System.err.println("IMAFModelService's RadicalElement is null for report " + name);
            throw new RuntimeException("IMAFModelService's RadicalElement is null for report " + name);
        }
        if (radicalElement instanceof MetaEntity || radicalElement instanceof UserEntity) {
            this.printHeader(csvWriter);
            List listme = null;
            if (radicalElement instanceof MetaEntity) {
                listme = ((MetaEntity)radicalElement).getGCLines();
            }
            if (radicalElement instanceof UserEntity) {
                listme = ((UserEntity)radicalElement).getGCLines();
            }
            for (Line line : listme) {
                if (line instanceof InputAidGLine) {
                    InputAidGLine iagline = (InputAidGLine)line;
                    StringBuffer sb = new StringBuffer();
                    String data = iagline.getData().toString();
                    if (data.length() > 60) {
                        sb.append(data.substring(0, 55)).append("...]");
                    } else {
                        sb.append(data);
                    }
                    this.printIALine(csvWriter, iagline, sb);
                    continue;
                }
                this.printGLineme(csvWriter, line);
            }
        } else {
            List list = null;
            list = radicalElement instanceof DataElement ? ((DataElement)radicalElement).getGCLines() : ((AbstractRadicalElement)radicalElement).getGCLines();
            this.printHeader(csvWriter);
            for (GLine gline : list) {
                if (gline instanceof InputAidGLine) {
                    InputAidGLine iagline = (InputAidGLine)gline;
                    StringBuffer sb = new StringBuffer();
                    String data = iagline.getData().toString();
                    if (data.length() > 60) {
                        sb.append(data.substring(0, 55)).append("...]");
                    } else {
                        sb.append(data);
                    }
                    this.printIALine(csvWriter, iagline, sb);
                    continue;
                }
                this.printGCLine(csvWriter, gline);
            }
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.endOfRow();
    }

    private void printGCLine(CsvWriter csvWriter, GLine gline) {
        csvWriter.addCell(this.getLiteralValue(gline.getLineType()));
        if (gline.getDescription() != null) {
            csvWriter.addCell(this.getLiteralValue(gline.getDescription().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (gline.getLinkedEntity() != null) {
            csvWriter.addLastCell(this.getLiteralValue(gline.getLinkedEntity().toString()));
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }

    private void printGLineme(CsvWriter csvWriter, Line line) {
        csvWriter.addCell(this.getLiteralValue(line.getLineType()));
        if (line.getDescription() != null) {
            csvWriter.addCell(this.getLiteralValue(line.getDescription().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (line.getLinkedEntity() != null) {
            csvWriter.addLastCell(this.getLiteralValue(line.getLinkedEntity().toString()));
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }

    private void printIALine(CsvWriter csvWriter, InputAidGLine iagline, StringBuffer sb) {
        csvWriter.addCell("I");
        csvWriter.addCell(sb.toString());
        if (iagline.getInputAid() != null) {
            csvWriter.addLastCell(this.getLiteralValue(iagline.getInputAid().getName().toString()));
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }
}

