/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import org.eclipse.emf.common.util.EList;

public class RadicalEntityExportCPLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2020   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public RadicalEntityExportCPLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        EList list = null;
        if (this.getRadicalEntity() instanceof PacProgram) {
            list = ((PacProgram)this.getRadicalEntity()).getCPLines();
        } else if (this.getRadicalEntity() instanceof PacScreen) {
            list = ((PacScreen)this.getRadicalEntity()).getCPLines();
        } else if (this.getRadicalEntity() instanceof PacServer) {
            list = ((PacServer)this.getRadicalEntity()).getCPLines();
        }
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CPLINE_MACRO_CALL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CPLINE_MACRO_LINE_NUMBER));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CPLINE_MACRO_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._COMMENT_HEADER));
        csvWriter.addCell("$1");
        csvWriter.addCell("$2");
        csvWriter.addCell("$3");
        csvWriter.addCell("$4");
        csvWriter.addCell("$5");
        csvWriter.addCell("$6");
        csvWriter.addCell("$7");
        csvWriter.addCell("$8");
        csvWriter.addCell("$9");
        csvWriter.addCell("$0");
        csvWriter.addCell("$A");
        csvWriter.addCell("$B");
        csvWriter.addCell("$C");
        csvWriter.addCell("$D");
        csvWriter.addCell("$E");
        csvWriter.addCell("$F");
        csvWriter.addCell("$G");
        csvWriter.addCell("$H");
        csvWriter.addCell("$I");
        csvWriter.addLastCell("$J");
        csvWriter.endOfRow();
        for (Object object2 : list) {
            PacCPLine paccpl = (PacCPLine)object2;
            csvWriter.addCell(paccpl.getMacro().getName());
            csvWriter.addCell(Integer.toString(paccpl.getLineNumber()));
            csvWriter.addCell(paccpl.getMacro().getLabel());
            csvWriter.addCell(paccpl.getComment());
            EList listp = paccpl.getParameters();
            for (Object object3 : listp) {
                PacMacroParameter pmp = (PacMacroParameter)object3;
                String value = pmp.getValue();
                if (!"$J".equals(pmp.getId())) {
                    if (value == "") {
                        csvWriter.addCell("");
                        continue;
                    }
                    csvWriter.addCell(value);
                    continue;
                }
                if (value == "") {
                    csvWriter.addLastCell("");
                    continue;
                }
                csvWriter.addLastCell(value);
            }
            csvWriter.endOfRow();
        }
    }
}

