/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCDLine;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacCDLineReport;
import com.ibm.pdp.mdl.pacbase.PacCommonLineDescription;
import com.ibm.pdp.mdl.pacbase.PacDataStructureCall;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReportCall;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import org.eclipse.emf.common.util.EList;

public class ProgramExportCDLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ProgramExportCDLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        EList listcdlines = null;
        if (this.getRadicalEntity() instanceof PacProgram) {
            listcdlines = ((PacProgram)this.getRadicalEntity()).getCDLines();
        }
        this.printHeader(csvWriter);
        for (Object cdline : listcdlines) {
            PacAbstractCDLine pacdl = (PacAbstractCDLine)cdline;
            this.printCDLine(csvWriter, pacdl);
        }
    }

    private void printCDLine(CsvWriter csvWriter, PacAbstractCDLine pacdl) {
        int i = 0;
        String codeInProgram = pacdl.getCommonDescription().getCodeInProgram();
        PacCommonLineDescription pcld = pacdl.getCommonDescription();
        csvWriter.addCell(pcld.getCodeInProgram());
        csvWriter.addCell("");
        csvWriter.addCell(pacdl.getExternalName());
        csvWriter.addCell(String.valueOf(this.getLiteralValue(pcld.getOrganization().toString())) + this.getLiteralValue(pacdl.getAccessMode().toString()) + this.getLiteralValue(pcld.getBlockMode().toString()) + this.getLiteralValue(pacdl.getIOMode().toString()) + this.getLiteralValue(pacdl.getUnitType().toString()));
        csvWriter.addCell(Integer.toString(pacdl.getBlockFactor()));
        csvWriter.addCell(this.getLiteralValue(pacdl.getBlockType().toString()));
        if (pacdl instanceof PacCDLineDataStructure) {
            i = ((PacCDLineDataStructure)pacdl).getBreakLevel();
            if (i < 1) {
                csvWriter.addCell("");
            } else {
                csvWriter.addCell(Integer.toString(i));
            }
            i = ((PacCDLineDataStructure)pacdl).getSyncLevel();
            if (i < 1) {
                csvWriter.addCell("");
            } else {
                csvWriter.addCell(Integer.toString(i));
            }
        } else {
            csvWriter.addCell("");
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(pacdl.getUsage().toString()));
        if (pacdl instanceof PacCDLineDataStructure) {
            csvWriter.addCell(((PacCDLineDataStructure)pacdl).getResultDataStructureCode());
            csvWriter.addCell(((PacCDLineDataStructure)pacdl).getSourceDataStructureCode());
            i = ((PacCDLineDataStructure)pacdl).getTransactionBreakLevel();
            if (i < 1) {
                csvWriter.addCell("");
            } else {
                csvWriter.addCell(Integer.toString(i));
            }
        } else {
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
        }
        csvWriter.addCell(pacdl.getPhysicalUnitType());
        csvWriter.addCell(this.getLiteralValue(pacdl.getPhysicalUnitTypeComplement().toString()));
        if (pacdl instanceof PacCDLineDataStructure) {
            csvWriter.addCell(((PacCDLineDataStructure)pacdl).getSortKeys());
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(pcld.getFormatType().toString()));
        csvWriter.addCell(pcld.getSubScheme().toString());
        csvWriter.addCell(this.getLiteralValue(pcld.getGeneratedDescriptionType().toString()));
        csvWriter.addCell(this.getLiteralValue(pcld.getCobolRecordLevel().toString()));
        csvWriter.addCell("");
        if (pacdl instanceof PacCDLineDataStructure) {
            csvWriter.addCell(((PacCDLineDataStructure)pacdl).getFileStatus());
            csvWriter.addCell(((PacCDLineDataStructure)pacdl).getAccessKeyDataElementCode());
            csvWriter.addLastCell(((PacCDLineDataStructure)pacdl).getRecordTypeDataElementCode());
        } else {
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
        if (pacdl instanceof PacCDLineDataStructure) {
            this.printDataStructureCalls(csvWriter, pacdl, codeInProgram, pcld);
        } else if (pacdl instanceof PacCDLineReport) {
            this.printReportCalls(csvWriter, pacdl, codeInProgram);
        }
    }

    private void printDataStructureCalls(CsvWriter csvWriter, PacAbstractCDLine pacdl, String codeInProgram, PacCommonLineDescription pcld) {
        EList listdsc = ((PacCDLineDataStructure)pacdl).getDataStructureCalls();
        for (Object dataStructure : listdsc) {
            PacDataStructureCall pdsc = (PacDataStructureCall)dataStructure;
            csvWriter.addCell(pcld.getCodeInProgram());
            csvWriter.addCell(pdsc.getDataStructure().getName());
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            if (pdsc.getCobolPosition().equals("00")) {
                csvWriter.addCell("");
            } else {
                csvWriter.addCell(pdsc.getCobolPosition());
            }
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addLastCell("");
            csvWriter.endOfRow();
            this.printSegmentCalls(csvWriter, codeInProgram, pdsc);
        }
    }

    private void printSegmentCalls(CsvWriter csvWriter, String codeInProgram, PacDataStructureCall pdsc) {
        EList listseg = pdsc.getSegmentCalls();
        for (Object seg : listseg) {
            PacSegmentCall psc = (PacSegmentCall)seg;
            String segmentCodeInProgram = psc.getCodeInProgram();
            String segmentName = psc.getSegment().getName();
            String selection = "";
            if (segmentCodeInProgram == null || segmentCodeInProgram.equals("")) {
                segmentCodeInProgram = segmentName.substring(2);
            } else if (!segmentCodeInProgram.endsWith(segmentName.substring(2))) {
                selection = String.valueOf(segmentName.substring(2)) + "=" + segmentCodeInProgram;
            }
            csvWriter.addCell(String.valueOf(codeInProgram) + segmentCodeInProgram);
            csvWriter.addCell(segmentName);
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell(selection);
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addLastCell("");
            csvWriter.endOfRow();
        }
    }

    private void printReportCalls(CsvWriter csvWriter, PacAbstractCDLine pacdl, String codeInProgram) {
        EList listreport = ((PacCDLineReport)pacdl).getReportCalls();
        for (Object report : listreport) {
            PacReportCall prc = (PacReportCall)report;
            String suffixInProgram = prc.getSuffixInProgram();
            String reportName = prc.getReport().getName();
            String selection = "";
            if (suffixInProgram == null || suffixInProgram.equals("")) {
                suffixInProgram = reportName.substring(2);
            } else if (!reportName.endsWith(suffixInProgram)) {
                selection = String.valueOf(reportName.substring(2)) + "=" + suffixInProgram;
            }
            csvWriter.addCell(String.valueOf(codeInProgram) + suffixInProgram);
            csvWriter.addCell(reportName);
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell(selection);
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addCell("");
            csvWriter.addLastCell("");
            csvWriter.endOfRow();
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_CODE_PROGRAM));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_CODE_REPOSITORY));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_EXTERNALNAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_OAMOU));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_BLOCK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_BREAK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_SYNCHRO));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_USAGE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_RE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_SE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_TXBREAK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_UNIT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_UNITCOMPL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_SELECTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_FORMAT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_RESERVEDCODES));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_RECORDTYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_LEVELNUMBER));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_PLACEMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_STATUSFIELD));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_ACCESSKEY));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._PROGRAM_CDLINE_COLUMN_IDENT));
        csvWriter.endOfRow();
    }
}

