/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.blockbase.AbstractBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.CodasylBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.DCLine;
import com.ibm.pdp.maf.rpp.pac.blockbase.DHLine;
import com.ibm.pdp.maf.rpp.pac.blockbase.DRKLine;
import com.ibm.pdp.maf.rpp.pac.blockbase.DRLine;
import com.ibm.pdp.maf.rpp.pac.blockbase.HierarchicalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.RelationalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.SocrateBlockBase;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.InputAidGLine;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.List;

public class DatabaseBlockExportDLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DatabaseBlockExportDLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof PacBlockBase) {
            List listgglines;
            String type;
            String name;
            String packageName;
            String projectName;
            PacBlockBase bb = (PacBlockBase)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = bb.getProject(), packageName = bb.getPackage(), name = bb.getName(), type = bb.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for report " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for report " + name);
            }
            AbstractBlockBase dbb = (AbstractBlockBase)radicalElement;
            if (dbb instanceof RelationalBlockBase) {
                List listdrline = null;
                listdrline = ((RelationalBlockBase)dbb).getDRLines();
                this.printPRHeader(csvWriter, 8, dbb);
                this.printDRHeader(csvWriter);
                if (listdrline != null) {
                    for (DRLine drline : listdrline) {
                        List listgclines;
                        List listgglines2;
                        List listklines;
                        if (drline != null) {
                            this.printDRLine(csvWriter, drline);
                        }
                        if ((listklines = drline.getDRKLines()) != null) {
                            for (DRKLine kline : listklines) {
                                this.printDRKLine(csvWriter, kline);
                            }
                        }
                        if ((listgglines2 = drline.getGGLines()) != null) {
                            for (GLine gline : listgglines2) {
                                this.printGLine(csvWriter, gline, 8);
                            }
                        }
                        if ((listgclines = drline.getGCLines()) == null) continue;
                        for (GLine gline : listgclines) {
                            this.printGLine(csvWriter, gline, 8);
                        }
                    }
                }
            }
            if (dbb instanceof CodasylBlockBase) {
                List listdcline = null;
                listdcline = ((CodasylBlockBase)dbb).getDCLines();
                this.printPRHeader(csvWriter, 8, dbb);
                this.printDCHeader(csvWriter);
                if (listdcline != null) {
                    for (DCLine dcline : listdcline) {
                        if (dcline != null) {
                            this.printDCLine(csvWriter, dcline);
                        }
                        if ((listgglines = dcline.getGGLines()) == null) continue;
                        for (GLine gline : listgglines) {
                            this.printGLine(csvWriter, gline, 8);
                        }
                    }
                }
            }
            if (dbb instanceof HierarchicalBlockBase || dbb instanceof SocrateBlockBase) {
                List listdhline = null;
                listdhline = ((HierarchicalBlockBase)dbb).getDHLines();
                this.printPRHeader(csvWriter, 7, dbb);
                this.printDHHeader(csvWriter);
                if (listdhline != null) {
                    for (DHLine dhline : listdhline) {
                        if (dhline != null) {
                            this.printDHLine(csvWriter, dhline);
                        }
                        if ((listgglines = dhline.getGGLines()) == null) continue;
                        for (GLine gline : listgglines) {
                            this.printGLine(csvWriter, gline, 7);
                        }
                    }
                }
            }
            ValuesService.clearLsglinebytype();
        }
    }

    private void printPRHeader(CsvWriter csvWriter, int n, AbstractBlockBase dbb) {
        this.printBlankColumns(csvWriter, n);
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GGLINE_EDIT_SECTION_HEADER));
        csvWriter.addCell("");
        csvWriter.addCell("");
        if (dbb instanceof RelationalBlockBase) {
            csvWriter.addCell("");
            csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GCLINE_EDIT_SECTION_HEADER));
        } else {
            csvWriter.addLastCell("");
        }
        csvWriter.endOfRow();
    }

    private void printBlankColumns(CsvWriter csvWriter, int n) {
        int i = 0;
        while (i < n) {
            csvWriter.addCell("");
            ++i;
        }
    }

    private void printGLine(CsvWriter csvWriter, GLine gline, int n) {
        if (ValuesService.isGGblockbase()) {
            this.printBlankColumns(csvWriter, n);
        } else {
            this.printBlankColumns(csvWriter, 12);
        }
        csvWriter.addCell(this.getLiteralValue(gline.getLineType().toString()));
        if (gline.getLineType().contains("I")) {
            CalledIAGLine ia = new CalledIAGLine();
            this.computeCalledIAGLine(gline, ia);
            if (ia != null && ia._isIA) {
                csvWriter.addCell("" + ia._descriptions);
                if (ValuesService.isGGblockbase()) {
                    csvWriter.addCell((String)ValuesService.getLsglinebytype().get(gline));
                }
                csvWriter.addLastCell(ia._name);
            } else {
                csvWriter.addCell(this.textValue(gline.getDescription()));
                csvWriter.addLastCell("");
            }
        } else if (ValuesService.isGGblockbase()) {
            csvWriter.addCell(this.getLiteralValue(gline.getDescription().toString()));
            csvWriter.addLastCell((String)ValuesService.getLsglinebytype().get(gline));
        } else {
            csvWriter.addLastCell(this.getLiteralValue(gline.getDescription().toString()));
        }
        csvWriter.endOfRow();
    }

    private String textValue(String text) {
        if (text == null) {
            return "";
        }
        String doubleQuote = "\"";
        if ((text.startsWith("-") || text.startsWith("=")) && !text.contains(doubleQuote)) {
            return "=(" + doubleQuote + text + doubleQuote + ")";
        }
        return text;
    }

    private void printDRKLine(CsvWriter csvWriter, DRKLine kline) {
        this.printBlankColumns(csvWriter, 6);
        csvWriter.addCell(this.getLiteralValue(kline.getOrderOrActionType().toString()));
        if (kline.getDataElement() != null) {
            csvWriter.addCell(this.getLiteralValue(kline.getDataElement().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.endOfRow();
    }

    private void printDRHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_SQL_RECORD_TYPE_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_DATA_BASE_OBJECT_EXTERNAL_NAME_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_REFERENCED_TABLE_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_TABLE_OR_VIEW_CODE_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_KEY_TYPE_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DRLINE_COMMAND_GENERATION_TYPE_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._KLINE_ORDER_OR_ACTION_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._KLINE_DATA_ELEMENT_COLUMN));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_FROM));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.endOfRow();
    }

    private void printDRLine(CsvWriter csvWriter, DRLine drline) {
        csvWriter.addCell(this.getLiteralValue(drline.getSQLRecordType().toString()));
        csvWriter.addCell(this.getLiteralValue(drline.getExternalName().toString()));
        if (drline.getReferencedTable() != null) {
            csvWriter.addCell(this.getLiteralValue(drline.getReferencedTable().toString()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(drline.getTableOrViewCode().toString()));
        if (drline.getKeyType() != null) {
            csvWriter.addCell(this.getLiteralValue(drline.getKeyType().toString()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addLastCell(this.getLiteralValue(drline.getGenerationTransactionType().toString()));
        csvWriter.endOfRow();
    }

    private void printDCHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_NETWORK_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_DATA_BASE_OBJECT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_SEGMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_CHILD_SEG));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_FROM_SEG));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_METHOD));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_OCC));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DCLINE_AREA_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_FROM));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.endOfRow();
    }

    private void printDCLine(CsvWriter csvWriter, DCLine dcline) {
        csvWriter.addCell(this.getLiteralValue(dcline.getNetworkRecordType().toString()));
        csvWriter.addCell(this.getLiteralValue(dcline.getDatabaseObjectName().toString()));
        if (dcline.getSegment() != null) {
            csvWriter.addCell(this.getLiteralValue(dcline.getSegment().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (dcline.getChildSegment() != null) {
            csvWriter.addCell(this.getLiteralValue(dcline.getChildSegment().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (dcline.getFromSegment() != null) {
            csvWriter.addCell(this.getLiteralValue(dcline.getFromSegment().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(dcline.getMethodName().toString()));
        csvWriter.addCell(Integer.toString(dcline.getNumberOfOccurencesOfSets()));
        csvWriter.addLastCell(this.getLiteralValue(dcline.getAreaNameOrSetNameOrComment().toString()));
        csvWriter.endOfRow();
    }

    private void printDHHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_DATABASE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_SEGMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_PARENT_SEGMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_RELATION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_KEY_INDICATOR_OPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_ESTIMATED_LINE_NB));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DHLINE_COMMENT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_DESCRIPTION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GLINE_FROM));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._GLINE_INPUTAID));
        csvWriter.endOfRow();
    }

    private void printDHLine(CsvWriter csvWriter, DHLine dhline) {
        if (dhline.getPCBorPSBCode() != null) {
            csvWriter.addCell(this.getLiteralValue(dhline.getPCBorPSBCode().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (dhline.getSegment() != null) {
            csvWriter.addCell(this.getLiteralValue(dhline.getSegment().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        if (dhline.getParentSegment() != null) {
            csvWriter.addCell(this.getLiteralValue(dhline.getParentSegment().getName().toString()));
        } else {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(dhline.getRelationCode().toString()));
        csvWriter.addCell(this.getLiteralValue(dhline.getKeyIndicatorOrOption().toString()));
        csvWriter.addCell(Integer.toString(dhline.getEstimatedNumberOfLink()));
        csvWriter.addLastCell(this.getLiteralValue(dhline.getCommentsOrRelationShipOrKeyLength().toString()));
        csvWriter.endOfRow();
    }

    private void computeCalledIAGLine(GLine gLine, CalledIAGLine ia) {
        if (gLine instanceof InputAidGLine) {
            ia._isIA = true;
            ia._descriptions = ((InputAidGLine)gLine).getData();
            ia._name = ((InputAidGLine)gLine).getInputAid().getName();
        } else {
            ia._isIA = false;
        }
    }

    private class CalledIAGLine {
        public boolean _isIA;
        public String _name;
        public List<String> _descriptions;

        private CalledIAGLine() {
        }
    }
}

