/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.datastructure.DataStructure;
import com.ibm.pdp.maf.rpp.pac.datastructure.LSLine;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalView;
import com.ibm.pdp.maf.rpp.pac.segment.MonoStructureSegment;
import com.ibm.pdp.maf.rpp.pac.segment.StandardSegment;
import com.ibm.pdp.maf.rpp.pac.segment.Table;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.List;

public class DataUnitExportLSLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DataUnitExportLSLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof DataUnit) {
            String type;
            String name;
            String packageName;
            String projectName;
            DataUnit du = (DataUnit)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = du.getProject(), packageName = du.getPackage(), name = du.getName(), type = du.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for data unit " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for data unit " + name);
            }
            DataStructure ds = (DataStructure)radicalElement;
            List listlsline = ds.getLSLines2();
            String lasttype = "";
            for (Object lsline : listlsline) {
                LSLine pacls = (LSLine)lsline;
                AbstractSegment segment = pacls.getSegment();
                if (segment instanceof LogicalView) {
                    LogicalView lv = (LogicalView)segment;
                    if (!"L".equals(lasttype)) {
                        this.printHeaderlv(csvWriter);
                        lasttype = "L";
                    }
                    this.printLSLinelv(csvWriter, lv);
                }
                if (segment instanceof StandardSegment || segment instanceof MonoStructureSegment) {
                    StandardSegment seg;
                    if (!"S".equals(lasttype)) {
                        this.printHeaderseg(csvWriter);
                        lasttype = "S";
                    }
                    if (segment instanceof StandardSegment) {
                        seg = (StandardSegment)segment;
                        this.printLSLineforStdseg(csvWriter, seg);
                    } else if (segment instanceof MonoStructureSegment) {
                        seg = (MonoStructureSegment)segment;
                        this.printLSLineforMoStrseg(csvWriter, (MonoStructureSegment)seg);
                    }
                }
                if (!(segment instanceof Table)) continue;
                Table ta = (Table)segment;
                if (!"T".equals(lasttype)) {
                    this.printHeaderta(csvWriter);
                    lasttype = "T";
                }
                this.printLSLineta(csvWriter, ta);
            }
        }
    }

    private void printHeaderlv(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SEGMENT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_TYP));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._LOGICAL_VIEW_TRANSFER));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_OCCUR));
        csvWriter.endOfRow();
    }

    private void printLSLinelv(CsvWriter csvWriter, LogicalView lv) {
        csvWriter.addCell(this.getLiteralValue(lv.getName().toString()));
        csvWriter.addCell(this.getLiteralValue(lv.getLabel().toString()));
        csvWriter.addCell(this.getLiteralValue(lv.getType().toString()));
        csvWriter.addCell(this.getLiteralValue(lv.getTransferDirection().toString()));
        csvWriter.addLastCell(Integer.toString(lv.getTableSize()));
        csvWriter.endOfRow();
    }

    private void printHeaderseg(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SEGMENT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_TYP));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._STRUCTURE_COD));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_TABLE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_OCCUR));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._ACTION_COD));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._CREAT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._UPDAT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DELET));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._UPDAT4));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._UPDAT5));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._UPDAT6));
        csvWriter.endOfRow();
    }

    private void printLSLineforStdseg(CsvWriter csvWriter, StandardSegment seg) {
        csvWriter.addCell(this.getLiteralValue(seg.getName().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getLabel().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getType().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getStructureCodeValue().toString()));
        csvWriter.addCell(Integer.toString(seg.getTableSize()));
        csvWriter.addCell(Integer.toString(seg.getOccurrencesNumber()));
        csvWriter.addCell(this.getLiteralValue(seg.getActionCodeValue().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getPresenceInCreation().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getPresenceInModification().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getPresenceInDeletion().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getPresenceInType4().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getPresenceInType5().toString()));
        csvWriter.addLastCell(this.getLiteralValue(seg.getPresenceInType6().toString()));
        csvWriter.endOfRow();
    }

    private void printLSLineforMoStrseg(CsvWriter csvWriter, MonoStructureSegment seg) {
        csvWriter.addCell(this.getLiteralValue(seg.getName().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getLabel().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getType().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getStructureCode().toString()));
        csvWriter.addCell(Integer.toString(seg.getTableSize()));
        csvWriter.addCell(Integer.toString(seg.getOccurrencesNumber()));
        csvWriter.addCell(this.getLiteralValue(seg.getActionCode().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getCreationCode().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getModificationCode().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getDeletionCode().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getType4Code().toString()));
        csvWriter.addCell(this.getLiteralValue(seg.getType5Code().toString()));
        csvWriter.addLastCell(this.getLiteralValue(seg.getType6Code().toString()));
        csvWriter.endOfRow();
    }

    private void printHeaderta(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SEGMENT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_LABEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_TYP));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SEGMENT_OCCUR));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._PAC_TABLE_TABLE_NUMB));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GENERATION_SECTION_PROJECT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._GENERATION_SECTION_FOLDER));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._SSLINE_SECTION_HEADER));
        csvWriter.endOfRow();
    }

    private void printLSLineta(CsvWriter csvWriter, Table ta) {
        csvWriter.addCell(this.getLiteralValue(ta.getName().toString()));
        csvWriter.addCell(this.getLiteralValue(ta.getLabel().toString()));
        csvWriter.addCell(this.getLiteralValue(ta.getType().toString()));
        csvWriter.addCell(Integer.toString(ta.getTableSize()));
        csvWriter.addCell(this.getLiteralValue(ta.getTableNumber().toString()));
        csvWriter.addCell(this.getLiteralValue(ta.getGenerateProject().toString()));
        csvWriter.addLastCell(this.getLiteralValue(ta.getGenerateFolder().toString()));
        csvWriter.endOfRow();
    }
}

