/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElementDescription;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;
import java.util.List;

public class DataElementExportDLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DataElementExportDLines(RadicalEntity re, String fileName) {
        super(re, fileName);
    }

    @Override
    public void exportToCsv(CsvWriter csvWriter) {
        if (this.getRadicalEntity() instanceof DataElement) {
            String type;
            String name;
            String packageName;
            String projectName;
            DataElement de = (DataElement)this.getRadicalEntity();
            IMAFModelService mafService = MAFModelManager.getServiceInstance();
            RadicalElement radicalElement = mafService.getRadicalElement(projectName = de.getProject(), packageName = de.getPackage(), name = de.getName(), type = de.eClass().getName().toLowerCase());
            if (radicalElement == null) {
                System.err.println("IMAFModelService's RadicalElement is null for data element " + name);
                throw new RuntimeException("IMAFModelService's RadicalElement is null for data element " + name);
            }
            com.ibm.pdp.maf.rpp.pac.dataelement.DataElement datae = (com.ibm.pdp.maf.rpp.pac.dataelement.DataElement)radicalElement;
            List listdline = datae.getDLines();
            this.printHeader(csvWriter);
            for (Object dline : listdline) {
                DataElementDescription pacdde = (DataElementDescription)dline;
                this.printDLine(csvWriter, pacdde);
            }
        }
    }

    private void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._DLINE_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._MORE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._ALLOWED_VALUES));
        csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._DLINE_DESCRIPTION));
        csvWriter.endOfRow();
    }

    private void printDLine(CsvWriter csvWriter, DataElementDescription pacdde) {
        csvWriter.addCell(this.getLiteralValue(pacdde.getLineType().toString()));
        csvWriter.addCell(this.getLiteralValue(pacdde.getMore().toString()));
        csvWriter.addCell(this.getLiteralValue(pacdde.getAllowedValues().toString()));
        csvWriter.addLastCell(this.getLiteralValue(pacdde.getDescription().toString()));
        csvWriter.endOfRow();
    }
}

