/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.dialog.PacbaseDialogLabel;
import com.ibm.pdp.pac.description.PacDescriptionLabel;
import com.ibm.pdp.util.csv.CsvWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _BUFFER_SIZE = 10000;
    private String fileExternalName;
    private RadicalEntity re;

    public String getFileExternalName() {
        return this.fileExternalName;
    }

    public RadicalEntity getRadicalEntity() {
        return this.re;
    }

    AbstractRadicalEntityExport(RadicalEntity _re, String _fileExternalName) {
        this.re = _re;
        this.fileExternalName = _fileExternalName;
    }

    public abstract void exportToCsv(CsvWriter var1);

    public byte[] retrieveBytes(IProgressMonitor monitor) throws XMLStreamException {
        ByteArrayOutputStream csvStream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(csvStream), 10000);
        String separator = PacDescriptionLabel.getString(PacDescriptionLabel._CSV_SEPARATOR);
        char csvSep = ',';
        if (separator.length() > 0) {
            csvSep = separator.charAt(0);
        }
        CsvWriter csvWriter = new CsvWriter((Writer)writer, csvSep, '\"', System.getProperty("line.separator"));
        this.exportToCsv(csvWriter);
        csvWriter.close();
        return csvStream.toByteArray();
    }

    public IStatus writeFile(byte[] bytes) {
        try {
            FileOutputStream fos = this.createExternalFile(this.fileExternalName);
            BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
            outputStreamBuffer.write(bytes);
            outputStreamBuffer.close();
            fos.close();
        }
        catch (IOException e) {
            Object[] array = new String[]{this.fileExternalName, e.getMessage()};
            String msg = PacbaseDialogLabel.getString((String)PacbaseDialogLabel._FILE_ACCESS, (Object[])array);
            return new Status(4, "org.eclipse.ui", 0, msg, null);
        }
        return null;
    }

    private FileOutputStream createExternalFile(String fileName) throws FileNotFoundException {
        return new FileOutputStream(fileName);
    }

    public String getLabelValue(String label) {
        if (label.endsWith("\u00a3")) {
            return label.substring(0, label.length() - 1);
        }
        return label;
    }

    public String getLiteralValue(String literal) {
        if (literal.equals("_None") || literal.equals("NONE") || literal.equals("_NONE") || literal.equals("_BLANK") || literal.equals("BLANK")) {
            return "";
        }
        if (literal.equals("_STAR") || literal.equals("STAR")) {
            return "*";
        }
        if (literal.equals("_PLUS") || literal.equals("PLUS")) {
            return "+";
        }
        if (literal.equals("_TIRET") || literal.equals("TIRET")) {
            return "-";
        }
        if (literal.equals("_SLASH")) {
            return "/";
        }
        if (literal.startsWith("_")) {
            return literal.substring(1);
        }
        return literal;
    }

    public String getLevelValue(int level) {
        String label = "";
        if (level != 10) {
            label = String.valueOf(level);
        }
        return label;
    }
}

