/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.description;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCSLine;
import com.ibm.pdp.mdl.pacbase.PacCSLineDataElementCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineServerCall;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.editor.PacbaseEditorLabel;
import com.ibm.pdp.mdl.pacbase.impl.PacCSLineLogicalViewCallImpl;
import com.ibm.pdp.pac.description.AbstractRadicalEntityExport;
import com.ibm.pdp.util.csv.CsvWriter;

public abstract class AbstractExportCSLines
extends AbstractRadicalEntityExport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    AbstractExportCSLines(RadicalEntity _re, String _fileExternalName) {
        super(_re, _fileExternalName);
    }

    public void printCSLine(CsvWriter csvWriter, PacAbstractCSLine pacsl) {
        csvWriter.addCell(this.getLiteralValue(pacsl.getSegmentCode().toString()));
        csvWriter.addCell(Integer.toString(pacsl.getLineNumber()));
        csvWriter.addCell(this.getLiteralValue(pacsl.getCategoryNature().toString()));
        csvWriter.addCell(this.getLiteralValue(pacsl.getGenerationLimit().toString()));
        if (this.getRadicalEntity() instanceof PacServer) {
            csvWriter.addCell(this.getLiteralValue(pacsl.getServerUsageAndOrganization().getReceptionUse().toString()));
            csvWriter.addCell(this.getLiteralValue(pacsl.getServerUsageAndOrganization().getDisplayUse().toString()));
        }
        if (this.getRadicalEntity() instanceof PacScreen) {
            if (AbstractExportCSLines.isClient((PacScreen)this.getRadicalEntity())) {
                csvWriter.addCell(this.getLiteralValue(pacsl.getClientUsageAndOrganization().getReceptionUse().toString()));
                csvWriter.addCell(this.getLiteralValue(pacsl.getClientUsageAndOrganization().getDisplayUse().toString()));
            } else {
                csvWriter.addCell(this.getLiteralValue(pacsl.getReceptionUse().toString()));
                csvWriter.addCell(this.getLiteralValue(pacsl.getDisplayUse().toString()));
            }
        }
        csvWriter.addCell(this.getLiteralValue(pacsl.getPreviousSegmentCode().toString()));
        csvWriter.addCell(this.getLiteralValue(pacsl.getAccessKeySource().toString()));
        if (pacsl instanceof PacCSLineSegmentCall) {
            if (((PacCSLineSegmentCall)pacsl).getDataElement() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineSegmentCall)pacsl).getDataElement().getName()));
            } else if (((PacCSLineSegmentCall)pacsl).getAccessKey() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineSegmentCall)pacsl).getAccessKey()));
            } else {
                csvWriter.addCell("");
            }
        }
        if (pacsl instanceof PacCSLineDataElementCall) {
            if (((PacCSLineDataElementCall)pacsl).getDataElement() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineDataElementCall)pacsl).getDataElement().getName()));
            } else {
                csvWriter.addCell("");
            }
        }
        if (pacsl instanceof PacCSLineLogicalViewCallImpl) {
            if (((PacCSLineLogicalViewCallImpl)pacsl).getDataElement() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineLogicalViewCallImpl)pacsl).getDataElement().getName()));
            } else {
                csvWriter.addCell("");
            }
        }
        if (pacsl instanceof PacCSLineServerCall) {
            if (((PacCSLineServerCall)pacsl).getDataElement() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineServerCall)pacsl).getDataElement().getName()));
            } else {
                csvWriter.addCell("");
            }
        }
        csvWriter.addCell(this.getLiteralValue(pacsl.getControlBreak().toString()));
        if (this.getRadicalEntity() instanceof PacServer) {
            csvWriter.addCell(this.getLiteralValue(pacsl.getServerUsageAndOrganization().getOrganization().toString()));
        }
        if (this.getRadicalEntity() instanceof PacScreen) {
            if (AbstractExportCSLines.isClient((PacScreen)this.getRadicalEntity())) {
                csvWriter.addCell(this.getLiteralValue(pacsl.getClientUsageAndOrganization().getOrganization().toString()));
            } else {
                csvWriter.addCell(this.getLiteralValue(pacsl.getOrganization().toString()));
            }
        }
        csvWriter.addCell(this.getLiteralValue(pacsl.getDescriptionType().toString()));
        csvWriter.addCell(this.getLiteralValue(pacsl.getExternalName().toString()));
        if (pacsl instanceof PacCSLineLogicalViewCallImpl) {
            if (((PacCSLineLogicalViewCallImpl)pacsl).getLogicalView() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineLogicalViewCallImpl)pacsl).getLogicalView().getName()));
            } else {
                csvWriter.addCell(this.getLiteralValue(pacsl.getSegmentCode().toString()));
            }
        }
        if (pacsl instanceof PacCSLineSegmentCall) {
            if (((PacCSLineSegmentCall)pacsl).getSegment() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineSegmentCall)pacsl).getSegment().getName()));
            } else {
                csvWriter.addCell(this.getLiteralValue(pacsl.getSegmentCode().toString()));
            }
        }
        if (pacsl instanceof PacCSLineServerCall) {
            if (((PacCSLineServerCall)pacsl).getSegment() != null) {
                csvWriter.addCell(this.getLiteralValue(((PacCSLineServerCall)pacsl).getSegment().getName()));
            } else {
                csvWriter.addCell(this.getLiteralValue(pacsl.getSegmentCode().toString()));
            }
        }
        if (pacsl instanceof PacCSLineDataElementCall) {
            csvWriter.addCell("");
        }
        csvWriter.addCell(this.getLiteralValue(pacsl.getSubSchema().toString()));
        csvWriter.addCell(this.getLevelValue(pacsl.getGenerateLevel()));
        if (pacsl.getBlockBase() != null) {
            csvWriter.addCell(this.getLiteralValue(pacsl.getBlockBase().getName()));
        } else {
            csvWriter.addCell("");
        }
        if (this.getRadicalEntity() instanceof PacScreen) {
            csvWriter.addLastCell(this.getLiteralValue(pacsl.getRecordTypeValue().toString()));
        } else {
            csvWriter.addCell(this.getLiteralValue(pacsl.getRecordTypeValue().toString()));
        }
        if (pacsl instanceof PacCSLineServerCall) {
            if (((PacCSLineServerCall)pacsl).getServer() != null) {
                csvWriter.addLastCell(this.getLiteralValue(((PacCSLineServerCall)pacsl).getServer().getName()));
            } else {
                csvWriter.addLastCell("");
            }
        }
        csvWriter.endOfRow();
    }

    public void printHeader(CsvWriter csvWriter) {
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SEGMENT_NAME));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_LINE_NUMBER));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_CATEGORY));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_GENERATION_LIMIT));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_RECEPTION_USE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_DISPLAY_USE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_PREVIOUS_SEGMENT_CODE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_ACCESS_KEY_SOURCE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_ACCESS_KEY));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_CONTROL_BREAK));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_ORGANIZATION));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_DESCRIPTION_TYPE));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_EXTERNAL_NAME));
        if (this.getRadicalEntity() instanceof PacServer || this.getRadicalEntity() instanceof PacScreen && AbstractExportCSLines.isClient((PacScreen)this.getRadicalEntity())) {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SERVER_CSLINE_COLUMN_SEGMENT));
        } else {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SEGMENT));
        }
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SUB_SCHEMA));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_GENERATE_LEVEL));
        csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_BLOCK_BASE_NAME));
        if (this.getRadicalEntity() instanceof PacScreen) {
            csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_RECORD_TYPE));
        } else {
            csvWriter.addCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_RECORD_TYPE));
        }
        if (this.getRadicalEntity() instanceof PacServer || this.getRadicalEntity() instanceof PacScreen && AbstractExportCSLines.isClient((PacScreen)this.getRadicalEntity())) {
            csvWriter.addLastCell(this.getLabelValue(PacbaseEditorLabel._SCREEN_CSLINE_COLUMN_SERVER_NAME));
        }
        csvWriter.endOfRow();
    }

    public static boolean isClient(PacScreen scr) {
        if (scr.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
            return false;
        }
        if (scr.getDialogType().equals(PacDialogTypeValues._MW_LITERAL)) {
            return false;
        }
        if (scr.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL) && scr.getDialog().getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
            return false;
        }
        return !scr.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL) || !scr.getDialog().getDialogType().equals(PacDialogTypeValues._MW_LITERAL);
    }
}

