/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.wizard;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pac.migration.help.MigrationHelp2;
import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.wizard.CobolFilesPage;
import com.ibm.pdp.pac.migration.help.wizard.Messages;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MigrationHelpWizard
extends Wizard {
    private CobolFilesPage cobolsFilePage;
    private RadicalEntity re;
    private static String ERROR_WINDOW_TITLE = "Migration help error";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MigrationHelpWizard(RadicalEntity re) {
        this.re = re;
        this.setWindowTitle(Messages.MigrationHelpWizard_Migration_Help);
    }

    public void addPages() {
        super.addPages();
        this.cobolsFilePage = new CobolFilesPage("cobols_page_ID", this.re);
        this.addPage((IWizardPage)this.cobolsFilePage);
    }

    public static void logErr(List<IStatus> statusList, Plugin plugin) {
        ILog log;
        if (plugin == null) {
            plugin = MigrationHelpPlugin.getDefault();
        }
        if ((log = plugin.getLog()) == null) {
            return;
        }
        for (IStatus status : statusList) {
            log.log(status);
        }
    }

    public boolean performFinish() {
        String specificCobolFilePath = this.cobolsFilePage.getSpecificCobolFileName();
        String lightCobolFilePath = this.cobolsFilePage.getLightCobolFileName();
        File file = new File(specificCobolFilePath);
        if (!file.exists()) {
            return false;
        }
        file = new File(lightCobolFilePath);
        if (!(file.exists() || this.re instanceof PacProgram && (((PacProgram)this.re).getVariante() == PacProgramVariantValues._C_LITERAL || ((PacProgram)this.re).getProgramStructure().equals(PacProgramStructureValues._F_LITERAL)))) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return true;
        }
        final MigrationHelp2 mh = new MigrationHelp2(this.re, specificCobolFilePath, lightCobolFilePath, ' ', null, null, ' ', ' ', false, null, false);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Messages.MigrationHelpWizard_Check_cobol", -1);
                List<IStatus> statusList = mh.run(monitor);
                monitor.done();
                if (statusList != null && !statusList.isEmpty()) {
                    String mess = "";
                    boolean hasErrors = false;
                    for (IStatus status : statusList) {
                        if (status.getSeverity() != 4) continue;
                        hasErrors = true;
                        mess = String.valueOf(mess) + status.getMessage() + "\n";
                    }
                    if (hasErrors) {
                        final String message = mess;
                        final List<IStatus> statusList2 = statusList;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MigrationHelpWizard.logErr(statusList2, null);
                                PdpTool.error(null, (String)"ERROR", (String)message);
                            }
                        });
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            Util.rethrow((Throwable)e);
        }
        catch (InterruptedException e) {
            Util.rethrow((Throwable)e);
        }
        return true;
    }
}

