/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.wizard;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pac.migration.help.wizard.Messages;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CobolFilesPage
extends WizardPage {
    private Text _cobolFileName;
    private Button _cobolFileNameButton;
    private Text _lightCobolFileName;
    private Button _lightCobolFileNameButton;
    private RadicalEntity re;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CobolFilesPage(String pageName, RadicalEntity re) {
        super(pageName);
        String title = NLS.bind((String)Messages.CobolFilesPage_Migration_of, (Object[])new String[]{re.getName()});
        this.setTitle(title);
        this.re = re;
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)3, (boolean)false);
        this.setHelp(composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.CobolFilesPage_Cobol_file);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        this._cobolFileName = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._cobolFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CobolFilesPage.this.setPageComplete(CobolFilesPage.this.isPageComplete());
            }
        });
        String pbLabel = Messages.CobolFilesPage_Browse;
        this._cobolFileNameButton = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)true);
        this._cobolFileNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String extensionCbl = "*.cbl";
                String[] extensions = new String[]{extensionCbl};
                FileDialog dialog = new FileDialog(CobolFilesPage.this.getShell(), 36864);
                dialog.setFilterExtensions(extensions);
                String fileName = dialog.open();
                if (fileName != null) {
                    CobolFilesPage.this._cobolFileName.setText(fileName);
                }
            }
        });
        label = new Label(composite, 16384);
        label.setText(Messages.CobolFilesPage_Control_cobol_file);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        this._lightCobolFileName = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._lightCobolFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CobolFilesPage.this.setPageComplete(CobolFilesPage.this.isPageComplete());
            }
        });
        this._lightCobolFileNameButton = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)true);
        this._lightCobolFileNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String extension = "*";
                String[] extensions = new String[]{extension};
                FileDialog dialog = new FileDialog(CobolFilesPage.this.getShell(), 36864);
                dialog.setFilterExtensions(extensions);
                String fileName = dialog.open();
                if (fileName != null) {
                    CobolFilesPage.this._lightCobolFileName.setText(fileName);
                }
            }
        });
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.Migration_01";
    }

    public String getLightCobolFileName() {
        return this._lightCobolFileName.getText();
    }

    public String getSpecificCobolFileName() {
        return this._cobolFileName.getText();
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        String fileName = this._cobolFileName.getText();
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        int pointIndex = fileName.lastIndexOf(46);
        if (pointIndex == -1) {
            return false;
        }
        int fileNameStart = fileName.lastIndexOf(File.separator);
        if (fileNameStart == -1) {
            return false;
        }
        fileName = this._lightCobolFileName.getText();
        return fileName != null && !fileName.isEmpty() || this.re instanceof PacProgram && (((PacProgram)this.re).getVariante() == PacProgramVariantValues._C_LITERAL || ((PacProgram)this.re).getProgramStructure().equals(PacProgramStructureValues._F_LITERAL));
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }
}

