/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.view;

import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.view.AutomaticValidationAction;
import com.ibm.pdp.pac.migration.help.validation.view.ColumnSortActionGroup;
import com.ibm.pdp.pac.migration.help.validation.view.Messages;
import com.ibm.pdp.pac.migration.help.validation.view.OpenCobolAction;
import com.ibm.pdp.pac.migration.help.validation.view.OpenDesignAction;
import com.ibm.pdp.pac.migration.help.validation.view.RebuildValidationCacheAction;
import com.ibm.pdp.pac.migration.help.validation.view.UnitaryValidationAction;
import com.ibm.pdp.pac.migration.help.validation.view.ValidationCacheLabelProvider;
import com.ibm.pdp.pac.migration.help.validation.view.ValidationManagerContentProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class ValidationManagerView
extends ViewPart
implements PropertyChangeListener {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String HEADER_KEY0 = "Design";
    public static final String HEADER_KEY1 = "Cobol";
    public static final String HEADER_KEY2 = "WarningsNB";
    public static final String HEADER_KEY3 = "FilteredWarningsNB";
    public static final String HEADER_KEY4 = "MetaType";
    private TableViewer viewer;
    private ColumnSortActionGroup _sortActionGroup;
    private AutomaticValidationAction _automaticValidationAction;
    private OpenDesignAction _openDesignAction;
    private OpenCobolAction _openCobolAction;
    private UnitaryValidationAction _unitaryValidationAction;
    private RebuildValidationCacheAction _rebuildCacheAction;
    private TableColumn columnDesign;
    private TableColumn columnGenerated;
    private TableColumn columnWarningNumber;
    private TableColumn columnFilteredWarningNumber;
    private TableColumn columnMetaType;
    private int[] tableColumnDirections = new int[]{1, 1, 1, 1, 1};
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] headers = new String[]{Messages.ValidationManagerView_Design, Messages.ValidationManagerView_Generated_artifact, Messages.ValidationManagerView_Warning_nb, Messages.ValidationManagerView_Filtered_Warning_nb, Messages.ValidationManagerView_Migration_Types};
        String[] headerKeys = new String[]{HEADER_KEY0, HEADER_KEY1, HEADER_KEY2, HEADER_KEY3, HEADER_KEY4};
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ValidationManagerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ValidationCacheLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int size = selection.size();
                String message = size == 0 || size == 1 ? "" : String.valueOf(size) + Messages.ValidationManagerView_items_selected;
                ValidationManagerView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
            }
        });
        this.columnDesign = new TableColumn(table, 0);
        this.columnDesign.setText(headers[0]);
        this.columnDesign.setData((Object)headerKeys[0]);
        this.columnDesign.setMoveable(true);
        class MySelectionListener
        extends SelectionAdapter {
            private int _nature;
            private TableColumn _column;

            MySelectionListener(TableColumn column, int nature) {
                this._nature = nature;
                this._column = column;
            }

            public void widgetSelected(SelectionEvent arg0) {
                Table table = this._column.getParent();
                if (table.getSortColumn() != this._column) {
                    table.setSortColumn(this._column);
                    table.setSortDirection(ValidationManagerView.this.tableColumnDirections[this._nature - 1] == 1 ? 128 : 1024);
                } else {
                    int newDirection;
                    int direction = ValidationManagerView.this.tableColumnDirections[this._nature - 1];
                    ((ValidationManagerView)ValidationManagerView.this).tableColumnDirections[this._nature - 1] = newDirection = direction * -1;
                    if (newDirection == 1) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(1024);
                    }
                }
                ValidationManagerView.this.sort();
            }
        }
        this.columnDesign.addSelectionListener((SelectionListener)new MySelectionListener(this.columnDesign, 1));
        this.columnGenerated = new TableColumn(table, 0);
        this.columnGenerated.setText(headers[1]);
        this.columnGenerated.setData((Object)headerKeys[1]);
        this.columnGenerated.setMoveable(true);
        this.columnGenerated.addSelectionListener((SelectionListener)new MySelectionListener(this.columnGenerated, 2));
        this.columnWarningNumber = new TableColumn(table, 0);
        this.columnWarningNumber.setText(headers[2]);
        this.columnWarningNumber.setData((Object)headerKeys[2]);
        this.columnWarningNumber.setMoveable(true);
        this.columnWarningNumber.addSelectionListener((SelectionListener)new MySelectionListener(this.columnWarningNumber, 3));
        this.columnFilteredWarningNumber = new TableColumn(table, 0);
        this.columnFilteredWarningNumber.setText(headers[3]);
        this.columnFilteredWarningNumber.setData((Object)headerKeys[3]);
        this.columnFilteredWarningNumber.setMoveable(true);
        this.columnFilteredWarningNumber.addSelectionListener((SelectionListener)new MySelectionListener(this.columnFilteredWarningNumber, 4));
        this.columnMetaType = new TableColumn(table, 0);
        this.columnMetaType.setText(headers[4]);
        this.columnMetaType.setData((Object)headerKeys[4]);
        this.columnMetaType.setMoveable(true);
        this.columnMetaType.addSelectionListener((SelectionListener)new MySelectionListener(this.columnMetaType, 5));
        TableViewerColumn lastColumn = new TableViewerColumn(this.viewer, this.columnMetaType);
        lastColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object ob) {
                String label = "";
                if (ob instanceof CacheData) {
                    CacheData cd = (CacheData)ob;
                    int[] metaTypes = cd.getFilteredValidationTypes();
                    if (metaTypes == null) {
                        return label;
                    }
                    StringBuilder s = new StringBuilder();
                    int i = 0;
                    while (i < metaTypes.length) {
                        s.append(metaTypes[i] + 1);
                        s.append(" ");
                        ++i;
                    }
                    return s.toString();
                }
                return label;
            }

            public String getToolTipText(Object ob) {
                String label = "";
                if (ob instanceof CacheData) {
                    CacheData cd = (CacheData)ob;
                    int[] metaTypes = cd.getFilteredValidationTypes();
                    if (metaTypes == null) {
                        return label;
                    }
                    StringBuilder s = new StringBuilder();
                    Validation val = ValidationContoler.getValidation();
                    if (val == null || val.getValidationTypes().size() == 0) {
                        return this.getText(ob);
                    }
                    ArrayList<ValidationType> valTypes = val.getValidationTypes();
                    int i = 0;
                    while (i < metaTypes.length) {
                        s.append(valTypes.get(metaTypes[i]).getName());
                        if (i < metaTypes.length - 1) {
                            s.append("\n");
                        }
                        ++i;
                    }
                    return s.toString();
                }
                return label;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        int[] sortModes = new int[]{1, 2, 3, 4, 5};
        this._sortActionGroup = new ColumnSortActionGroup(this, sortModes);
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        barMenuMgr.setRemoveAllWhenShown(true);
        this.fillActionBarMenu(barMenuMgr);
        barMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                ValidationManagerView.this.fillActionBarMenu(menu);
            }
        });
        table.setSortColumn(this.columnDesign);
        table.setSortDirection(128);
        this._sortActionGroup.check(1, true);
        this.sort();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                ValidationManagerView.this.fillContextMenu(menu);
            }
        });
        Menu contextMenu = menuMgr.createContextMenu((Control)table);
        table.setMenu(contextMenu);
        this.viewer.setInput((Object)ValidationCache.getCache());
        this._sortActionGroup.check(1, true);
        ValidationCache.getCache().addPropertyChangeListener(this);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
        MigrationHelpPlugin.setHelpMechanism(parent, "validation_manager");
    }

    public void setFocus() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int state;
        if (evt.getSource() == ValidationCache.getCache() && evt.getPropertyName().equals("state") && (state = ((Integer)evt.getNewValue()).intValue()) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ValidationManagerView.this.viewer.setInput((Object)ValidationCache.getCache());
                }
            });
        }
    }

    public void dispose() {
        ValidationCache.getCache().removePropertyChangeListener(this);
        super.dispose();
    }

    public void setSorter(int sorterID) {
        Table table = null;
        switch (sorterID) {
            case 1: {
                table = this.columnDesign.getParent();
                table.setSortColumn(this.columnDesign);
                break;
            }
            case 2: {
                table = this.columnDesign.getParent();
                table.setSortColumn(this.columnGenerated);
                break;
            }
            case 3: {
                table = this.columnDesign.getParent();
                table.setSortColumn(this.columnWarningNumber);
                break;
            }
            case 4: {
                table = this.columnDesign.getParent();
                table.setSortColumn(this.columnFilteredWarningNumber);
                break;
            }
            case 5: {
                table = this.columnDesign.getParent();
                table.setSortColumn(this.columnMetaType);
            }
        }
        if (table != null) {
            table.setSortDirection(this.tableColumnDirections[sorterID - 1] == 1 ? 128 : 1024);
        }
        this.sort();
    }

    public void changeDirection() {
        int newDirection;
        Table table = this.columnDesign.getParent();
        int sortID = this.getSortID(table.getSortColumn());
        if (this.tableColumnDirections[sortID - 1] == 1) {
            table.setSortDirection(1024);
        } else {
            table.setSortDirection(128);
        }
        int direction = this.tableColumnDirections[sortID - 1];
        this.tableColumnDirections[sortID - 1] = newDirection = direction * -1;
        this.sort();
    }

    private void fillActionBarMenu(IMenuManager menu) {
        this._sortActionGroup.fillMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean automaticValidation = true;
        StringBuilder stateLabel = new StringBuilder("");
        if (ValidationCache.getCache().getState() != -1) {
            stateLabel.append(" (").append(ValidationCache.getCache().getStateLabel()).append(")");
        } else {
            stateLabel.append("...");
        }
        if (selection == null || selection.size() <= 0) {
            this.getRebuildValidationCacheAction().setText(String.valueOf(Messages.ValidationManagerView_Rebuild) + stateLabel.toString());
            menu.add((IAction)this.getRebuildValidationCacheAction());
            return;
        }
        for (CacheData cd : selection) {
            if (cd.getFilteredMigrationWarningNumber() == 0) continue;
            automaticValidation = false;
            break;
        }
        boolean singleSelection = selection.size() == 1;
        this.getAutomaticValidationAction().setEnabled(automaticValidation);
        this.getUnitaryValidationAction().setEnabled(singleSelection);
        menu.add((IAction)this.getAutomaticValidationAction());
        menu.add((IAction)this.getUnitaryValidationAction());
        menu.add((IContributionItem)new Separator());
        this.getOpenDesignAction().setEnabled(singleSelection);
        this.getOpenCobolAction().setEnabled(singleSelection);
        menu.add((IAction)this.getOpenDesignAction());
        menu.add((IAction)this.getOpenCobolAction());
        menu.add((IContributionItem)new Separator());
        this.getRebuildValidationCacheAction().setText(String.valueOf(Messages.ValidationManagerView_Rebuild) + stateLabel.toString());
        menu.add((IAction)this.getRebuildValidationCacheAction());
    }

    private Action getAutomaticValidationAction() {
        if (this._automaticValidationAction == null) {
            this._automaticValidationAction = new AutomaticValidationAction(this);
        }
        return this._automaticValidationAction;
    }

    private Action getOpenDesignAction() {
        if (this._openDesignAction == null) {
            this._openDesignAction = new OpenDesignAction(this);
        }
        return this._openDesignAction;
    }

    private Action getOpenCobolAction() {
        if (this._openCobolAction == null) {
            this._openCobolAction = new OpenCobolAction(this);
        }
        return this._openCobolAction;
    }

    private Action getUnitaryValidationAction() {
        if (this._unitaryValidationAction == null) {
            this._unitaryValidationAction = new UnitaryValidationAction(this);
        }
        return this._unitaryValidationAction;
    }

    private Action getRebuildValidationCacheAction() {
        if (this._rebuildCacheAction == null) {
            this._rebuildCacheAction = new RebuildValidationCacheAction(this);
        }
        return this._rebuildCacheAction;
    }

    IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public void refresh(boolean resizeColumn) {
        this.viewer.refresh();
        if (resizeColumn) {
            Table table = this.viewer.getTable();
            TableColumn[] tableColumnArray = table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                tc.pack();
                ++n2;
            }
        }
    }

    public void sort() {
        Table table = this.columnDesign.getParent();
        boolean ascending = true;
        if (table.getSortDirection() == 1024) {
            ascending = false;
        }
        TableColumn sortColumn = table.getSortColumn();
        int columnId = this.getSortID(sortColumn);
        ValidationCache.getCache().sortData(columnId, ascending);
        this._sortActionGroup.check(columnId, table.getSortDirection() == 128);
        this.refresh(false);
    }

    private int getSortID(TableColumn column) {
        int columnId = 1;
        if (column == null) {
            return columnId;
        }
        if (column == this.columnGenerated) {
            columnId = 2;
        } else if (column == this.columnWarningNumber) {
            columnId = 3;
        } else if (column == this.columnFilteredWarningNumber) {
            columnId = 4;
        } else if (column == this.columnMetaType) {
            columnId = 5;
        }
        return columnId;
    }
}

