/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.view;

import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.view.Messages;
import com.ibm.pdp.pac.migration.help.validation.view.ValidationManagerView;
import com.ibm.pdp.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class OpenCobolAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ValidationManagerView _view;

    public OpenCobolAction(ValidationManagerView view) {
        this._view = view;
        this.setText(Messages.OpenCobolAction_Open_Cobol);
    }

    public void run() {
        Shell shell = Display.getDefault().getActiveShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        IStructuredSelection selection = this._view.getSelection();
        if (!selection.isEmpty()) {
            CacheData data = (CacheData)selection.getFirstElement();
            this.openArtifactEditor(data.getGeneratedProductFullName());
        }
        shell.setCursor(null);
    }

    private IEditorPart openArtifactEditor(String cobolFileName) {
        IEditorPart editor = null;
        Path path = new Path(cobolFileName);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (resource instanceof IFile && resource.isAccessible()) {
            IFile file = (IFile)resource;
            IWorkbenchPage page = PTExplorerPlugin.getActiveWorkbenchWindow().getActivePage();
            FileEditorInput editorInput = new FileEditorInput(file);
            String editorID = PTExplorerPlugin.getDefault().getEditorID("cbl");
            int matchFlags = 3;
            try {
                editor = page.openEditor((IEditorInput)editorInput, editorID, true, matchFlags);
            }
            catch (PartInitException e) {
                Util.rethrow((Throwable)e);
            }
        }
        return editor;
    }
}

