/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.serialization;

import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationTag;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializer;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ValidationSerializer
implements IValidationTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ByteArrayOutputStream serialize(Validation val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            ArrayList<ValidationType> vals;
            XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(baos, "UTF-8");
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("validation_types");
            xmlWriter.writeAttribute("version", "1.0");
            if (val.getTemplatesFilesPath() != null) {
                xmlWriter.writeAttribute("templates", val.getTemplatesFilesPath());
            }
            if ((vals = val.getValidationTypes()) != null) {
                for (ValidationType valType : vals) {
                    this.serialize(xmlWriter, valType);
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
        return baos;
    }

    private void serialize(XMLStreamWriter xmlWriter, ValidationType valType) throws XMLStreamException {
        ArrayList<ValidationTypeConditionRegex> regexes;
        xmlWriter.writeStartElement("validation_type");
        xmlWriter.writeAttribute("name", valType.getName());
        xmlWriter.writeAttribute("visible", "" + valType.isWarningVisible());
        xmlWriter.writeAttribute("choice", "" + valType.getMigrationChoice());
        xmlWriter.writeStartElement("conditions");
        xmlWriter.writeAttribute("scope", valType.getConditionScope().name());
        ArrayList<ValidationTypeTemplateSelection> templates = valType.getTemplatesSelection();
        if (templates != null) {
            xmlWriter.writeStartElement("templates");
            for (ValidationTypeTemplateSelection templateSelection : templates) {
                xmlWriter.writeStartElement("template");
                if (templateSelection.getHashcode() != null) {
                    xmlWriter.writeStartElement("id");
                    xmlWriter.writeCharacters(templateSelection.getHashcode());
                    xmlWriter.writeEndElement();
                }
                if (templateSelection.getAddedCode() != null) {
                    xmlWriter.writeStartElement("added");
                    xmlWriter.writeCharacters(templateSelection.getAddedCode());
                    xmlWriter.writeEndElement();
                }
                if (templateSelection.getDeletedCode() != null) {
                    xmlWriter.writeStartElement("deleted");
                    xmlWriter.writeCharacters(templateSelection.getDeletedCode());
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        if ((regexes = valType.getRegexList()) != null) {
            xmlWriter.writeStartElement("regexes");
            for (ValidationTypeConditionRegex regex : regexes) {
                xmlWriter.writeStartElement("regex");
                xmlWriter.writeStartElement("regex_PAC");
                xmlWriter.writeCharacters(regex.getRegexForPacbaseCode());
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("regex_RPP");
                xmlWriter.writeCharacters(regex.getRegexForRPPCode());
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    public static void main(String[] args) {
        Validation val2;
        Validation val;
        block17: {
            val = new Validation();
            ArrayList<ValidationType> validationTypes = val.getValidationTypes();
            ValidationType valType = new ValidationType("Zero en plus dans le format RPP  X(xx)  -> X (0xx)", false, 0);
            valType.setConditionScope(ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX);
            ArrayList<ValidationTypeConditionRegex> regexes = valType.getRegexList();
            ValidationTypeConditionRegex regex = new ValidationTypeConditionRegex("^X\\(([0-9]*)\\)$", "^X\\([0]+(g1)\\)");
            regexes.add(regex);
            validationTypes.add(valType);
            valType = new ValidationType("Zero en plus dans le format MIA  X(0xx) -> X (xx)", false, 0);
            valType.setConditionScope(ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX);
            regexes = valType.getRegexList();
            regex = new ValidationTypeConditionRegex("^X\\([0]+([0-9]*)\\)$", "^X\\((g1)\\)");
            regexes.add(regex);
            validationTypes.add(valType);
            valType = new ValidationType("Micro pattern AD MC DATSEP -> 9", false, 0);
            valType.setConditionScope(ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX);
            ArrayList<ValidationTypeTemplateSelection> templates = valType.getTemplatesSelection();
            templates.add(new ValidationTypeTemplateSelection("-733937778"));
            regexes = valType.getRegexList();
            regex = new ValidationTypeConditionRegex("^[ ]*MOVE DATSEP TO DATSEW$", "^[ ]*MOVE '9' TO DATSEW$");
            regexes.add(regex);
            validationTypes.add(valType);
            valType = new ValidationType("Points justifies dans  RPP", false, 0);
            valType.setConditionScope(ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX);
            templates = valType.getTemplatesSelection();
            templates.add(new ValidationTypeTemplateSelection("1543437023"));
            regexes = valType.getRegexList();
            regex = new ValidationTypeConditionRegex("^(.*PICTURE.*)\\n([\\s\\S]*)$", "^(g1)\\.\\n(g2)");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("^[\\s]*(.*COMPUTATIONAL.*)\\n([\\s\\S]*)$", "^[\\s]*(g1)\\.\\n(g2)");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("^[\\s]*(.*BINARY.*)\n([\\s\\S]*)$", "^[\\s]*(g1)\\.\\n(g2");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("^(.*PICTURE.*)\\n(.*PICTURE.*)$", "^(g1)\\.\\n(g2)\\.");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("^.*(PERFORM.*-FN)([\\S\\s]*)$", ".*(g1).(g2)");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("([\\s]*MOVE.*)\\n([\\s\\S]*)", "(g1).\\n(g2)");
            regexes.add(regex);
            regex = new ValidationTypeConditionRegex("([\\s]*MOVE.*)\\n([\\s\\S]*)", "(g1).\n(g2) EXIT.");
            regexes.add(regex);
            validationTypes.add(valType);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream("D:/validation.xml");
                ValidationSerializer x = new ValidationSerializer();
                ByteArrayOutputStream baos = x.serialize(val);
                baos.writeTo(outputStream);
                ((OutputStream)outputStream).close();
            }
            catch (FileNotFoundException e) {
                System.out.println("File D:/validation.xml could not be saved. Error mess : " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("File D:/validation.xml could not be saved. Error mess : " + e.getMessage());
            }
            val2 = new Validation();
            FileInputStream inputStream = null;
            File file = new File("D:/validation.xml");
            try {
                try {
                    inputStream = new FileInputStream(file);
                    ValidationDeserializer valDeser = new ValidationDeserializer();
                    valDeser.deserialize(val2, inputStream);
                }
                catch (FileNotFoundException e) {
                    System.out.println("File D:/validation.xml could not be read. Error mess : " + e.getMessage());
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(ValidationSerializer.compare(val, val2));
    }

    private static boolean compare(Validation val1, Validation val2) {
        if (val1 == null && val2 != null) {
            return false;
        }
        if (val2 == null && val1 != null) {
            return false;
        }
        if (val2 == null && val1 == null) {
            return true;
        }
        String templatesFilepath1 = val1.getTemplatesFilesPath();
        String templatesFilepath2 = val2.getTemplatesFilesPath();
        if (templatesFilepath1 == null ? templatesFilepath2 != null : !templatesFilepath1.equals(templatesFilepath2)) {
            return false;
        }
        ArrayList<ValidationType> valTypes1 = val1.getValidationTypes();
        ArrayList<ValidationType> valTypes2 = val2.getValidationTypes();
        if (valTypes1.size() != valTypes2.size()) {
            return false;
        }
        int i = 0;
        while (i < valTypes1.size()) {
            if (!ValidationSerializer.compare(valTypes1.get(i), valTypes2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compare(ValidationType validationType1, ValidationType validationType2) {
        ArrayList<ValidationTypeConditionRegex> regex2;
        ArrayList<ValidationTypeTemplateSelection> templates2;
        if (validationType1 == null && validationType2 != null) {
            return false;
        }
        if (validationType2 == null && validationType1 != null) {
            return false;
        }
        if (validationType2 == null && validationType1 == null) {
            return true;
        }
        if (!validationType1.getName().equals(validationType2.getName())) {
            return false;
        }
        if (!validationType1.isWarningVisible() == validationType2.isWarningVisible()) {
            return false;
        }
        if (validationType1.getMigrationChoice() != validationType2.getMigrationChoice()) {
            return false;
        }
        if (validationType1.getConditionScope() != validationType2.getConditionScope()) {
            return false;
        }
        ArrayList<ValidationTypeTemplateSelection> templates1 = validationType1.getTemplatesSelection();
        if (templates1.equals(templates2 = validationType2.getTemplatesSelection())) {
            return false;
        }
        ArrayList<ValidationTypeConditionRegex> regex1 = validationType1.getRegexList();
        return regex1.equals(regex2 = validationType2.getRegexList());
    }
}

