/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.serialization;

import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationDeserializer;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationTag;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ValidationDeserializerV1
implements IValidationTag,
IValidationDeserializer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VERSION1 = "1.0";

    @Override
    public void deserialize(Validation validation, InputStream is, XMLStreamReader xmlReader) {
        String localName = "";
        int lineNumber = 0;
        int eventType = xmlReader.getEventType();
        if (eventType == 1 && (localName = xmlReader.getLocalName()).equalsIgnoreCase("validation_types")) {
            int nbOfAtt = xmlReader.getAttributeCount();
            int i = 0;
            while (i < nbOfAtt) {
                String name = xmlReader.getAttributeLocalName(i);
                String value = xmlReader.getAttributeValue(i);
                if (name.equalsIgnoreCase("templates") && value.trim().length() != 0) {
                    validation.setTemplatesFilesPath(value);
                }
                ++i;
            }
        }
        try {
            while (xmlReader.hasNext()) {
                eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("validation_type")) continue;
                    ++lineNumber;
                    String valTypeNname = "";
                    boolean visible = false;
                    int choice = 0;
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("name")) {
                            valTypeNname = value;
                        } else if (name.equalsIgnoreCase("visible")) {
                            visible = !value.equalsIgnoreCase("false");
                        } else if (name.equalsIgnoreCase("choice")) {
                            choice = Integer.parseInt(value);
                        }
                        ++i;
                    }
                    ValidationType valType = new ValidationType(valTypeNname, visible, choice);
                    valType.setLineNumber("" + lineNumber);
                    validation.getValidationTypes().add(valType);
                    this.deserializeValType(valType, is, xmlReader);
                    continue;
                }
                if (eventType == 2) {
                    String qname = xmlReader.getName().getLocalPart();
                    if (!qname.equalsIgnoreCase("validation_types")) continue;
                    return;
                }
                if (eventType != 5 && eventType != 4 && eventType == 12) continue;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
        throw new RuntimeException("Problem while loading Entities information file. ");
    }

    private void deserializeValType(ValidationType valType, InputStream is, XMLStreamReader xmlReader) {
        String localName = "";
        try {
            while (xmlReader.hasNext()) {
                String qname;
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("conditions")) continue;
                    ValidationTypeScope scope = ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX;
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("scope")) {
                            scope = ValidationTypeScope.valueOf(value);
                        }
                        ++i;
                    }
                    valType.setConditionScope(scope);
                    this.deserializeConditions(valType, is, xmlReader);
                    continue;
                }
                if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("validation_type")) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void deserializeConditions(ValidationType valType, InputStream is, XMLStreamReader xmlReader) {
        String localName = "";
        try {
            StringBuilder rppRegex = new StringBuilder();
            StringBuilder pacRegex = new StringBuilder();
            String templateID = null;
            String templateDeleted = null;
            String templateAdded = null;
            while (xmlReader.hasNext()) {
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("template")) continue;
                    rppRegex = new StringBuilder();
                    pacRegex = new StringBuilder();
                    templateID = null;
                    templateDeleted = null;
                    templateAdded = null;
                    continue;
                }
                if (eventType == 2) {
                    String qname = xmlReader.getName().getLocalPart();
                    if (qname.equalsIgnoreCase("conditions")) {
                        return;
                    }
                    if (qname.equalsIgnoreCase("template")) {
                        ValidationTypeTemplateSelection valTypeTemplateSelection = new ValidationTypeTemplateSelection(templateID);
                        if (templateAdded != null) {
                            valTypeTemplateSelection.setAddedCode(templateAdded);
                        }
                        if (templateDeleted != null) {
                            valTypeTemplateSelection.setDeletedCode(templateDeleted);
                        }
                        valType.getTemplatesSelection().add(valTypeTemplateSelection);
                        continue;
                    }
                    if (!qname.equalsIgnoreCase("regex")) continue;
                    valType.getRegexList().add(new ValidationTypeConditionRegex(pacRegex.toString(), rppRegex.toString()));
                    rppRegex = new StringBuilder();
                    pacRegex = new StringBuilder();
                    continue;
                }
                if (eventType != 4) continue;
                String text = xmlReader.getText();
                if (localName.equalsIgnoreCase("id")) {
                    templateID = text;
                    continue;
                }
                if (localName.equalsIgnoreCase("deleted")) {
                    templateDeleted = text;
                    continue;
                }
                if (localName.equalsIgnoreCase("added")) {
                    templateAdded = text;
                    continue;
                }
                if (localName.equalsIgnoreCase("regex_PAC")) {
                    pacRegex.append(text);
                    continue;
                }
                if (!localName.equalsIgnoreCase("regex_RPP")) continue;
                rppRegex.append(text);
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }
}

