/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.serialization;

import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationTag;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializerV1;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ValidationDeserializer
implements IValidationTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void deserialize(Validation validation, InputStream is) {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = null;
        try {
            xmlReader = inputFactory.createXMLStreamReader(is);
            String localName = "";
            ValidationDeserializerV1 deserializer = null;
            boolean finished = false;
            block4: while (xmlReader.hasNext() && !finished) {
                int eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("validation_types")) continue;
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("version")) {
                            if (!value.equalsIgnoreCase("1.0")) {
                                throw new RuntimeException("Unable to find a deserializer able to handle this version of Validation : " + value);
                            }
                            deserializer = new ValidationDeserializerV1();
                            deserializer.deserialize(validation, is, xmlReader);
                            continue block4;
                        }
                        ++i;
                    }
                    continue;
                }
                if (eventType == 2) {
                    String qname = xmlReader.getName().getLocalPart();
                    if (!qname.equalsIgnoreCase("validation_types")) continue;
                    finished = true;
                    continue;
                }
                if (eventType == 5 || eventType == 4 || eventType == 12) continue;
                if (eventType == 8) {
                    return;
                }
                System.out.println("Don't know what to do. Event Type = " + eventType);
            }
            xmlReader.close();
        }
        catch (XMLStreamException f) {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
            Util.rethrow((Throwable)f);
        }
    }
}

