/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.serialization;

import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationTag;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.containers.HashedSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ValidationCacheSerializer
implements IValidationTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public boolean serialize(ValidationCache vc, String fileName) {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = null;
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(fileName);
                BufferedWriter bf = new BufferedWriter(fw);
                xmlWriter = outputFactory.createXMLStreamWriter(bf);
                xmlWriter.writeStartDocument("ISO-8859-1", "1.0");
                xmlWriter.writeStartElement("validation_cache");
                xmlWriter.writeAttribute("version", "1.0");
                this.serialize(vc, xmlWriter);
                xmlWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                Util.rethrow((Throwable)e);
                if (xmlWriter != null) {
                    try {
                        xmlWriter.flush();
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e2) {
                        Util.rethrow((Throwable)e2);
                    }
                }
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException e3) {
                    Util.rethrow((Throwable)e3);
                }
            }
            catch (IOException e) {
                block29: {
                    System.out.println("File " + fileName + " could not be saved. Error mess : " + e.getMessage());
                    if (xmlWriter == null) break block29;
                    try {
                        xmlWriter.flush();
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e4) {
                        Util.rethrow((Throwable)e4);
                    }
                }
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException e5) {
                    Util.rethrow((Throwable)e5);
                }
            }
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    Util.rethrow((Throwable)e);
                }
            }
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
        return true;
    }

    public void serialize(ValidationCache vc, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("state");
        xmlWriter.writeCharacters("" + vc.getState());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("valided_files");
        HashedSet<String> validedFiles = vc.getValidatedPDPFiles();
        for (String file : validedFiles) {
            xmlWriter.writeStartElement("file");
            xmlWriter.writeCharacters(file);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        Map<String, CacheData> filesToValid = vc.getPdpFilesToValidate();
        Iterator<String> keyIterator = filesToValid.keySet().iterator();
        xmlWriter.writeStartElement("files_to_valid");
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            xmlWriter.writeStartElement("file");
            xmlWriter.writeStartElement("name");
            xmlWriter.writeCharacters(key);
            xmlWriter.writeEndElement();
            CacheData cd = filesToValid.get(key);
            this.serialize(cd, xmlWriter);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    public void serialize(CacheData cd, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("generated_file");
        xmlWriter.writeCharacters(cd.getGeneratedProductFullName());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("design");
        xmlWriter.writeCharacters(cd.getDesignName());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("filt_count");
        xmlWriter.writeCharacters("" + cd.getFilteredMigrationWarningNumber());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("count");
        xmlWriter.writeCharacters("" + cd.getMigrationWarningNumber());
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("val_indexes");
        int[] filteredValidationTypeIndexes = cd.getFilteredValidationTypes();
        if (filteredValidationTypeIndexes != null && filteredValidationTypeIndexes.length != 0) {
            int i = 0;
            while (i < filteredValidationTypeIndexes.length) {
                xmlWriter.writeStartElement("index");
                xmlWriter.writeCharacters("" + filteredValidationTypeIndexes[i]);
                xmlWriter.writeEndElement();
                ++i;
            }
        }
        xmlWriter.writeEndElement();
    }
}

