/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.serialization;

import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationCacheDeserializer;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ValidationCacheDeserializerV1
implements IValidationCacheDeserializer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VERSION1 = "1.0";

    @Override
    public void deserialize(ValidationCache vc, InputStream is, XMLStreamReader xmlReader) {
        String localName = "";
        boolean inValidatedFiles = false;
        String key = null;
        String generatedFile = null;
        String design = null;
        int filteredCount = 0;
        int count = 0;
        ArrayList<Integer> filteredValidationTypeIndexes = new ArrayList<Integer>();
        int eventType = xmlReader.getEventType();
        try {
            while (xmlReader.hasNext()) {
                eventType = xmlReader.next();
                if (eventType == 1) {
                    localName = xmlReader.getLocalName();
                    if (!localName.equalsIgnoreCase("valided_files")) continue;
                    inValidatedFiles = true;
                    continue;
                }
                if (eventType == 2) {
                    String qname = xmlReader.getName().getLocalPart();
                    if (qname.equalsIgnoreCase("files_to_valid")) {
                        return;
                    }
                    if (qname.equalsIgnoreCase("valided_files")) {
                        inValidatedFiles = false;
                    }
                    if (!qname.equalsIgnoreCase("file") || inValidatedFiles) continue;
                    CacheData cd = new CacheData();
                    cd.setGeneratedProductFullName(generatedFile);
                    cd.setDesignName(design);
                    cd.setFilteredMigrationWarningNumber(filteredCount);
                    cd.setMigrationWarningNumber(count);
                    int[] filteredValidationTypes = null;
                    if (filteredValidationTypeIndexes.size() != 0) {
                        int i = 0;
                        filteredValidationTypes = new int[filteredValidationTypeIndexes.size()];
                        Iterator iter = filteredValidationTypeIndexes.iterator();
                        while (iter.hasNext()) {
                            filteredValidationTypes[i] = (Integer)iter.next();
                            ++i;
                        }
                    }
                    filteredValidationTypeIndexes.clear();
                    cd.setFilteredValidationTypes(filteredValidationTypes);
                    vc.getPdpFilesToValidate().put(key, cd);
                    continue;
                }
                if (eventType == 5) continue;
                if (eventType == 4) {
                    String text = xmlReader.getText();
                    if (localName.equals("state")) {
                        int state = Integer.parseInt(text);
                        vc.setState(state);
                    }
                    if (localName.equalsIgnoreCase("file")) {
                        vc.getValidatedPDPFiles().add((Object)text);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("name")) {
                        key = text;
                        continue;
                    }
                    if (localName.equalsIgnoreCase("generated_file")) {
                        generatedFile = text;
                        continue;
                    }
                    if (localName.equalsIgnoreCase("design")) {
                        design = text;
                        continue;
                    }
                    if (localName.equalsIgnoreCase("filt_count")) {
                        filteredCount = Integer.parseInt(text);
                        continue;
                    }
                    if (localName.equalsIgnoreCase("count")) {
                        count = Integer.parseInt(text);
                        continue;
                    }
                    if (!localName.equalsIgnoreCase("index")) continue;
                    filteredValidationTypeIndexes.add(Integer.parseInt(text));
                    continue;
                }
                if (eventType == 12) continue;
            }
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
        throw new RuntimeException("Problem while loading Entities information file. ");
    }
}

